/*
 * Decompiled with CFR 0.152.
 */
package org.jivesoftware.smackx.muc;

import java.net.MalformedURLException;
import java.net.URL;
import java.util.List;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.jivesoftware.smack.packet.Stanza;
import org.jivesoftware.smackx.disco.packet.DiscoverInfo;
import org.jivesoftware.smackx.xdata.Form;
import org.jivesoftware.smackx.xdata.FormField;

public class RoomInfo {
    private static final Logger LOGGER = Logger.getLogger(RoomInfo.class.getName());
    private final String room;
    private final String description;
    private final String name;
    private final String subject;
    private final int occupantsCount;
    private final boolean membersOnly;
    private final boolean moderated;
    private final boolean nonanonymous;
    private final boolean passwordProtected;
    private final boolean persistent;
    private final int maxhistoryfetch;
    private final List<String> contactJid;
    private final String lang;
    private final String ldapgroup;
    private final Boolean subjectmod;
    private final URL logs;
    private final String pubsub;
    private final Form form;

    RoomInfo(DiscoverInfo info) {
        this.room = info.getFrom();
        this.membersOnly = info.containsFeature("muc_membersonly");
        this.moderated = info.containsFeature("muc_moderated");
        this.nonanonymous = info.containsFeature("muc_nonanonymous");
        this.passwordProtected = info.containsFeature("muc_passwordprotected");
        this.persistent = info.containsFeature("muc_persistent");
        List<DiscoverInfo.Identity> identities = info.getIdentities();
        if (!identities.isEmpty()) {
            this.name = identities.get(0).getName();
        } else {
            LOGGER.warning("DiscoverInfo does not contain any Identity: " + info.toXML());
            this.name = "";
        }
        String subject = "";
        int occupantsCount = -1;
        String description = "";
        int maxhistoryfetch = -1;
        List<String> contactJid = null;
        String lang = null;
        String ldapgroup = null;
        Boolean subjectmod = null;
        URL logs = null;
        String pubsub = null;
        this.form = Form.getFormFrom((Stanza)info);
        if (this.form != null) {
            FormField pubsubField;
            FormField urlField;
            FormField subjectmodField;
            FormField ldapgroupField;
            FormField langField;
            FormField contactJidField;
            FormField maxhistoryfetchField;
            FormField occCountField;
            FormField subjField;
            FormField descField = this.form.getField("muc#roominfo_description");
            if (descField != null && !descField.getValues().isEmpty()) {
                description = descField.getValues().get(0);
            }
            if ((subjField = this.form.getField("muc#roominfo_subject")) != null && !subjField.getValues().isEmpty()) {
                subject = subjField.getValues().get(0);
            }
            if ((occCountField = this.form.getField("muc#roominfo_occupants")) != null && !occCountField.getValues().isEmpty()) {
                occupantsCount = Integer.parseInt(occCountField.getValues().get(0));
            }
            if ((maxhistoryfetchField = this.form.getField("muc#maxhistoryfetch")) != null && !maxhistoryfetchField.getValues().isEmpty()) {
                maxhistoryfetch = Integer.parseInt(maxhistoryfetchField.getValues().get(0));
            }
            if ((contactJidField = this.form.getField("muc#roominfo_contactjid")) != null && !contactJidField.getValues().isEmpty()) {
                contactJid = contactJidField.getValues();
            }
            if ((langField = this.form.getField("muc#roominfo_lang")) != null && !langField.getValues().isEmpty()) {
                lang = langField.getValues().get(0);
            }
            if ((ldapgroupField = this.form.getField("muc#roominfo_ldapgroup")) != null && !ldapgroupField.getValues().isEmpty()) {
                ldapgroup = ldapgroupField.getValues().get(0);
            }
            if ((subjectmodField = this.form.getField("muc#roominfo_subjectmod")) != null && !subjectmodField.getValues().isEmpty()) {
                subjectmod = Boolean.valueOf(subjectmodField.getValues().get(0));
            }
            if ((urlField = this.form.getField("muc#roominfo_logs")) != null && !urlField.getValues().isEmpty()) {
                String urlString = urlField.getValues().get(0);
                try {
                    logs = new URL(urlString);
                }
                catch (MalformedURLException e) {
                    LOGGER.log(Level.SEVERE, "Could not parse URL", e);
                }
            }
            if ((pubsubField = this.form.getField("muc#roominfo_pubsub")) != null && !pubsubField.getValues().isEmpty()) {
                pubsub = pubsubField.getValues().get(0);
            }
        }
        this.description = description;
        this.subject = subject;
        this.occupantsCount = occupantsCount;
        this.maxhistoryfetch = maxhistoryfetch;
        this.contactJid = contactJid;
        this.lang = lang;
        this.ldapgroup = ldapgroup;
        this.subjectmod = subjectmod;
        this.logs = logs;
        this.pubsub = pubsub;
    }

    public String getRoom() {
        return this.room;
    }

    public String getName() {
        return this.name;
    }

    public String getDescription() {
        return this.description;
    }

    public String getSubject() {
        return this.subject;
    }

    public int getOccupantsCount() {
        return this.occupantsCount;
    }

    public boolean isMembersOnly() {
        return this.membersOnly;
    }

    public boolean isModerated() {
        return this.moderated;
    }

    public boolean isNonanonymous() {
        return this.nonanonymous;
    }

    public boolean isPasswordProtected() {
        return this.passwordProtected;
    }

    public boolean isPersistent() {
        return this.persistent;
    }

    public int getMaxHistoryFetch() {
        return this.maxhistoryfetch;
    }

    public List<String> getContactJids() {
        return this.contactJid;
    }

    public String getLang() {
        return this.lang;
    }

    public String getLdapGroup() {
        return this.ldapgroup;
    }

    public Boolean isSubjectModifiable() {
        return this.subjectmod;
    }

    public String getPubSub() {
        return this.pubsub;
    }

    public URL getLogsUrl() {
        return this.logs;
    }

    public Form getForm() {
        return this.form;
    }
}

