/*
 * Decompiled with CFR 0.152.
 */
package org.renjin.nmath;

import org.renjin.gcc.runtime.Builtins;
import org.renjin.gcc.runtime.Mathlib;
import org.renjin.nmath.dchisq;
import org.renjin.nmath.dpois;

public class dnchisq {
    public static double $dnchisq$eps = 5.0E-15;

    private dnchisq() {
    }

    public static double dnchisq(double d, double d2, double d3, int n) {
        double d4;
        double x2 = 0.0;
        double imax = 0.0;
        double dfmid = 0.0;
        double mid = 0.0;
        if (Builtins.__isnan((double)d) != 0 || Builtins.__isnan((double)d2) != 0 || Builtins.__isnan((double)d3) != 0) {
            d4 = d + d2 + d3;
        } else if (Builtins.__finite((double)d2) == 0 || Builtins.__finite((double)d3) == 0 || d3 < 0.0 || d2 < 0.0) {
            d4 = 0.0 / 0.0;
        } else if (d < 0.0) {
            double iftmp$0 = n != 0 ? -1.0 / 0.0 : 0.0;
            d4 = iftmp$0;
        } else if (d == 0.0 && d2 < 2.0) {
            d4 = 1.0 / 0.0;
        } else if (d3 == 0.0) {
            double iftmp$1;
            if (d2 > 0.0) {
                iftmp$1 = dchisq.dchisq(d, d2, n);
            } else {
                double iftmp$2 = n != 0 ? -1.0 / 0.0 : 0.0;
                iftmp$1 = iftmp$2;
            }
            d4 = iftmp$1;
        } else {
            double d5 = 1.0 / 0.0;
            if (d == d5) {
                double iftmp$3 = n != 0 ? -1.0 / 0.0 : 0.0;
                d4 = iftmp$3;
            } else {
                double d6;
                double ncp2 = d3 * 0.5;
                double d7 = 2.0 - d2;
                double d8 = 2.0 - d2;
                double d9 = d7 * d8;
                double d10 = d3 * 4.0 * d;
                double d11 = Mathlib.sqrt((double)(d9 + d10));
                imax = Mathlib.ceil((double)((d11 - (d6 = d2 + 2.0)) / 4.0));
                if (imax < 0.0) {
                    imax = 0.0;
                }
                if (Builtins.__finite((double)imax) != 0) {
                    dfmid = imax * 2.0 + d2;
                    double d12 = dpois.dpois_raw(imax, ncp2, 0);
                    double d13 = dchisq.dchisq(d, dfmid, 0);
                    mid = d12 * d13;
                } else {
                    mid = 0.0;
                }
                if (mid == 0.0) {
                    if (n != 0 || d3 > 1000.0) {
                        double nl = d2 + d3;
                        double d14 = nl + d3;
                        double ic = nl / d14;
                        double d15 = nl * ic;
                        d4 = dchisq.dchisq(d * ic, d15, n);
                    } else {
                        double iftmp$4 = n != 0 ? -1.0 / 0.0 : 0.0;
                        d4 = iftmp$4;
                    }
                } else {
                    double eps$5;
                    double d16;
                    double d17;
                    double d18;
                    double q;
                    double sum = mid;
                    double term = mid;
                    d2 = dfmid;
                    double i = imax;
                    x2 = d * ncp2;
                    do {
                        q = x2 / (i += 1.0) / d2;
                        d2 += 2.0;
                    } while (q >= 1.0 || (d18 = term * q) > (d17 = (d16 = 1.0 - q) * (eps$5 = $dnchisq$eps)) || (sum += (term *= q)) * 1.0E-10 < term);
                    term = mid;
                    d2 = dfmid;
                    i = imax;
                    while (i != 0.0) {
                        double eps$6;
                        double d19;
                        double d20;
                        double d21;
                        q = i * (d2 -= 2.0) / x2;
                        i -= 1.0;
                        sum += (term *= q);
                        if (q < 1.0 && (d21 = term * q) <= (d20 = (d19 = 1.0 - q) * (eps$6 = $dnchisq$eps))) break;
                    }
                    double iftmp$7 = n != 0 ? Math.log(sum) : sum;
                    d4 = iftmp$7;
                }
            }
        }
        return d4;
    }
}

