/*
 * Decompiled with CFR 0.152.
 */
package org.renjin.nmath;

import org.renjin.gcc.runtime.Mathlib;
import org.renjin.nmath.cospi;

public class gamma_cody {
    public static double[] $Rf_gamma_cody$c = new double[7];
    public static double[] $Rf_gamma_cody$q = new double[8];
    public static double[] $Rf_gamma_cody$p = new double[8];
    public static double $Rf_gamma_cody$xbig;
    public static double $Rf_gamma_cody$sqrtpi;

    private gamma_cody() {
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static double Rf_gamma_cody(double d) {
        double res;
        double ysq = 0.0;
        double yi = 0.0;
        double z = 0.0;
        double y = 0.0;
        double fact = 0.0;
        boolean parity = false;
        int n = 0;
        parity = false;
        fact = 1.0;
        n = 0;
        y = d;
        if (y <= 0.0) {
            y = -d;
            yi = Mathlib.trunc((double)y);
            res = y - yi;
            if (res == 0.0) return 1.0 / 0.0;
            if (Mathlib.trunc((double)(yi * 0.5)) * 2.0 != yi) {
                parity = true;
            }
            double d2 = cospi.sinpi(res);
            fact = -Math.PI / d2;
            y += 1.0;
        }
        if (y < 2.220446049250313E-16) {
            if (!(y >= Double.MIN_NORMAL)) return 1.0 / 0.0;
            res = 1.0 / y;
        } else if (y < 12.0) {
            yi = y;
            if (y < 1.0) {
                z = y;
                y += 1.0;
            } else {
                n = (int)y + -1;
                double d3 = n;
                z = (y -= d3) - 1.0;
            }
            double xnum = 0.0;
            double xden = 1.0;
            int i = 0;
            while (i <= 7) {
                xnum = ($Rf_gamma_cody$p[0 + i] + xnum) * z;
                double d4 = xden * z;
                double d5 = $Rf_gamma_cody$q[0 + i];
                xden = d4 + d5;
                ++i;
            }
            res = xnum / xden + 1.0;
            if (yi < y) {
                res /= yi;
            } else if (yi > y) {
                i = 0;
                while (i < n) {
                    res *= y;
                    y += 1.0;
                    ++i;
                }
            }
        } else {
            double xbig$0 = $Rf_gamma_cody$xbig;
            if (!(y <= xbig$0)) return 1.0 / 0.0;
            double d6 = y;
            ysq = d6 * d6;
            double sum = $Rf_gamma_cody$c[6];
            int i = 0;
            while (i <= 5) {
                double d7 = sum / ysq;
                double d8 = $Rf_gamma_cody$c[0 + i];
                sum = d7 + d8;
                ++i;
            }
            double d9 = sum / y - y;
            double sqrtpi$1 = $Rf_gamma_cody$sqrtpi;
            sum = d9 + sqrtpi$1;
            double d10 = y - 0.5;
            double d11 = Math.log(y);
            sum = d10 * d11 + sum;
            res = Math.exp(sum);
        }
        if (parity) {
            res = -res;
        }
        if (fact == 1.0) return res;
        res = fact / res;
        return res;
    }

    static {
        System.arraycopy(new double[]{-0.001910444077728, 8.4171387781295E-4, -5.952379913043012E-4, 7.936507935003503E-4, -0.0027777777777776816, 0.08333333333333333, 0.0057083835261}, 0, $Rf_gamma_cody$c, 0, 7);
        System.arraycopy(new double[]{-30.840230011973897, 315.35062697960416, -1015.1563674902192, -3107.771671572311, 22538.11842098015, 4755.846277527881, -134659.9598649693, -115132.25967555349}, 0, $Rf_gamma_cody$q, 0, 8);
        System.arraycopy(new double[]{-1.716185138865495, 24.76565080557592, -379.80425647094563, 629.3311553128184, 866.9662027904133, -31451.272968848367, -36144.413418691176, 66456.14382024054}, 0, $Rf_gamma_cody$p, 0, 8);
        $Rf_gamma_cody$xbig = 171.624;
        $Rf_gamma_cody$sqrtpi = 0.9189385332046728;
    }
}

