/*
 * Decompiled with CFR 0.152.
 */
package org.renjin.nmath;

import org.renjin.gcc.runtime.Builtins;
import org.renjin.gcc.runtime.Mathlib;
import org.renjin.nmath.gamma;
import org.renjin.nmath.lgamma;
import org.renjin.nmath.lgammacor;

public class lbeta {
    private lbeta() {
    }

    public static double lbeta(double d, double d2) {
        double d3;
        if (Builtins.__isnan((double)d) != 0 || Builtins.__isnan((double)d2) != 0) {
            d3 = d + d2;
        } else {
            double q;
            double p = q = d;
            if (d2 < p) {
                p = d2;
            }
            if (d2 > q) {
                q = d2;
            }
            if (p < 0.0) {
                d3 = 0.0 / 0.0;
            } else if (p == 0.0) {
                d3 = 1.0 / 0.0;
            } else if (Builtins.__finite((double)q) == 0) {
                d3 = -1.0 / 0.0;
            } else if (p >= 10.0) {
                double d4 = lgammacor.Rf_lgammacor(p);
                double d5 = lgammacor.Rf_lgammacor(q);
                double d6 = d4 + d5;
                double d7 = lgammacor.Rf_lgammacor(p + q);
                double corr = d6 - d7;
                double d8 = Math.log(q) * -0.5 + 0.9189385332046728 + corr;
                double d9 = p - 0.5;
                double d10 = p + q;
                double d11 = Math.log(p / d10);
                double d12 = d9 * d11;
                double d13 = d8 + d12;
                double d14 = -p;
                double d15 = p + q;
                double d16 = Mathlib.log1p((double)(d14 / d15)) * q;
                d3 = d13 + d16;
            } else if (q >= 10.0) {
                double d17 = lgammacor.Rf_lgammacor(q);
                double d18 = lgammacor.Rf_lgammacor(p + q);
                double corr = d17 - d18;
                double d19 = lgamma.lgammafn(p) + corr + p;
                double d20 = Math.log(p + q) * p;
                double d21 = d19 - d20;
                double d22 = q - 0.5;
                double d23 = -p;
                double d24 = p + q;
                double d25 = Mathlib.log1p((double)(d23 / d24));
                double d26 = d22 * d25;
                d3 = d21 + d26;
            } else if (p < 1.0E-306) {
                double d27 = lgamma.lgammafn(p);
                double d28 = lgamma.lgammafn(q);
                double d29 = lgamma.lgammafn(p + q);
                double d30 = d28 - d29;
                d3 = d27 + d30;
            } else {
                double d31 = gamma.gammafn(p);
                double d32 = gamma.gammafn(q);
                double d33 = gamma.gammafn(p + q);
                double d34 = d32 / d33;
                d3 = Math.log(d31 * d34);
            }
        }
        return d3;
    }
}

