/*
 * Decompiled with CFR 0.152.
 */
package org.renjin.nmath;

import org.renjin.gcc.runtime.Builtins;
import org.renjin.gcc.runtime.BytePtr;
import org.renjin.gcc.runtime.IntPtr;
import org.renjin.gcc.runtime.Mathlib;
import org.renjin.gcc.runtime.Stdlib;
import org.renjin.nmath.cospi;
import org.renjin.nmath.gamma;
import org.renjin.nmath.lgammacor;

public class lgamma {
    private lgamma() {
    }

    public static double lgammafn(double d) {
        return lgamma.lgammafn_sign(d, new IntPtr(null, 0));
    }

    public static double lgammafn_sign(double d, IntPtr intPtr) {
        double d2;
        int[] sgn$array = intPtr.array;
        int sgn$offset = intPtr.offset;
        if (sgn$array != null) {
            sgn$array[sgn$offset] = 1;
        }
        if (Builtins.__isnan((double)d) != 0) {
            d2 = d;
        } else {
            if (sgn$array != null && d < 0.0 && Mathlib.fmod((double)Mathlib.floor((double)(-d)), (double)2.0) == 0.0) {
                sgn$array[sgn$offset] = -1;
            }
            if (d <= 0.0 && Mathlib.trunc((double)d) == d) {
                byte[] msg = "\u0000".getBytes();
                int msg$offset = 0;
                msg = "value out of range in '%s'\n\u0000".getBytes();
                msg$offset = 0;
                Stdlib.printf((BytePtr)new BytePtr(msg, msg$offset), (Object[])new Object[]{new BytePtr("lgamma\u0000".getBytes(), 0)});
                d2 = 1.0 / 0.0;
            } else {
                double y = Math.abs(d);
                if (y < 1.0E-306) {
                    d2 = -Math.log(y);
                } else if (y <= 10.0) {
                    d2 = Math.log(Math.abs(gamma.gammafn(d)));
                } else if (y > 2.5327372760800758E305) {
                    byte[] msg = "\u0000".getBytes();
                    int msg$offset = 0;
                    msg = "value out of range in '%s'\n\u0000".getBytes();
                    msg$offset = 0;
                    Stdlib.printf((BytePtr)new BytePtr(msg, msg$offset), (Object[])new Object[]{new BytePtr("lgamma\u0000".getBytes(), 0)});
                    d2 = 1.0 / 0.0;
                } else if (d > 0.0) {
                    if (d > 1.0E17) {
                        d2 = (Math.log(d) - 1.0) * d;
                    } else if (d > 4934720.0) {
                        double d3 = d - 0.5;
                        double d4 = Math.log(d);
                        d2 = d3 * d4 + 0.9189385332046728 - d;
                    } else {
                        double d5 = d - 0.5;
                        double d6 = Math.log(d);
                        double d7 = d5 * d6 + 0.9189385332046728 - d;
                        double d8 = lgammacor.Rf_lgammacor(d);
                        d2 = d7 + d8;
                    }
                } else {
                    double sinpiy = Math.abs(cospi.sinpi(y));
                    if (sinpiy == 0.0) {
                        Stdlib.printf((BytePtr)new BytePtr(" ** should NEVER happen! *** [lgamma.c: Neg.int, y=%g]\n\u0000".getBytes(), 0), (Object[])new Object[]{y});
                        d2 = 0.0 / 0.0;
                    } else {
                        double d9 = d - 0.5;
                        double d10 = Math.log(y);
                        double d11 = d9 * d10 + 0.22579135264472744 - d;
                        double d12 = Math.log(sinpiy);
                        double d13 = d11 - d12;
                        double d14 = lgammacor.Rf_lgammacor(y);
                        double ans = d13 - d14;
                        double d15 = Mathlib.trunc((double)(d - 0.5));
                        if (Math.abs((d - d15) * ans / d) < 1.4901161193847656E-8) {
                            byte[] msg = "\u0000".getBytes();
                            int msg$offset = 0;
                            msg = "full precision may not have been achieved in '%s'\n\u0000".getBytes();
                            msg$offset = 0;
                            Stdlib.printf((BytePtr)new BytePtr(msg, msg$offset), (Object[])new Object[]{new BytePtr("lgamma\u0000".getBytes(), 0)});
                        }
                        d2 = ans;
                    }
                }
            }
        }
        return d2;
    }
}

