/*
 * Decompiled with CFR 0.152.
 */
package org.renjin.nmath;

import org.renjin.gcc.runtime.Builtins;
import org.renjin.gcc.runtime.Mathlib;
import org.renjin.nmath.dgamma;
import org.renjin.nmath.lgamma;
import org.renjin.nmath.pgamma;
import org.renjin.nmath.qnorm;

public class qgamma {
    public static double $qgamma$i5040 = 1.984126984126984E-4;
    public static double $qgamma$i2520 = 3.968253968253968E-4;
    public static double $qgamma$i420 = 0.002380952380952381;

    private qgamma() {
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static double qgamma(double d, double d2, double d3, int n, int n2) {
        double t;
        double p1;
        int i;
        double iftmp$4;
        int max_it_Newton = 0;
        double s6 = 0.0;
        double ch0 = 0.0;
        double g = 0.0;
        double c = 0.0;
        double p_ = 0.0;
        max_it_Newton = 1;
        if (Builtins.__isnan((double)d) != 0) return d + d2 + d3;
        if (Builtins.__isnan((double)d2) != 0) return d + d2 + d3;
        if (Builtins.__isnan((double)d3) != 0) return d + d2 + d3;
        if (n2 != 0) {
            if (d > 0.0) return 0.0 / 0.0;
            if (d == 0.0) {
                if (n == 0) {
                    return 0.0;
                }
                double iftmp$0 = 1.0 / 0.0;
                return iftmp$0;
            }
            double d4 = -1.0 / 0.0;
            if (d == d4) {
                if (n != 0) {
                    return 0.0;
                }
                double iftmp$1 = 1.0 / 0.0;
                return iftmp$1;
            }
        } else {
            if (d < 0.0) return 0.0 / 0.0;
            if (d > 1.0) return 0.0 / 0.0;
            if (d == 0.0) {
                if (n != 0) {
                    return 0.0;
                }
                double iftmp$2 = 1.0 / 0.0;
                return iftmp$2;
            }
            if (d == 1.0) {
                if (n == 0) {
                    return 0.0;
                }
                double iftmp$3 = 1.0 / 0.0;
                return iftmp$3;
            }
        }
        if (d2 < 0.0) return 0.0 / 0.0;
        if (d3 <= 0.0) return 0.0 / 0.0;
        if (d2 == 0.0) return 0.0;
        if (d2 < 1.0E-10) {
            max_it_Newton = 7;
        }
        if (n2 != 0) {
            double iftmp$5 = n != 0 ? Math.exp(d) : -Mathlib.expm1((double)d);
            iftmp$4 = iftmp$5;
        } else {
            double iftmp$6 = n == 0 ? 0.5 - d + 0.5 : d;
            iftmp$4 = iftmp$6;
        }
        p_ = iftmp$4;
        g = lgamma.lgammafn(d2);
        double d5 = d2 * 2.0;
        double ch = qgamma.qchisq_appr(d, d5, g, n, n2, 0.01);
        if (Builtins.__finite((double)ch) == 0) {
            max_it_Newton = 0;
        } else if (ch < 5.0E-7) {
            max_it_Newton = 20;
        } else if (p_ > 0.99999999999999 || p_ < 1.0E-100) {
            max_it_Newton = 20;
        } else {
            c = d2 - 1.0;
            double d6 = (c * 127.0 + 346.0) * c + 120.0;
            double i5040$7 = $qgamma$i5040;
            s6 = d6 * i5040$7;
            ch0 = ch;
            i = 1;
            while (i <= 1000) {
                double q = ch;
                p1 = ch * 0.5;
                double d7 = pgamma.Rf_pgamma_raw(p1, d2, 1, 0);
                double p2 = p_ - d7;
                if (Builtins.__finite((double)p2) == 0 || ch <= 0.0) {
                    ch = ch0;
                    max_it_Newton = 27;
                    break;
                }
                double d8 = d2 * 0.6931471805599453 + g + p1;
                double d9 = Math.log(ch) * c;
                t = Math.exp(d8 - d9) * p2;
                double b = t / ch;
                double d10 = t * 0.5;
                double d11 = b * c;
                double a = d10 - d11;
                double d12 = ((((a * 60.0 + 70.0) * a + 84.0) * a + 105.0) * a + 140.0) * a + 210.0;
                double i420$8 = $qgamma$i420;
                double s1 = d12 * i420$8;
                double d13 = (((a * 1278.0 + 1141.0) * a + 966.0) * a + 735.0) * a + 420.0;
                double i2520$9 = $qgamma$i2520;
                double s2 = d13 * i2520$9;
                double d14 = ((a * 932.0 + 707.0) * a + 462.0) * a + 210.0;
                double i2520$10 = $qgamma$i2520;
                double s3 = d14 * i2520$10;
                double d15 = (a * 1182.0 + 672.0) * a + 252.0;
                double d16 = ((a * 1740.0 + 889.0) * a + 294.0) * c;
                double d17 = d15 + d16;
                double i5040$11 = $qgamma$i5040;
                double s4 = d17 * i5040$11;
                double d18 = a * 2264.0 + 84.0;
                double d19 = (a * 606.0 + 1175.0) * c;
                double d20 = d18 + d19;
                double i2520$12 = $qgamma$i2520;
                double s5 = d20 * i2520$12;
                double d21 = t * 0.5 * s1 + 1.0;
                double d22 = b * c;
                double d23 = b * s6;
                double d24 = (s5 - d23) * b;
                double d25 = (s4 - d24) * b;
                double d26 = (s3 - d25) * b;
                double d27 = (s2 - d26) * b;
                double d28 = s1 - d27;
                double d29 = d22 * d28;
                ch = (d21 - d29) * t + ch;
                double d30 = Math.abs(q - ch);
                double d31 = ch * 5.0E-7;
                if (d30 < d31) break;
                double d32 = Math.abs(q - ch);
                double d33 = ch * 0.1;
                if (d32 > d33) {
                    ch = ch < q ? q * 0.9 : q * 1.1;
                }
                ++i;
            }
        }
        double x = d3 * 0.5 * ch;
        if (max_it_Newton == 0) return x;
        if (n2 == 0) {
            d = Math.log(d);
            n2 = 1;
        }
        if (x == 0.0) {
            double _1_p = 1.0000001;
            double _1_m = 0.9999999;
            x = Double.MIN_NORMAL;
            p_ = pgamma.pgamma(x, d2, d3, n, n2);
            if (n != 0) {
                if (d * _1_p < p_) return 0.0;
            }
            if (n == 0) {
                if (d * _1_m > p_) return 0.0;
            }
        } else {
            p_ = pgamma.pgamma(x, d2, d3, n, n2);
        }
        double d34 = -1.0 / 0.0;
        if (p_ == d34) return 0.0;
        i = 1;
        while (i <= max_it_Newton) {
            double d35;
            p1 = p_ - d;
            double d36 = Math.abs(p1);
            if (d36 < (d35 = Math.abs(d * 1.0E-15))) return x;
            g = dgamma.dgamma(x, d2, d3, n2);
            double iftmp$13 = n2 != 0 ? -1.0 / 0.0 : 0.0;
            if (g == iftmp$13) return x;
            double iftmp$14 = n2 != 0 ? Math.exp(p_ - g) * p1 : p1 / g;
            t = iftmp$14;
            double iftmp$15 = n != 0 ? x - t : x + t;
            t = iftmp$15;
            p_ = pgamma.pgamma(t, d2, d3, n, n2);
            double d37 = Math.abs(p_ - d);
            double d38 = Math.abs(p1);
            if (d37 > d38) return x;
            if (i > 1) {
                double d39;
                double d40 = Math.abs(p_ - d);
                if (d40 == (d39 = Math.abs(p1))) return x;
            }
            x = t;
            ++i;
        }
        return x;
    }

    public static double qchisq_appr(double d, double d2, double d3, int n, int n2, double d4) {
        double d5;
        double a = 0.0;
        if (Builtins.__isnan((double)d) != 0 || Builtins.__isnan((double)d2) != 0) {
            d5 = d + d2;
        } else if (n2 != 0 && d > 0.0 || n2 == 0 && (d < 0.0 || d > 1.0)) {
            d5 = 0.0 / 0.0;
        } else if (d2 <= 0.0) {
            d5 = 0.0 / 0.0;
        } else {
            double ch;
            double iftmp$16;
            double alpha = d2 * 0.5;
            double c = alpha - 1.0;
            if (n != 0) {
                double iftmp$17 = n2 == 0 ? Math.log(d) : d;
                iftmp$16 = iftmp$17;
            } else {
                double iftmp$18;
                if (n2 != 0) {
                    double iftmp$19 = d > -0.6931471805599453 ? Math.log(-Mathlib.expm1((double)d)) : Mathlib.log1p((double)(-Math.exp(d)));
                    iftmp$18 = iftmp$19;
                } else {
                    iftmp$18 = Mathlib.log1p((double)(-d));
                }
                iftmp$16 = iftmp$18;
            }
            double p1 = iftmp$16;
            if (p1 * -1.24 > d2) {
                double iftmp$20 = alpha < 0.5 ? pgamma.lgamma1p(alpha) : Math.log(alpha) + d3;
                ch = Math.exp((iftmp$20 + p1) / alpha + 0.6931471805599453);
            } else if (d2 > 0.32) {
                double x = qnorm.qnorm5(d, 0.0, 1.0, n, n2);
                double d6 = d2 * 9.0;
                p1 = 2.0 / d6;
                ch = Mathlib.pow((double)(Mathlib.sqrt((double)p1) * x + 1.0 - p1), (double)3.0) * d2;
                if (d2 * 2.2 + 6.0 < ch) {
                    double iftmp$21;
                    if (n != 0) {
                        double iftmp$22;
                        if (n2 != 0) {
                            double iftmp$23 = d > -0.6931471805599453 ? Math.log(-Mathlib.expm1((double)d)) : Mathlib.log1p((double)(-Math.exp(d)));
                            iftmp$22 = iftmp$23;
                        } else {
                            iftmp$22 = Mathlib.log1p((double)(-d));
                        }
                        iftmp$21 = iftmp$22;
                    } else {
                        double iftmp$24 = n2 == 0 ? Math.log(d) : d;
                        iftmp$21 = iftmp$24;
                    }
                    double d7 = Math.log(ch * 0.5) * c;
                    ch = (iftmp$21 - d7 + d3) * -2.0;
                }
            } else {
                double d8;
                double t;
                double p2;
                double d9;
                double d10;
                double q;
                double d11;
                double iftmp$25;
                ch = 0.4;
                if (n != 0) {
                    double iftmp$26;
                    if (n2 != 0) {
                        double iftmp$27 = d > -0.6931471805599453 ? Math.log(-Mathlib.expm1((double)d)) : Mathlib.log1p((double)(-Math.exp(d)));
                        iftmp$26 = iftmp$27;
                    } else {
                        iftmp$26 = Mathlib.log1p((double)(-d));
                    }
                    iftmp$25 = iftmp$26;
                } else {
                    double iftmp$28 = n2 == 0 ? Math.log(d) : d;
                    iftmp$25 = iftmp$28;
                }
                double d12 = iftmp$25 + d3;
                double d13 = c * 0.6931471805599453;
                a = d12 + d13;
                do {
                    q = ch;
                    double d14 = (ch + 4.67) * ch + 1.0;
                    p1 = 1.0 / d14;
                    p2 = ((ch + 6.66) * ch + 6.73) * ch;
                    double d15 = (ch * 2.0 + 4.67) * p1 - 0.5;
                    double d16 = ((ch * 3.0 + 13.32) * ch + 6.73) / p2;
                    t = d15 - d16;
                } while ((d11 = Math.abs(q - (ch -= (d10 = (1.0 - (d9 = Math.exp(ch * 0.5 + a) * p2 * p1)) / t)))) > (d8 = Math.abs(ch) * d4));
            }
            d5 = ch;
        }
        return d5;
    }
}

