/*
 * Decompiled with CFR 0.152.
 */
package org.renjin.nmath;

import java.lang.invoke.MethodHandle;
import org.renjin.gcc.runtime.Builtins;
import org.renjin.gcc.runtime.Mathlib;
import org.renjin.nmath.imin2;

public class signrank {
    public static int allocated_n;
    public static double[] w;
    public static int w$offset;

    private signrank() {
    }

    public static double rsignrank(MethodHandle methodHandle, double d) {
        double d2;
        int k = 0;
        if (Builtins.__isnan((double)d) != 0) {
            d2 = d;
        } else {
            d = Mathlib.round((double)d);
            if (d < 0.0) {
                d2 = 0.0 / 0.0;
            } else if (d == 0.0) {
                d2 = 0.0;
            } else {
                double r = 0.0;
                k = (int)d;
                int i = 0;
                while (i < k) {
                    double d3 = ++i;
                    double d4 = Mathlib.floor((double)(methodHandle.invoke() + 0.5));
                    r = d3 * d4 + r;
                }
                d2 = r;
            }
        }
        return d2;
    }

    public static double qsignrank(double d, double d2, int n, int n2) {
        double d3;
        int nn = 0;
        double f = 0.0;
        if (Builtins.__isnan((double)d) != 0 || Builtins.__isnan((double)d2) != 0) {
            d3 = d + d2;
        } else if (Builtins.__finite((double)d) == 0 || Builtins.__finite((double)d2) == 0) {
            d3 = 0.0 / 0.0;
        } else if (n2 != 0 && d > 0.0 || n2 == 0 && (d < 0.0 || d > 1.0)) {
            d3 = 0.0 / 0.0;
        } else if ((d2 = Mathlib.round((double)d2)) <= 0.0) {
            d3 = 0.0 / 0.0;
        } else {
            double iftmp$0;
            if (n != 0) {
                double iftmp$1 = n2 != 0 ? -1.0 / 0.0 : 0.0;
                iftmp$0 = iftmp$1;
            } else {
                double iftmp$2 = n2 != 0 ? 0.0 : 1.0;
                iftmp$0 = iftmp$2;
            }
            if (iftmp$0 == d) {
                d3 = 0.0;
            } else {
                double iftmp$3;
                if (n != 0) {
                    double iftmp$4 = n2 != 0 ? 0.0 : 1.0;
                    iftmp$3 = iftmp$4;
                } else {
                    double iftmp$5 = n2 != 0 ? -1.0 / 0.0 : 0.0;
                    iftmp$3 = iftmp$5;
                }
                if (iftmp$3 == d) {
                    d3 = (d2 + 1.0) * d2 / 2.0;
                } else {
                    if (n2 != 0 || n == 0) {
                        double iftmp$6;
                        if (n2 != 0) {
                            double iftmp$7 = n != 0 ? Math.exp(d) : -Mathlib.expm1((double)d);
                            iftmp$6 = iftmp$7;
                        } else {
                            double iftmp$8 = n == 0 ? 0.5 - d + 0.5 : d;
                            iftmp$6 = iftmp$8;
                        }
                        d = iftmp$6;
                    }
                    nn = (int)d2;
                    signrank.w_init_maybe(nn);
                    f = Math.exp(-d2 * 0.6931471805599453);
                    double p = 0.0;
                    int q = 0;
                    if (d <= 0.5) {
                        d -= 2.220446049250313E-15;
                        while (!((p = signrank.csignrank(q, nn) * f + p) >= d)) {
                            ++q;
                        }
                    } else {
                        d = 1.0 - d + 2.220446049250313E-15;
                        while (true) {
                            if ((p = signrank.csignrank(q, nn) * f + p) > d) {
                                double d4 = (d2 + 1.0) * d2 / 2.0;
                                double d5 = q;
                                q = (int)(d4 - d5);
                                break;
                            }
                            ++q;
                        }
                    }
                    d3 = q;
                }
            }
        }
        return d3;
    }

    public static double psignrank(double d, double d2, int n, int n2) {
        double d3;
        int nn = 0;
        double f = 0.0;
        if (Builtins.__isnan((double)d) != 0 || Builtins.__isnan((double)d2) != 0) {
            d3 = d + d2;
        } else if (Builtins.__finite((double)d2) == 0) {
            d3 = 0.0 / 0.0;
        } else {
            d2 = Mathlib.round((double)d2);
            if (d2 <= 0.0) {
                d3 = 0.0 / 0.0;
            } else {
                d = Mathlib.round((double)(d + 1.0E-7));
                if (d < 0.0) {
                    double iftmp$9;
                    if (n != 0) {
                        double iftmp$10 = n2 != 0 ? -1.0 / 0.0 : 0.0;
                        iftmp$9 = iftmp$10;
                    } else {
                        double iftmp$11 = n2 != 0 ? 0.0 : 1.0;
                        iftmp$9 = iftmp$11;
                    }
                    d3 = iftmp$9;
                } else if ((d2 + 1.0) * d2 / 2.0 <= d) {
                    double iftmp$12;
                    if (n != 0) {
                        double iftmp$13 = n2 != 0 ? 0.0 : 1.0;
                        iftmp$12 = iftmp$13;
                    } else {
                        double iftmp$14 = n2 != 0 ? -1.0 / 0.0 : 0.0;
                        iftmp$12 = iftmp$14;
                    }
                    d3 = iftmp$12;
                } else {
                    double iftmp$15;
                    nn = (int)d2;
                    signrank.w_init_maybe(nn);
                    f = Math.exp(-d2 * 0.6931471805599453);
                    double p = 0.0;
                    if ((d2 + 1.0) * d2 / 4.0 >= d) {
                        int i = 0;
                        while ((double)i <= d) {
                            p = signrank.csignrank(i, nn) * f + p;
                            ++i;
                        }
                    } else {
                        d = (d2 + 1.0) * d2 / 2.0 - d;
                        int i = 0;
                        while ((double)i < d) {
                            p = signrank.csignrank(i, nn) * f + p;
                            ++i;
                        }
                        int n3 = n = n != 0 ? 0 : 1;
                    }
                    if (n != 0) {
                        double iftmp$16 = n2 != 0 ? Math.log(p) : p;
                        iftmp$15 = iftmp$16;
                    } else {
                        double iftmp$17 = n2 != 0 ? Mathlib.log1p((double)(-p)) : 0.5 - p + 0.5;
                        iftmp$15 = iftmp$17;
                    }
                    d3 = iftmp$15;
                }
            }
        }
        return d3;
    }

    public static double dsignrank(double d, double d2, int n) {
        double d3;
        if (Builtins.__isnan((double)d) != 0 || Builtins.__isnan((double)d2) != 0) {
            d3 = d + d2;
        } else {
            d2 = Mathlib.round((double)d2);
            if (d2 <= 0.0) {
                d3 = 0.0 / 0.0;
            } else {
                double d4 = Mathlib.round((double)d);
                if (Math.abs(d - d4) > 1.0E-7) {
                    double iftmp$18 = n != 0 ? -1.0 / 0.0 : 0.0;
                    d3 = iftmp$18;
                } else if ((d = Mathlib.round((double)d)) < 0.0 || (d2 + 1.0) * d2 / 2.0 < d) {
                    double iftmp$19 = n != 0 ? -1.0 / 0.0 : 0.0;
                    d3 = iftmp$19;
                } else {
                    double iftmp$20;
                    int nn = (int)d2;
                    signrank.w_init_maybe(nn);
                    if (n != 0) {
                        double d5 = Math.log(signrank.csignrank((int)d, nn));
                        double d6 = d2 * 0.6931471805599453;
                        iftmp$20 = d5 - d6;
                    } else {
                        double d7 = Math.log(signrank.csignrank((int)d, nn));
                        double d8 = d2 * 0.6931471805599453;
                        iftmp$20 = Math.exp(d7 - d8);
                    }
                    d3 = iftmp$20;
                }
            }
        }
        return d3;
    }

    public static double csignrank(int n, int n2) {
        double d;
        int j = 0;
        int c = 0;
        int u = (n2 + 1) * n2 / 2;
        c = u / 2;
        if (n < 0 || n > u) {
            d = 0.0;
        } else {
            if (n > c) {
                n = u - n;
            }
            if (n2 == 1) {
                d = 1.0;
            } else {
                double[] w$21 = w;
                int w$21$offset = w$offset;
                if (w$21[w$21$offset] == 1.0) {
                    double[] w$22 = w;
                    int w$22$offset = w$offset;
                    int n3 = n * 8;
                    double[] dArray = w$22;
                    int n4 = w$22$offset + n3 / 8;
                    d = dArray[n4];
                } else {
                    double d2;
                    double[] w$24 = w;
                    int w$24$offset = w$offset;
                    double[] w$25 = w;
                    int w$25$offset = w$offset;
                    double[] dArray = w$25;
                    int n5 = w$25$offset + 1;
                    dArray[n5] = 1.0;
                    w$24[w$24$offset] = d2 = dArray[n5];
                    j = 2;
                    while (n2 + 1 > j) {
                        int i = imin2.imin2((j + 1) * j / 2, c);
                        while (i >= j) {
                            double d3;
                            double[] w$26 = w;
                            int w$26$offset = w$offset;
                            int n6 = i * 8;
                            double[] dArray2 = w$26;
                            int n7 = w$26$offset + n6 / 8;
                            double[] w$28 = w;
                            int w$28$offset = w$offset;
                            int n8 = i * 8;
                            double[] dArray3 = w$28;
                            int n9 = w$28$offset + n8 / 8;
                            double d4 = dArray3[n9];
                            double[] w$30 = w;
                            int w$30$offset = w$offset;
                            int n10 = (i - j) * 8;
                            double[] dArray4 = w$30;
                            int n11 = w$30$offset + n10 / 8;
                            double d5 = dArray4[n11];
                            dArray2[n7] = d3 = d4 + d5;
                            --i;
                        }
                        ++j;
                    }
                    double[] w$31 = w;
                    int w$31$offset = w$offset;
                    int n12 = n * 8;
                    double[] dArray5 = w$31;
                    int n13 = w$31$offset + n12 / 8;
                    d = dArray5[n13];
                }
            }
        }
        return d;
    }

    public static void w_init_maybe(int n) {
        block5: {
            int c;
            block4: {
                c = (n + 1) * n / 2 / 2;
                double[] w$33 = w;
                int w$33$offset = w$offset;
                if (w$33 == null) break block4;
                int allocated_n$34 = allocated_n;
                if (n == allocated_n$34) break block5;
                signrank.w_free();
            }
            double[] w$35 = w;
            int w$35$offset = w$offset;
            if (w$35 == null) {
                double[] w$37 = new double[Math.max((c + 1) * 8 / 8, 1)];
                int w$37$offset = 0;
                w = w$37;
                w$offset = w$37$offset;
                allocated_n = n;
            }
        }
    }

    public static void signrank_free() {
        signrank.w_free();
    }

    public static void w_free() {
        double[] w$38 = w;
        int w$38$offset = w$offset;
        if (w$38 != null) {
            double[] w$39 = w;
            int w$39$offset = w$offset;
            w = null;
            w$offset = 0;
            allocated_n = 0;
        }
    }
}

