/*
 * Decompiled with CFR 0.152.
 */
package org.structr.cloud;

import java.io.BufferedInputStream;
import java.io.BufferedOutputStream;
import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.Socket;
import java.security.InvalidKeyException;
import java.util.Collection;
import java.util.LinkedHashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.zip.GZIPInputStream;
import java.util.zip.GZIPOutputStream;
import javax.crypto.Cipher;
import javax.crypto.CipherInputStream;
import javax.crypto.CipherOutputStream;
import javax.crypto.spec.SecretKeySpec;
import org.apache.commons.codec.digest.DigestUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.structr.api.config.Settings;
import org.structr.cloud.CloudListener;
import org.structr.cloud.CloudService;
import org.structr.cloud.Receiver;
import org.structr.cloud.Sender;
import org.structr.cloud.message.DataContainer;
import org.structr.cloud.message.FileNodeChunk;
import org.structr.cloud.message.FileNodeDataContainer;
import org.structr.cloud.message.FileNodeEndChunk;
import org.structr.cloud.message.Message;
import org.structr.cloud.message.NodeDataContainer;
import org.structr.cloud.message.RelationshipDataContainer;
import org.structr.cloud.message.SyncableInfo;
import org.structr.cloud.sync.Ping;
import org.structr.common.AccessMode;
import org.structr.common.SecurityContext;
import org.structr.common.error.FrameworkException;
import org.structr.core.GraphObject;
import org.structr.core.Services;
import org.structr.core.TransactionSource;
import org.structr.core.app.App;
import org.structr.core.app.StructrApp;
import org.structr.core.entity.Principal;
import org.structr.core.entity.SchemaNode;
import org.structr.core.entity.SchemaRelationshipNode;
import org.structr.core.graph.NodeInterface;
import org.structr.core.graph.RelationshipInterface;
import org.structr.core.graph.Tx;
import org.structr.core.property.PropertyKey;
import org.structr.core.property.PropertyMap;
import org.structr.dynamic.File;
import org.structr.schema.ConfigurationProvider;
import org.structr.web.entity.Folder;
import org.structr.web.entity.User;
import org.structr.web.entity.dom.Page;
import org.structr.web.entity.dom.ShadowDocument;

public class CloudConnection<T>
extends Thread
implements TransactionSource {
    private static final Logger logger = LoggerFactory.getLogger((String)CloudConnection.class.getName());
    private final Map<String, FileNodeDataContainer> fileMap = new LinkedHashMap<String, FileNodeDataContainer>();
    private final Map<String, String> idMap = new LinkedHashMap<String, String>();
    private final Map<String, Object> data = new LinkedHashMap<String, Object>();
    private final ConfigurationProvider config = Services.getInstance().getConfigurationProvider();
    private App app = null;
    private CloudListener listener = null;
    private long transmissionAbortTime = 0L;
    private boolean authenticated = false;
    private String errorMessage = null;
    private String remoteAddress = null;
    private int errorCode = 0;
    private String password = null;
    private Cipher encrypter = null;
    private Cipher decrypter = null;
    private Receiver receiver = null;
    private Sender sender = null;
    private Socket socket = null;
    private T payload = null;
    private Tx tx = null;
    private int count = 0;
    private int total = 0;

    public CloudConnection(SecurityContext securityContext, Socket socket, CloudListener cloudListener) {
        super("CloudConnection(" + socket.getRemoteSocketAddress() + ")");
        this.app = StructrApp.getInstance((SecurityContext)securityContext);
        this.remoteAddress = socket.getInetAddress().getHostAddress();
        this.listener = cloudListener;
        this.socket = socket;
        this.setDaemon(true);
        logger.info("New connection from {}", (Object)socket.getRemoteSocketAddress());
    }

    @Override
    public void start() {
        if (this.socket.isConnected() && !this.socket.isClosed()) {
            try {
                this.decrypter = Cipher.getInstance("RC4");
                this.encrypter = Cipher.getInstance("RC4");
                this.setEncryptionKey("StructrInitialEncryptionKey", 128);
                this.sender = new Sender(this, new DataOutputStream(new BufferedOutputStream(new GZIPOutputStream((OutputStream)new CipherOutputStream(this.socket.getOutputStream(), this.encrypter), 32768, true))));
                this.receiver = new Receiver(this, new DataInputStream(new BufferedInputStream(new GZIPInputStream((InputStream)new CipherInputStream(this.socket.getInputStream(), this.decrypter), 32768))));
                this.receiver.start();
                this.sender.start();
                super.start();
            }
            catch (Throwable throwable) {
                logger.warn("", throwable);
            }
        }
    }

    @Override
    public void run() {
        while (this.isConnected()) {
            try {
                Message message = this.receiver.receive();
                if (message != null) {
                    this.logDebug("RECEIVED ", message);
                    this.refreshTransmissionTimeout();
                    if (message.wasSentFromHere()) {
                        message.onResponse(this);
                    } else {
                        message.onRequest(this);
                    }
                }
                if (this.count < 100) continue;
                this.sender.send(new Ping("Committing batch.."));
                if (this.listener != null) {
                    this.listener.transmissionProgress("Committing batch..");
                }
                this.commitTransaction();
                this.endTransaction();
                this.beginTransaction();
                this.count = 0;
            }
            catch (Throwable throwable) {
                logger.warn("", throwable);
            }
        }
        this.shutdown();
        logger.info("Transmission finished");
    }

    public void send(Message message) throws IOException, FrameworkException {
        this.logDebug("SEND", message);
        this.sender.send(message);
    }

    private void shutdown() {
        this.close();
        this.endTransaction();
    }

    public void close() {
        try {
            this.socket.close();
        }
        catch (Throwable throwable) {
            logger.warn("", throwable);
        }
    }

    public void waitForAuthentication() throws FrameworkException {
        long l = System.currentTimeMillis() + 10000L;
        while (!this.authenticated) {
            if (this.errorMessage != null) {
                throw new FrameworkException(this.errorCode, this.errorMessage);
            }
            if (System.currentTimeMillis() > l) {
                throw new FrameworkException(401, "Authentication failed.");
            }
            try {
                Thread.sleep(10L);
            }
            catch (Throwable throwable) {
                logger.warn("", throwable);
            }
        }
    }

    public void refreshTransmissionTimeout() {
        this.transmissionAbortTime = System.currentTimeMillis() + 10000L;
    }

    public void waitForTransmission() throws FrameworkException {
        this.transmissionAbortTime = System.currentTimeMillis() + 10000L;
        while (this.isConnected()) {
            if (this.errorMessage != null) {
                throw new FrameworkException(this.errorCode, this.errorMessage);
            }
            if (System.currentTimeMillis() > this.transmissionAbortTime) {
                throw new FrameworkException(504, "Timeout while waiting for response.");
            }
            try {
                Thread.sleep(10L);
            }
            catch (Throwable throwable) {
                logger.warn("", throwable);
            }
        }
    }

    public void waitForClose(int n) throws FrameworkException {
        long l = System.currentTimeMillis() + 10000L;
        while (this.isConnected() && System.currentTimeMillis() < l) {
            try {
                Thread.sleep(10L);
            }
            catch (Throwable throwable) {
                logger.warn("", throwable);
            }
        }
    }

    public void setEncryptionKey(String string, int n) throws InvalidKeyException {
        try {
            SecretKeySpec secretKeySpec = new SecretKeySpec(CloudService.trimToSize(DigestUtils.sha256((String)string), n), "RC4");
            this.decrypter.init(2, secretKeySpec);
            this.encrypter.init(1, secretKeySpec);
        }
        catch (Throwable throwable) {
            logger.warn("", throwable);
        }
    }

    public boolean isConnected() {
        return this.socket.isConnected() && !this.socket.isClosed();
    }

    public void setAuthenticated() {
        this.authenticated = true;
    }

    public void setPassword(String string) {
        this.password = string;
    }

    public String getPassword() {
        return this.password;
    }

    public App getApplicationContext() {
        return this.app;
    }

    public NodeInterface storeNode(DataContainer dataContainer) throws FrameworkException {
        SecurityContext securityContext = SecurityContext.getSuperUserInstance();
        NodeDataContainer nodeDataContainer = (NodeDataContainer)dataContainer;
        String string = nodeDataContainer.getType();
        Class clazz = this.config.getNodeEntityClass(string);
        if (clazz == null) {
            logger.error("Unknown entity type {}", (Object)string);
            return null;
        }
        if (Boolean.TRUE.equals(nodeDataContainer.getProperties().get(SchemaNode.isBuiltinType.dbName()))) {
            return null;
        }
        String string2 = nodeDataContainer.getSourceNodeId();
        GraphObject graphObject = this.app.get(clazz, string2);
        if (graphObject != null) {
            graphObject.setProperties(securityContext, PropertyMap.databaseTypeToJavaType((SecurityContext)securityContext, (Class)clazz, nodeDataContainer.getProperties()));
        } else {
            PropertyMap propertyMap = PropertyMap.databaseTypeToJavaType((SecurityContext)securityContext, (Class)clazz, nodeDataContainer.getProperties());
            LinkedList linkedList = new LinkedList();
            if (ShadowDocument.class.getSimpleName().equals(string)) {
                for (ShadowDocument shadowDocument : this.app.nodeQuery(ShadowDocument.class).includeDeletedAndHidden().getAsList()) {
                    linkedList.addAll((Collection)shadowDocument.getProperty((PropertyKey)Page.elements));
                    this.app.delete((NodeInterface)shadowDocument);
                }
                propertyMap.put((PropertyKey)Page.elements, linkedList);
            }
            graphObject = this.app.create(clazz, propertyMap);
        }
        this.idMap.put(nodeDataContainer.getSourceNodeId(), graphObject.getUuid());
        ++this.count;
        ++this.total;
        return (NodeInterface)graphObject;
    }

    public RelationshipInterface storeRelationship(DataContainer dataContainer) throws FrameworkException {
        String string;
        RelationshipDataContainer relationshipDataContainer = (RelationshipDataContainer)dataContainer;
        String string2 = relationshipDataContainer.getSourceStartNodeId();
        String string3 = relationshipDataContainer.getSourceEndNodeId();
        String string4 = relationshipDataContainer.getRelationshipId();
        String string5 = this.idMap.get(string2);
        if (string5 == null) {
            string5 = string2;
        }
        if ((string = this.idMap.get(string3)) == null) {
            string = string3;
        }
        if (string5 != null && string != null) {
            SecurityContext securityContext = SecurityContext.getSuperUserInstance();
            NodeInterface nodeInterface = this.app.getNodeById(string5);
            NodeInterface nodeInterface2 = this.app.getNodeById(string);
            String string6 = relationshipDataContainer.getType();
            Class clazz = this.config.getRelationshipEntityClass(string6);
            if (nodeInterface != null && nodeInterface2 != null) {
                RelationshipInterface relationshipInterface = (RelationshipInterface)this.app.relationshipQuery().and((PropertyKey)GraphObject.id, (Object)string4).includeDeletedAndHidden().getFirst();
                ++this.count;
                ++this.total;
                if (relationshipInterface != null) {
                    relationshipInterface.setProperties(securityContext, PropertyMap.databaseTypeToJavaType((SecurityContext)securityContext, (Class)clazz, relationshipDataContainer.getProperties()));
                    return relationshipInterface;
                }
                PropertyMap propertyMap = PropertyMap.databaseTypeToJavaType((SecurityContext)securityContext, (Class)clazz, relationshipDataContainer.getProperties());
                return this.app.create(nodeInterface, nodeInterface2, clazz, propertyMap);
            }
            logger.warn("Could not store relationship {} -> {}", new Object[]{nodeInterface, nodeInterface2});
        }
        logger.warn("Could not store relationship {} -> {}", new Object[]{string2, string3});
        return null;
    }

    public void delete(String string) throws FrameworkException {
        GraphObject graphObject = this.app.get(string);
        if (graphObject != null) {
            if (graphObject instanceof NodeInterface) {
                this.app.delete((NodeInterface)graphObject);
            } else {
                this.app.delete((RelationshipInterface)graphObject);
            }
            ++this.count;
            ++this.total;
        }
    }

    public void deleteRelationship(String string) throws FrameworkException {
        this.app.delete(this.app.getRelationshipById(string));
    }

    public void beginTransaction() {
        this.tx = this.app.tx();
        this.tx.setSource((TransactionSource)this);
        this.logDebug("######################## OPENING TRANSACTION " + this.tx + " in thread " + Thread.currentThread(), null);
    }

    public void commitTransaction() {
        if (this.tx != null) {
            try {
                this.logDebug("######################## COMMITING TRANSACTION " + this.tx + " in thread " + Thread.currentThread(), null);
                this.tx.success();
            }
            catch (Throwable throwable) {
                logger.warn("", throwable);
            }
        } else {
            System.out.println("NO TRANSACTION!");
        }
    }

    public void endTransaction() {
        if (this.tx != null) {
            this.logDebug("######################## CLOSING TRANSACTION " + this.tx + " in thread " + Thread.currentThread(), null);
            try {
                this.tx.close();
            }
            catch (Throwable throwable) {
                logger.warn("", throwable);
            }
            this.tx = null;
        }
        this.data.clear();
    }

    public Principal getUser(String string) {
        try {
            return (Principal)this.app.nodeQuery(User.class).andName(string).getFirst();
        }
        catch (Throwable throwable) {
            logger.warn("", throwable);
            return null;
        }
    }

    public void impersonateUser(Principal principal) throws FrameworkException {
        this.app = StructrApp.getInstance((SecurityContext)SecurityContext.getInstance((Principal)principal, (AccessMode)AccessMode.Backend));
    }

    public void beginFile(FileNodeDataContainer fileNodeDataContainer) {
        this.fileMap.put(fileNodeDataContainer.getSourceNodeId(), fileNodeDataContainer);
        ++this.count;
        ++this.total;
    }

    public void finishFile(FileNodeEndChunk fileNodeEndChunk) throws FrameworkException {
        FileNodeDataContainer fileNodeDataContainer = this.fileMap.get(fileNodeEndChunk.getContainerId());
        if (fileNodeDataContainer == null) {
            logger.warn("Received file end chunk for ID {} without file, this should not happen!", (Object)fileNodeEndChunk.getContainerId());
        } else {
            fileNodeDataContainer.flushAndCloseTemporaryFile();
            NodeInterface nodeInterface = this.storeNode(fileNodeDataContainer);
            String string = (String)Settings.FilesPath.getValue();
            String string2 = (String)nodeInterface.getProperty((PropertyKey)File.relativeFilePath);
            String string3 = null;
            string3 = string.endsWith("/") ? string + string2 : string + "/" + string2;
            try {
                fileNodeDataContainer.persistTemporaryFile(string3);
            }
            catch (Throwable throwable) {
                logger.warn("", throwable);
            }
            ++this.count;
            ++this.total;
        }
    }

    public void fileChunk(FileNodeChunk fileNodeChunk) {
        FileNodeDataContainer fileNodeDataContainer = this.fileMap.get(fileNodeChunk.getContainerId());
        if (fileNodeDataContainer == null) {
            logger.warn("Received file chunk for ID {} without file, this should not happen!", (Object)fileNodeChunk.getContainerId());
        } else {
            fileNodeDataContainer.addChunk(fileNodeChunk);
            ++this.count;
            ++this.total;
        }
    }

    public List<SyncableInfo> listSyncables(Set<Class<? extends GraphObject>> set) throws FrameworkException {
        LinkedList<SyncableInfo> linkedList = new LinkedList<SyncableInfo>();
        if (set == null || set.isEmpty()) {
            for (Page page : this.app.nodeQuery(Page.class).includeDeletedAndHidden().getAsList()) {
                linkedList.add(new SyncableInfo((GraphObject)page));
            }
            for (File file : this.app.nodeQuery(File.class).getAsList()) {
                linkedList.add(new SyncableInfo((GraphObject)file));
            }
            for (Folder folder : this.app.nodeQuery(Folder.class).getAsList()) {
                linkedList.add(new SyncableInfo((GraphObject)folder));
            }
            for (SchemaNode schemaNode : this.app.nodeQuery(SchemaNode.class).getAsList()) {
                linkedList.add(new SyncableInfo((GraphObject)schemaNode));
            }
            for (SchemaRelationshipNode schemaRelationshipNode : this.app.nodeQuery(SchemaRelationshipNode.class).getAsList()) {
                linkedList.add(new SyncableInfo((GraphObject)schemaRelationshipNode));
            }
        }
        for (Class<Object> clazz : set) {
            if (NodeInterface.class.isAssignableFrom(clazz)) {
                for (NodeInterface nodeInterface : this.app.nodeQuery(clazz).includeDeletedAndHidden().getAsList()) {
                    linkedList.add(new SyncableInfo((GraphObject)nodeInterface));
                }
                continue;
            }
            if (!RelationshipInterface.class.isAssignableFrom(clazz)) continue;
            for (NodeInterface nodeInterface : this.app.relationshipQuery(clazz).getAsList()) {
                linkedList.add(new SyncableInfo((GraphObject)nodeInterface));
            }
        }
        return linkedList;
    }

    public void storeValue(String string, Object object) {
        this.data.put(string, object);
    }

    public Object getValue(String string) {
        return this.data.get(string);
    }

    public void removeValue(String string) {
        this.data.remove(string);
    }

    public void setPayload(T t) {
        this.payload = t;
    }

    public T getPayload() {
        return this.payload;
    }

    public void setError(int n, String string) {
        this.errorMessage = string;
        this.errorCode = n;
        this.close();
    }

    public void logDebug(String string, Message message) {
        if (CloudService.DEBUG) {
            System.out.println(Thread.currentThread().getId() + ": " + System.currentTimeMillis() + "        " + string + " " + (message != null ? message : "") + ", count: " + this.count);
        }
    }

    public boolean isLocal() {
        return false;
    }

    public boolean isRemote() {
        return true;
    }

    public String getOriginAddress() {
        return this.remoteAddress;
    }

    public CloudListener getListener() {
        return this.listener;
    }

    public int getCount() {
        return this.count;
    }

    public int getTotal() {
        return this.total;
    }
}

