/*
 * Decompiled with CFR 0.152.
 */
package org.structr.cloud;

import java.util.LinkedHashSet;
import java.util.Set;
import org.structr.common.error.FrameworkException;
import org.structr.core.GraphObject;
import org.structr.core.graph.NodeInterface;
import org.structr.core.graph.RelationshipInterface;
import org.structr.dynamic.File;

public class ExportSet {
    private final Set<NodeInterface> nodes = new LinkedHashSet<NodeInterface>();
    private final Set<RelationshipInterface> relationships = new LinkedHashSet<RelationshipInterface>();
    private int size = 0;

    private ExportSet() {
    }

    public boolean add(GraphObject graphObject) {
        if (graphObject.isNode()) {
            if (this.nodes.add(graphObject.getSyncNode())) {
                ++this.size;
                if (graphObject.getSyncNode() instanceof File) {
                    this.size += ((File)graphObject.getSyncNode()).getSize().intValue() / 65536 + 2;
                }
                return true;
            }
        } else if (this.relationships.add(graphObject.getSyncRelationship())) {
            ++this.size;
            return true;
        }
        return false;
    }

    public Set<NodeInterface> getNodes() {
        return this.nodes;
    }

    public Set<RelationshipInterface> getRelationships() {
        return this.relationships;
    }

    public int getTotalSize() {
        return this.size;
    }

    public static ExportSet getInstance() {
        return new ExportSet();
    }

    public static ExportSet getInstance(GraphObject graphObject, boolean bl) throws FrameworkException {
        ExportSet exportSet = new ExportSet();
        exportSet.collectSyncables(graphObject, bl);
        return exportSet;
    }

    private void collectSyncables(GraphObject graphObject, boolean bl) throws FrameworkException {
        this.add(graphObject);
        if (bl) {
            for (GraphObject graphObject2 : graphObject.getSyncData()) {
                if (graphObject2 == null || !this.add(graphObject2)) continue;
                this.collectSyncables(graphObject2, bl);
            }
        }
    }
}

