/*
 * Decompiled with CFR 0.152.
 */
package org.structr.cloud.message;

import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.IOException;
import javax.crypto.Cipher;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.structr.cloud.CloudConnection;
import org.structr.cloud.message.AuthenticationResponse;
import org.structr.cloud.message.Error;
import org.structr.cloud.message.Message;
import org.structr.common.error.FrameworkException;
import org.structr.core.entity.Principal;
import org.structr.core.graph.SyncCommand;

public class AuthenticationRequest
extends Message {
    private static final Logger logger = LoggerFactory.getLogger((String)AuthenticationRequest.class.getName());
    private String userName = null;
    private String salt = null;
    private int keyLength = 128;
    private int protocolVersion = 0;

    public AuthenticationRequest() {
    }

    public AuthenticationRequest(String string, int n) {
        this.userName = string;
        this.keyLength = n;
    }

    public String getUserName() {
        return this.userName;
    }

    public void setUserName(String string) {
        this.userName = string;
    }

    public String getSalt() {
        return this.salt;
    }

    public int getKeyLength() {
        return this.keyLength;
    }

    @Override
    public void onRequest(CloudConnection cloudConnection) throws IOException, FrameworkException {
        if (this.protocolVersion != 4) {
            cloudConnection.send(new Error(400, "Unsupported protocol version " + this.protocolVersion + ", server needs " + 4));
            return;
        }
        Principal principal = cloudConnection.getUser(this.userName);
        if (principal != null) {
            try {
                this.keyLength = Math.min(this.keyLength, Cipher.getMaxAllowedKeyLength("RC4"));
                this.salt = principal.getSalt();
                cloudConnection.impersonateUser(principal);
                cloudConnection.send(new AuthenticationResponse(this.userName, principal.getEncryptedPassword(), this.salt, this.keyLength));
            }
            catch (Throwable throwable) {
                logger.warn("", throwable);
            }
        } else {
            cloudConnection.send(new Error(401, "Authentication failed."));
        }
    }

    @Override
    public void onResponse(CloudConnection cloudConnection) throws IOException, FrameworkException {
    }

    @Override
    public void afterSend(CloudConnection cloudConnection) {
    }

    @Override
    protected void deserializeFrom(DataInputStream dataInputStream) throws IOException {
        this.userName = (String)SyncCommand.deserialize((DataInputStream)dataInputStream);
        this.salt = (String)SyncCommand.deserialize((DataInputStream)dataInputStream);
        this.keyLength = (Integer)SyncCommand.deserialize((DataInputStream)dataInputStream);
        this.protocolVersion = (Integer)SyncCommand.deserialize((DataInputStream)dataInputStream);
    }

    @Override
    protected void serializeTo(DataOutputStream dataOutputStream) throws IOException {
        SyncCommand.serialize((DataOutputStream)dataOutputStream, (Object)this.userName);
        SyncCommand.serialize((DataOutputStream)dataOutputStream, (Object)this.salt);
        SyncCommand.serialize((DataOutputStream)dataOutputStream, (Object)this.keyLength);
        SyncCommand.serialize((DataOutputStream)dataOutputStream, (Object)4);
    }
}

