/*
 * Decompiled with CFR 0.152.
 */
package org.structr.cloud.message;

import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.IOException;
import java.security.InvalidKeyException;
import javax.crypto.Cipher;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.structr.cloud.CloudConnection;
import org.structr.cloud.message.Crypt;
import org.structr.cloud.message.Message;
import org.structr.common.error.FrameworkException;
import org.structr.core.auth.HashHelper;
import org.structr.core.graph.SyncCommand;

public class AuthenticationResponse
extends Message {
    private static final Logger logger = LoggerFactory.getLogger((String)AuthenticationResponse.class.getName());
    private transient String encryptionKey = null;
    private String userName = null;
    private String salt = null;
    private int keyLength = 128;

    public AuthenticationResponse() {
    }

    public AuthenticationResponse(String string, String string2, String string3, int n) {
        this.encryptionKey = string2;
        this.userName = string;
        this.salt = string3;
        this.keyLength = n;
    }

    public String getUserName() {
        return this.userName;
    }

    public void setUserName(String string) {
        this.userName = string;
    }

    public String getSalt() {
        return this.salt;
    }

    public String getEncryptionKey(String string) {
        return HashHelper.getHash((String)string, (String)this.salt);
    }

    public int getKeyLength() {
        return this.keyLength;
    }

    @Override
    public void onRequest(CloudConnection cloudConnection) throws IOException, FrameworkException {
        try {
            cloudConnection.setEncryptionKey(this.getEncryptionKey(cloudConnection.getPassword()), Math.min(this.keyLength, Cipher.getMaxAllowedKeyLength("RC4")));
            cloudConnection.send(new Crypt());
        }
        catch (Throwable throwable) {
            logger.warn("", throwable);
        }
    }

    @Override
    public void onResponse(CloudConnection cloudConnection) throws IOException, FrameworkException {
    }

    @Override
    public void afterSend(CloudConnection cloudConnection) {
        if (this.encryptionKey != null) {
            try {
                cloudConnection.setEncryptionKey(this.encryptionKey, this.keyLength);
            }
            catch (InvalidKeyException invalidKeyException) {
                logger.warn("", (Throwable)invalidKeyException);
            }
        }
    }

    @Override
    protected void deserializeFrom(DataInputStream dataInputStream) throws IOException {
        this.userName = (String)SyncCommand.deserialize((DataInputStream)dataInputStream);
        this.salt = (String)SyncCommand.deserialize((DataInputStream)dataInputStream);
        this.keyLength = (Integer)SyncCommand.deserialize((DataInputStream)dataInputStream);
    }

    @Override
    protected void serializeTo(DataOutputStream dataOutputStream) throws IOException {
        SyncCommand.serialize((DataOutputStream)dataOutputStream, (Object)this.userName);
        SyncCommand.serialize((DataOutputStream)dataOutputStream, (Object)this.salt);
        SyncCommand.serialize((DataOutputStream)dataOutputStream, (Object)this.keyLength);
    }
}

