/*
 * Decompiled with CFR 0.152.
 */
package org.structr.cloud.message;

import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.nio.file.Files;
import java.nio.file.Path;
import java.nio.file.StandardCopyOption;
import java.util.Iterator;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.structr.cloud.CloudConnection;
import org.structr.cloud.message.FileNodeChunk;
import org.structr.cloud.message.NodeDataContainer;
import org.structr.common.error.FrameworkException;
import org.structr.core.graph.NodeInterface;
import org.structr.core.graph.SyncCommand;

public class FileNodeDataContainer
extends NodeDataContainer {
    private static final Logger logger = LoggerFactory.getLogger((String)FileNodeDataContainer.class.getName());
    private transient File temporaryFile = null;
    private transient OutputStream outputStream = null;
    private long fileSize = 0L;

    public FileNodeDataContainer() throws FrameworkException {
    }

    public FileNodeDataContainer(org.structr.dynamic.File file) throws FrameworkException {
        super((NodeInterface)file, 0);
        this.fileSize = file.getSize();
    }

    @Override
    public void onRequest(CloudConnection cloudConnection) throws IOException, FrameworkException {
        cloudConnection.beginFile(this);
        this.sendKeepalive(cloudConnection);
    }

    @Override
    public void onResponse(CloudConnection cloudConnection) throws IOException, FrameworkException {
    }

    public void addChunk(FileNodeChunk fileNodeChunk) {
        if (this.fileSize > 0L) {
            if (fileNodeChunk.getFileSize() != this.fileSize) {
                throw new IllegalStateException("File size mismatch while adding chunk. Expected " + this.fileSize + ", received " + fileNodeChunk.getFileSize());
            }
        } else {
            this.fileSize = fileNodeChunk.getFileSize();
        }
        if (fileNodeChunk.getSequenceNumber() != this.sequenceNumber) {
            throw new IllegalStateException("Sequence number mismatch while adding chunk. Expected " + this.sequenceNumber + ", received " + fileNodeChunk.getSequenceNumber());
        }
        ++this.sequenceNumber;
        try {
            if (this.temporaryFile == null) {
                this.temporaryFile = File.createTempFile("structr", "file");
                this.outputStream = new FileOutputStream(this.temporaryFile);
            }
            if (this.outputStream != null) {
                this.outputStream.write(fileNodeChunk.getBinaryContent());
            }
        }
        catch (Throwable throwable) {
            logger.warn("", throwable);
        }
    }

    public void flushAndCloseTemporaryFile() {
        if (this.outputStream != null) {
            try {
                this.outputStream.flush();
                this.outputStream.close();
            }
            catch (Throwable throwable) {
                logger.warn("", throwable);
            }
        } else {
            logger.warn("outputStream was null, fileSize: " + this.fileSize + "..");
        }
    }

    public boolean persistTemporaryFile(String string) throws IOException {
        boolean bl = false;
        if (this.temporaryFile != null) {
            File file = new File(string);
            Path path = this.temporaryFile.toPath();
            Path path2 = file.toPath();
            file.mkdirs();
            Files.move(path, path2, StandardCopyOption.REPLACE_EXISTING);
        }
        return bl;
    }

    public long getFileSize() {
        return this.fileSize;
    }

    public void setFileSize(long l) {
        this.fileSize = l;
    }

    @Override
    protected void deserializeFrom(DataInputStream dataInputStream) throws IOException {
        this.fileSize = (Long)SyncCommand.deserialize((DataInputStream)dataInputStream);
        super.deserializeFrom(dataInputStream);
    }

    @Override
    protected void serializeTo(DataOutputStream dataOutputStream) throws IOException {
        SyncCommand.serialize((DataOutputStream)dataOutputStream, (Object)this.fileSize);
        super.serializeTo(dataOutputStream);
    }

    public static Iterable<FileNodeChunk> getChunks(final org.structr.dynamic.File file, final int n) {
        return new Iterable<FileNodeChunk>(){

            @Override
            public Iterator<FileNodeChunk> iterator() {
                return new ChunkIterator(file, n);
            }
        };
    }

    private static class ChunkIterator
    implements Iterator<FileNodeChunk> {
        private InputStream inputStream = null;
        private org.structr.dynamic.File fileNode = null;
        private int sequenceNumber = 0;
        private long fileSize = 0L;
        private int chunkSize = 0;

        public ChunkIterator(org.structr.dynamic.File file, int n) {
            this.fileNode = file;
            this.fileSize = file.getSize();
            this.chunkSize = n;
            this.inputStream = file.getInputStream();
        }

        @Override
        public boolean hasNext() {
            boolean bl = false;
            if (this.inputStream != null) {
                try {
                    boolean bl2 = bl = this.inputStream.available() > 0;
                    if (!bl) {
                        this.inputStream.close();
                    }
                }
                catch (Throwable throwable) {
                    logger.warn("Exception in ChunkIterator: {}", throwable);
                }
            }
            return bl;
        }

        @Override
        public FileNodeChunk next() {
            FileNodeChunk fileNodeChunk = null;
            if (this.inputStream != null) {
                try {
                    int n = this.inputStream.available();
                    int n2 = n < this.chunkSize ? n : this.chunkSize;
                    fileNodeChunk = new FileNodeChunk(this.fileNode.getUuid(), this.fileSize, this.sequenceNumber, n2);
                    this.inputStream.read(fileNodeChunk.getBuffer(), 0, n2);
                    ++this.sequenceNumber;
                }
                catch (Throwable throwable) {
                    logger.warn("Exception in ChunkIterator: {}", throwable);
                }
            }
            return fileNodeChunk;
        }

        @Override
        public void remove() {
            throw new UnsupportedOperationException("Not supported.");
        }
    }
}

