/*
 * Decompiled with CFR 0.152.
 */
package org.structr.cloud.message;

import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.IOException;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.List;
import org.apache.commons.lang3.StringUtils;
import org.structr.cloud.CloudConnection;
import org.structr.cloud.message.Message;
import org.structr.cloud.message.SyncableInfo;
import org.structr.common.error.FrameworkException;
import org.structr.core.GraphObject;
import org.structr.core.graph.SyncCommand;
import org.structr.schema.SchemaHelper;

public class ListSyncables
extends Message<List<SyncableInfo>> {
    private List<SyncableInfo> syncables = new LinkedList<SyncableInfo>();
    private String type = null;

    public ListSyncables() {
    }

    public ListSyncables(String string) {
        this.type = string;
    }

    @Override
    public void onRequest(CloudConnection cloudConnection) throws IOException, FrameworkException {
        String[] stringArray = StringUtils.split((String)this.type, (String)", ");
        HashSet<Class<? extends GraphObject>> hashSet = new HashSet<Class<? extends GraphObject>>();
        if (this.type != null) {
            for (String string : stringArray) {
                Class clazz = SchemaHelper.getEntityClassForRawType((String)string);
                if (clazz == null) continue;
                hashSet.add(clazz);
            }
        }
        this.syncables = cloudConnection.listSyncables(hashSet);
        cloudConnection.send(this);
    }

    @Override
    public void onResponse(CloudConnection cloudConnection) throws IOException, FrameworkException {
        cloudConnection.setPayload(this.syncables);
    }

    @Override
    public void afterSend(CloudConnection cloudConnection) {
    }

    @Override
    protected void deserializeFrom(DataInputStream dataInputStream) throws IOException {
        this.type = (String)SyncCommand.deserialize((DataInputStream)dataInputStream);
        int n = (Integer)SyncCommand.deserialize((DataInputStream)dataInputStream);
        for (int i = 0; i < n; ++i) {
            SyncableInfo syncableInfo = new SyncableInfo();
            syncableInfo.deserializeFrom(dataInputStream);
            this.syncables.add(syncableInfo);
        }
    }

    @Override
    protected void serializeTo(DataOutputStream dataOutputStream) throws IOException {
        SyncCommand.serialize((DataOutputStream)dataOutputStream, (Object)this.type);
        SyncCommand.serialize((DataOutputStream)dataOutputStream, (Object)this.syncables.size());
        for (SyncableInfo syncableInfo : this.syncables) {
            syncableInfo.serializeTo(dataOutputStream);
        }
    }
}

