/*
 * Decompiled with CFR 0.152.
 */
package org.structr.cloud.message;

import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.EOFException;
import java.io.IOException;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.Set;
import java.util.TreeSet;
import java.util.concurrent.atomic.AtomicLong;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.structr.api.graph.Node;
import org.structr.api.graph.PropertyContainer;
import org.structr.api.graph.Relationship;
import org.structr.cloud.CloudConnection;
import org.structr.cloud.CloudListener;
import org.structr.cloud.message.AuthenticationRequest;
import org.structr.cloud.message.AuthenticationResponse;
import org.structr.cloud.message.Begin;
import org.structr.cloud.message.Crypt;
import org.structr.cloud.message.Delete;
import org.structr.cloud.message.End;
import org.structr.cloud.message.Error;
import org.structr.cloud.message.FileNodeChunk;
import org.structr.cloud.message.FileNodeDataContainer;
import org.structr.cloud.message.FileNodeEndChunk;
import org.structr.cloud.message.Finish;
import org.structr.cloud.message.ListSyncables;
import org.structr.cloud.message.NodeDataContainer;
import org.structr.cloud.message.PullChunk;
import org.structr.cloud.message.PullFile;
import org.structr.cloud.message.PullNode;
import org.structr.cloud.message.PullNodeRequestContainer;
import org.structr.cloud.message.PullRelationship;
import org.structr.cloud.message.RelationshipDataContainer;
import org.structr.cloud.sync.Diff;
import org.structr.cloud.sync.EndOfSync;
import org.structr.cloud.sync.Ping;
import org.structr.cloud.sync.ReplicationStatus;
import org.structr.cloud.sync.Synchronize;
import org.structr.common.error.FrameworkException;
import org.structr.core.GraphObject;
import org.structr.core.graph.SyncCommand;

public abstract class Message<T> {
    private static final Logger logger = LoggerFactory.getLogger((String)Message.class.getName());
    private static final AtomicLong idGenerator = new AtomicLong();
    private static final Map<String, Class> typeMap = new LinkedHashMap<String, Class>();
    private static final Set<String> ignoredPropertyKeys = new HashSet<String>();
    protected long id = 0L;
    protected int sendCount = 0;

    public abstract void onRequest(CloudConnection var1) throws IOException, FrameworkException;

    public abstract void onResponse(CloudConnection var1) throws IOException, FrameworkException;

    public abstract void afterSend(CloudConnection var1);

    protected abstract void deserializeFrom(DataInputStream var1) throws IOException;

    protected abstract void serializeTo(DataOutputStream var1) throws IOException;

    public Message() {
        this.id = idGenerator.incrementAndGet();
    }

    public Message(long l, int n) {
        this.id = l;
        this.sendCount = n;
    }

    public long getId() {
        return this.id;
    }

    public String toString() {
        return this.getClass().getSimpleName() + "(" + this.getId() + ")";
    }

    public void serialize(DataOutputStream dataOutputStream) throws IOException {
        String string = this.getClass().getSimpleName();
        SyncCommand.serialize((DataOutputStream)dataOutputStream, (Object)string);
        SyncCommand.serialize((DataOutputStream)dataOutputStream, (Object)this.id);
        SyncCommand.serialize((DataOutputStream)dataOutputStream, (Object)(++this.sendCount));
        this.serializeTo(dataOutputStream);
        dataOutputStream.flush();
    }

    public boolean wasSentFromHere() {
        return this.sendCount > 1;
    }

    protected String contentHashCode(GraphObject graphObject) {
        if (graphObject != null) {
            if (graphObject.isNode()) {
                return this.contentHashCode(graphObject.getSyncNode().getNode());
            }
            return this.contentHashCode(graphObject.getSyncRelationship().getRelationship());
        }
        return null;
    }

    protected String contentHashCode(Node node) {
        return this.contentHashCode(node, null);
    }

    protected String contentHashCode(Node node, Set<Long> set) {
        int n = this.propertyHashCode((PropertyContainer)node, this.id, set);
        return Integer.toString(n);
    }

    protected String contentHashCode(Relationship relationship) {
        return this.contentHashCode(relationship, null);
    }

    protected String contentHashCode(Relationship relationship, Set<Long> set) {
        int n = this.propertyHashCode((PropertyContainer)relationship, this.id, set);
        n ^= this.getNodeIdHashCode(relationship.getStartNode());
        return Integer.toString(n ^= this.getNodeIdHashCode(relationship.getEndNode()));
    }

    protected void sendKeepalive(CloudConnection cloudConnection) throws IOException, FrameworkException {
        if (Math.random() < 0.05) {
            String string = "Current batch: " + cloudConnection.getCount() + ", total: " + cloudConnection.getTotal();
            cloudConnection.send(new Ping(string));
            CloudListener cloudListener = cloudConnection.getListener();
            if (cloudListener != null) {
                cloudListener.transmissionProgress(string);
            }
        }
    }

    private int propertyHashCode(PropertyContainer propertyContainer, long l, Set<Long> set) {
        if (set != null) {
            set.add(l);
        }
        TreeSet<String> treeSet = new TreeSet<String>();
        int n = 34262;
        for (String string : propertyContainer.getPropertyKeys()) {
            if (ignoredPropertyKeys.contains(string)) continue;
            treeSet.add(string);
        }
        for (String string : treeSet) {
            Object object = propertyContainer.getProperty(string, null);
            if (object == null) continue;
            n ^= string.hashCode();
            n ^= object.hashCode();
        }
        return n;
    }

    private int getNodeIdHashCode(Node node) {
        Object object = node.getProperty("id", (Object)"");
        if (object != null && object instanceof String) {
            String string = (String)object;
            return string.hashCode();
        }
        return -1;
    }

    private void setId(long l) {
        this.id = l;
    }

    private void setSendCount(int n) {
        this.sendCount = n;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static Message deserialize(DataInputStream dataInputStream) throws IOException {
        String string = (String)SyncCommand.deserialize((DataInputStream)dataInputStream);
        if (string == null) {
            logger.warn("Invalid CloudService message: no type found.");
            return null;
        }
        Class clazz = typeMap.get(string);
        if (clazz == null) {
            logger.warn("Invalid CloudService message: unknown type {}", (Object)string);
            throw new EOFException("Invalid type, aborting.");
        }
        try {
            Message message = (Message)clazz.newInstance();
            message.setId((Long)SyncCommand.deserialize((DataInputStream)dataInputStream));
            message.setSendCount((Integer)SyncCommand.deserialize((DataInputStream)dataInputStream));
            message.deserializeFrom(dataInputStream);
            return message;
        }
        catch (Throwable throwable) {
            logger.warn("", throwable);
            return null;
        }
    }

    static {
        typeMap.put(AuthenticationRequest.class.getSimpleName(), AuthenticationRequest.class);
        typeMap.put(AuthenticationResponse.class.getSimpleName(), AuthenticationResponse.class);
        typeMap.put(Begin.class.getSimpleName(), Begin.class);
        typeMap.put(Crypt.class.getSimpleName(), Crypt.class);
        typeMap.put(Delete.class.getSimpleName(), Delete.class);
        typeMap.put(Diff.class.getSimpleName(), Diff.class);
        typeMap.put(End.class.getSimpleName(), End.class);
        typeMap.put(EndOfSync.class.getSimpleName(), EndOfSync.class);
        typeMap.put(Error.class.getSimpleName(), Error.class);
        typeMap.put(FileNodeChunk.class.getSimpleName(), FileNodeChunk.class);
        typeMap.put(FileNodeDataContainer.class.getSimpleName(), FileNodeDataContainer.class);
        typeMap.put(FileNodeEndChunk.class.getSimpleName(), FileNodeEndChunk.class);
        typeMap.put(Finish.class.getSimpleName(), Finish.class);
        typeMap.put(ListSyncables.class.getSimpleName(), ListSyncables.class);
        typeMap.put(NodeDataContainer.class.getSimpleName(), NodeDataContainer.class);
        typeMap.put(Ping.class.getSimpleName(), Ping.class);
        typeMap.put(PullChunk.class.getSimpleName(), PullChunk.class);
        typeMap.put(PullFile.class.getSimpleName(), PullFile.class);
        typeMap.put(PullNode.class.getSimpleName(), PullNode.class);
        typeMap.put(PullNodeRequestContainer.class.getSimpleName(), PullNodeRequestContainer.class);
        typeMap.put(PullRelationship.class.getSimpleName(), PullRelationship.class);
        typeMap.put(RelationshipDataContainer.class.getSimpleName(), RelationshipDataContainer.class);
        typeMap.put(ReplicationStatus.class.getSimpleName(), ReplicationStatus.class);
        typeMap.put(Synchronize.class.getSimpleName(), Synchronize.class);
        ignoredPropertyKeys.add(GraphObject.createdDate.dbName());
        ignoredPropertyKeys.add(GraphObject.lastModifiedDate.dbName());
    }
}

