/*
 * Decompiled with CFR 0.152.
 */
package org.structr.cloud.message;

import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.IOException;
import java.util.ArrayList;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.structr.cloud.CloudConnection;
import org.structr.cloud.ExportSet;
import org.structr.cloud.message.Finish;
import org.structr.cloud.message.Message;
import org.structr.cloud.message.PullNode;
import org.structr.cloud.message.PullRelationship;
import org.structr.common.error.FrameworkException;
import org.structr.core.GraphObject;
import org.structr.core.app.App;
import org.structr.core.graph.NodeInterface;
import org.structr.core.graph.NodeServiceCommand;
import org.structr.core.graph.RelationshipInterface;
import org.structr.core.graph.SyncCommand;
import org.structr.core.property.PropertyKey;

public class PullNodeRequestContainer
extends Message {
    private static final Logger logger = LoggerFactory.getLogger((String)PullNodeRequestContainer.class.getName());
    private boolean recursive = false;
    private String rootNodeId = null;
    private String key = null;
    private int numNodes = 0;
    private int numRels = 0;

    public PullNodeRequestContainer() {
    }

    public PullNodeRequestContainer(String string, boolean bl) {
        this.rootNodeId = string;
        this.recursive = bl;
    }

    public void setSourceNodeId(String string) {
        this.rootNodeId = string;
    }

    public String getRootNodeId() {
        return this.rootNodeId;
    }

    public boolean isRecursive() {
        return this.recursive;
    }

    public void setRecursive(boolean bl) {
        this.recursive = bl;
    }

    @Override
    public void onRequest(CloudConnection cloudConnection) throws IOException, FrameworkException {
        try {
            App app = cloudConnection.getApplicationContext();
            GraphObject graphObject = app.nodeQuery().and((PropertyKey)GraphObject.id, (Object)this.rootNodeId).includeDeletedAndHidden().getFirst();
            if (graphObject == null) {
                graphObject = app.relationshipQuery().and((PropertyKey)GraphObject.id, (Object)this.rootNodeId).includeDeletedAndHidden().getFirst();
            }
            if (graphObject != null) {
                ExportSet exportSet = ExportSet.getInstance(graphObject, this.recursive);
                this.numNodes = exportSet.getNodes().size();
                this.numRels = exportSet.getRelationships().size();
                this.key = NodeServiceCommand.getNextUuid();
                cloudConnection.storeValue(this.key + "Nodes", new ArrayList<NodeInterface>(exportSet.getNodes()));
                cloudConnection.storeValue(this.key + "Rels", new ArrayList<RelationshipInterface>(exportSet.getRelationships()));
                cloudConnection.send(this);
            }
        }
        catch (FrameworkException frameworkException) {
            logger.warn("", (Throwable)frameworkException);
        }
    }

    @Override
    public void onResponse(CloudConnection cloudConnection) throws IOException, FrameworkException {
        int n;
        for (n = 0; n < this.numNodes; ++n) {
            cloudConnection.send(new PullNode(this.key, n));
        }
        for (n = 0; n < this.numRels; ++n) {
            cloudConnection.send(new PullRelationship(this.key, n));
        }
        cloudConnection.send(new Finish());
    }

    @Override
    public void afterSend(CloudConnection cloudConnection) {
    }

    public int getNumNodes() {
        return this.numNodes;
    }

    public int getNumRels() {
        return this.numRels;
    }

    public String getKey() {
        return this.key;
    }

    @Override
    protected void deserializeFrom(DataInputStream dataInputStream) throws IOException {
        this.recursive = (Boolean)SyncCommand.deserialize((DataInputStream)dataInputStream);
        this.rootNodeId = (String)SyncCommand.deserialize((DataInputStream)dataInputStream);
        this.key = (String)SyncCommand.deserialize((DataInputStream)dataInputStream);
        this.numNodes = (Integer)SyncCommand.deserialize((DataInputStream)dataInputStream);
        this.numRels = (Integer)SyncCommand.deserialize((DataInputStream)dataInputStream);
    }

    @Override
    protected void serializeTo(DataOutputStream dataOutputStream) throws IOException {
        SyncCommand.serialize((DataOutputStream)dataOutputStream, (Object)this.recursive);
        SyncCommand.serialize((DataOutputStream)dataOutputStream, (Object)this.rootNodeId);
        SyncCommand.serialize((DataOutputStream)dataOutputStream, (Object)this.key);
        SyncCommand.serialize((DataOutputStream)dataOutputStream, (Object)this.numNodes);
        SyncCommand.serialize((DataOutputStream)dataOutputStream, (Object)this.numRels);
    }
}

