/*
 * Decompiled with CFR 0.152.
 */
package org.structr.cloud.sync;

import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.IOException;
import org.structr.cloud.CloudConnection;
import org.structr.cloud.message.Delete;
import org.structr.cloud.message.Message;
import org.structr.cloud.message.NodeDataContainer;
import org.structr.cloud.message.RelationshipDataContainer;
import org.structr.cloud.transmission.PushTransmission;
import org.structr.common.error.FrameworkException;
import org.structr.core.GraphObject;
import org.structr.core.app.StructrApp;
import org.structr.core.graph.SyncCommand;
import org.structr.dynamic.File;

public class Diff
extends Message {
    private String uuid = null;
    private String hash = null;

    public Diff() {
    }

    public Diff(String string, String string2) throws FrameworkException {
        this.hash = string2;
        this.uuid = string;
    }

    @Override
    public void onRequest(CloudConnection cloudConnection) throws IOException, FrameworkException {
        GraphObject graphObject = StructrApp.getInstance().get(this.uuid);
        if (graphObject != null) {
            String string = this.contentHashCode(graphObject);
            if (!string.equals(this.hash)) {
                if (graphObject.isNode()) {
                    if (graphObject instanceof File) {
                        PushTransmission.sendFile(cloudConnection, (File)graphObject, 65536);
                    } else {
                        cloudConnection.send(new NodeDataContainer(graphObject.getSyncNode(), 0));
                    }
                } else {
                    cloudConnection.send(new RelationshipDataContainer(graphObject.getSyncRelationship(), 0));
                }
            }
        } else {
            cloudConnection.send(new Delete(this.uuid));
        }
    }

    @Override
    public void onResponse(CloudConnection cloudConnection) throws IOException, FrameworkException {
    }

    @Override
    public void afterSend(CloudConnection cloudConnection) {
    }

    @Override
    protected void deserializeFrom(DataInputStream dataInputStream) throws IOException {
        this.uuid = (String)SyncCommand.deserialize((DataInputStream)dataInputStream);
        this.hash = (String)SyncCommand.deserialize((DataInputStream)dataInputStream);
    }

    @Override
    protected void serializeTo(DataOutputStream dataOutputStream) throws IOException {
        SyncCommand.serialize((DataOutputStream)dataOutputStream, (Object)this.uuid);
        SyncCommand.serialize((DataOutputStream)dataOutputStream, (Object)this.hash);
    }
}

