/*
 * Decompiled with CFR 0.152.
 */
package org.structr.cloud.sync;

import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.IOException;
import org.structr.api.config.Settings;
import org.structr.cloud.CloudConnection;
import org.structr.cloud.message.Finish;
import org.structr.cloud.message.Message;
import org.structr.common.error.FrameworkException;
import org.structr.core.app.App;
import org.structr.core.app.StructrApp;
import org.structr.core.graph.SyncCommand;

public class ReplicationStatus
extends Message<ReplicationStatus> {
    private String masterId = null;
    private String slaveId = null;
    private String role = null;
    private long lastSync = 0L;
    private boolean update = false;

    public ReplicationStatus() {
    }

    public ReplicationStatus(String string) {
        this(string, 0L, false);
    }

    public ReplicationStatus(String string, long l) {
        this(string, l, true);
    }

    private ReplicationStatus(String string, long l, boolean bl) {
        this.masterId = string;
        this.lastSync = l;
        this.update = bl;
    }

    public String getSlaveId() {
        return this.slaveId;
    }

    public long getLastSync() {
        return this.lastSync;
    }

    public String getRole() {
        return this.role;
    }

    @Override
    public void onRequest(CloudConnection cloudConnection) throws IOException, FrameworkException {
        App app = StructrApp.getInstance();
        this.slaveId = app.getInstanceId();
        if (this.update) {
            app.setGlobalSetting(this.masterId, (Object)this.lastSync);
        } else {
            this.lastSync = (Long)app.getGlobalSetting(this.masterId, (Object)0L);
            this.role = (String)Settings.getOrCreateStringSetting((String[])new String[]{"sync", "role"}).getValue((Object)"slave");
        }
        cloudConnection.send(this);
        cloudConnection.send(new Finish());
    }

    @Override
    public void onResponse(CloudConnection cloudConnection) throws IOException, FrameworkException {
        cloudConnection.setPayload(this);
    }

    @Override
    public void afterSend(CloudConnection cloudConnection) {
    }

    @Override
    protected void deserializeFrom(DataInputStream dataInputStream) throws IOException {
        this.masterId = (String)SyncCommand.deserialize((DataInputStream)dataInputStream);
        this.slaveId = (String)SyncCommand.deserialize((DataInputStream)dataInputStream);
        this.role = (String)SyncCommand.deserialize((DataInputStream)dataInputStream);
        this.lastSync = (Long)SyncCommand.deserialize((DataInputStream)dataInputStream);
        this.update = (Boolean)SyncCommand.deserialize((DataInputStream)dataInputStream);
    }

    @Override
    protected void serializeTo(DataOutputStream dataOutputStream) throws IOException {
        SyncCommand.serialize((DataOutputStream)dataOutputStream, (Object)this.masterId);
        SyncCommand.serialize((DataOutputStream)dataOutputStream, (Object)this.slaveId);
        SyncCommand.serialize((DataOutputStream)dataOutputStream, (Object)this.role);
        SyncCommand.serialize((DataOutputStream)dataOutputStream, (Object)this.lastSync);
        SyncCommand.serialize((DataOutputStream)dataOutputStream, (Object)this.update);
    }
}

