/*
 * Decompiled with CFR 0.152.
 */
package org.structr.cloud.sync;

import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.concurrent.ArrayBlockingQueue;
import java.util.concurrent.BlockingQueue;
import org.apache.commons.lang.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.structr.api.config.Settings;
import org.structr.api.service.Command;
import org.structr.api.service.RunnableService;
import org.structr.api.service.StructrServices;
import org.structr.cloud.CloudHost;
import org.structr.cloud.CloudListener;
import org.structr.cloud.CloudService;
import org.structr.cloud.sync.ReplicationStatus;
import org.structr.cloud.sync.SyncTransmission;
import org.structr.cloud.sync.UpdateTransmission;
import org.structr.cloud.transmission.SingleTransmission;
import org.structr.common.SecurityContext;
import org.structr.common.error.FrameworkException;
import org.structr.core.StructrTransactionListener;
import org.structr.core.TransactionSource;
import org.structr.core.app.StructrApp;
import org.structr.core.graph.ModificationEvent;
import org.structr.core.graph.TransactionCommand;
import org.structr.core.graph.Tx;

public class SyncService
extends Thread
implements RunnableService,
StructrTransactionListener {
    private static final BlockingQueue<List<ModificationEvent>> syncQueue = new ArrayBlockingQueue<List<ModificationEvent>>(1000);
    private static final Logger logger = LoggerFactory.getLogger((String)CloudService.class.getName());
    private final List<SyncHostInfo> syncHosts = new LinkedList<SyncHostInfo>();
    private boolean running = false;
    private boolean active = false;
    private String allowedMaster = null;
    private SyncRole role = null;
    private int requiredSyncCount = 0;
    private int retryInterval = 60;

    public SyncService() {
        super("SyncService");
        this.setDaemon(true);
    }

    public void injectArguments(Command command) {
    }

    public void initialize(StructrServices structrServices) {
        this.active = (Boolean)Settings.getBooleanSetting((String[])new String[]{"sync", "enabled"}).getValue((Object)false);
        if (this.active) {
            this.role = SyncRole.valueOf((String)Settings.getOrCreateStringSetting((String[])new String[]{"sync", "role"}).getValue((Object)"master"));
            this.allowedMaster = (String)Settings.getOrCreateStringSetting((String[])new String[]{"sync", "master"}).getValue();
            if (this.allowedMaster == null && SyncRole.slave.equals((Object)this.role)) {
                throw new IllegalStateException("no master address set for this slave, please set sync.master in structr.conf.");
            }
            String string = (String)Settings.getOrCreateStringSetting((String[])new String[]{"sync.minimum"}).getValue((Object)"1");
            String string2 = (String)Settings.getOrCreateStringSetting((String[])new String[]{"sync.retry"}).getValue((Object)"60");
            String string3 = (String)Settings.getOrCreateStringSetting((String[])new String[]{"sync.hosts"}).getValue();
            String string4 = (String)Settings.getOrCreateStringSetting((String[])new String[]{"sync.users"}).getValue();
            String string5 = (String)Settings.getOrCreateStringSetting((String[])new String[]{"sync.passwords"}).getValue();
            String string6 = (String)Settings.getOrCreateStringSetting((String[])new String[]{"sync.ports"}).getValue();
            if (SyncRole.master.equals((Object)this.role)) {
                if (StringUtils.isEmpty((String)string3)) {
                    throw new IllegalStateException("no slave hosts set for this master, please set sync.hosts in structr.conf.");
                }
                if (StringUtils.isEmpty((String)string4)) {
                    throw new IllegalStateException("no slave users set for this master, please set sync.users in structr.conf.");
                }
                if (StringUtils.isEmpty((String)string5)) {
                    throw new IllegalStateException("no slave passwords set for this master, please set sync.passwords in structr.conf.");
                }
                if (StringUtils.isEmpty((String)string6)) {
                    throw new IllegalStateException("no slave ports set for this master, please set sync.ports in structr.conf.");
                }
                String[] stringArray = string3 != null ? string3.split("[, ]+") : new String[]{};
                String[] stringArray2 = string4 != null ? string4.split("[, ]+") : new String[]{};
                String[] stringArray3 = string5 != null ? string5.split("[, ]+") : new String[]{};
                String[] stringArray4 = string6 != null ? string6.split("[, ]+") : new String[]{};
                String string7 = null;
                String string8 = null;
                String string9 = null;
                for (int i = 0; i < stringArray.length; ++i) {
                    String string10 = stringArray[i];
                    String string11 = stringArray2.length > i ? stringArray2[i] : string7;
                    String string12 = stringArray3.length > i ? stringArray3[i] : string8;
                    String string13 = stringArray4.length > i ? stringArray4[i] : string9;
                    string7 = string11;
                    string8 = string12;
                    string9 = string13;
                    if (StringUtils.isEmpty((String)string11)) {
                        throw new IllegalStateException("no sync user found for remote host " + string10 + ", please set sync.users in structr.conf.");
                    }
                    if (StringUtils.isEmpty((String)string12)) {
                        throw new IllegalStateException("no sync password found for remote host " + string10 + ", please set sync.passwords in structr.conf.");
                    }
                    if (StringUtils.isEmpty((String)string13)) {
                        throw new IllegalStateException("no sync port found for remote host " + string10 + ", please set sync.ports in structr.conf.");
                    }
                    SyncHostInfo syncHostInfo = new SyncHostInfo(string10, string11, string12, string13);
                    this.syncHosts.add(syncHostInfo);
                    logger.info("Adding slave host {}, user {}", new Object[]{syncHostInfo, string13, string11});
                }
                try {
                    this.initializeSyncHosts(string);
                }
                catch (FrameworkException frameworkException) {
                    logger.warn("", (Throwable)frameworkException);
                }
            }
            if (StringUtils.isNotBlank((String)string2)) {
                this.retryInterval = Integer.valueOf(string2);
            }
            logger.info("Retry interval is set to {} seconds", (Object)this.retryInterval);
        }
    }

    public void initialized() {
    }

    public void shutdown() {
        this.running = false;
    }

    public boolean isRunning() {
        return this.running;
    }

    public void startService() throws Exception {
        TransactionCommand.registerTransactionListener((StructrTransactionListener)this);
        this.running = true;
        this.start();
        logger.info("SyncService successfully started.");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void run() {
        while (this.running) {
            try {
                Collection<List<Object>> collection = syncQueue;
                synchronized (collection) {
                    while (syncQueue.isEmpty()) {
                        syncQueue.wait();
                    }
                }
                collection = (List)syncQueue.peek();
                if (collection == null) continue;
                SyncListener syncListener = new SyncListener(this.requiredSyncCount);
                SyncTransmission syncTransmission = new SyncTransmission((List<ModificationEvent>)collection);
                for (SyncHostInfo syncHostInfo : this.syncHosts) {
                    try {
                        CloudService.doRemote(SecurityContext.getSuperUserInstance(), syncTransmission, syncHostInfo, syncListener);
                    }
                    catch (FrameworkException frameworkException) {
                        logger.warn("Unable to synchronize with host {}: {}", new Object[]{syncHostInfo, frameworkException.getMessage()});
                    }
                }
                if (syncListener.wasSuccessful()) {
                    syncQueue.remove(collection);
                    continue;
                }
                logger.warn("Unable to synchronize with required number of hosts, retrying in {} seconds..", (Object)this.retryInterval);
                try {
                    Thread.sleep(this.retryInterval * 1000);
                }
                catch (Throwable throwable) {
                }
            }
            catch (Throwable throwable) {
                logger.warn("", throwable);
            }
        }
    }

    public void stopService() {
        this.shutdown();
    }

    public boolean runOnStartup() {
        return true;
    }

    public boolean isVital() {
        return true;
    }

    public String getModuleName() {
        return "cloud";
    }

    public void beforeCommit(SecurityContext securityContext, Collection<ModificationEvent> collection, TransactionSource transactionSource) throws FrameworkException {
        if (!(!SyncRole.slave.equals((Object)this.role) || transactionSource != null && this.allowedMaster.equals(transactionSource.getOriginAddress()) || collection == null || collection.isEmpty())) {
            throw new FrameworkException(500, "Illegal write transaction on active slave.");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void afterCommit(SecurityContext securityContext, Collection<ModificationEvent> collection, TransactionSource transactionSource) {
        if (transactionSource != null && transactionSource.isRemote()) {
            return;
        }
        if (this.active && this.running && !collection.isEmpty()) {
            Object object;
            try {
                object = StructrApp.getInstance();
                object.setGlobalSetting(object.getInstanceId() + ".lastModified", (Object)System.currentTimeMillis());
            }
            catch (FrameworkException frameworkException) {
                logger.error("Unable to store last modified date for current instance.", (Throwable)frameworkException);
            }
            try {
                syncQueue.put(new ArrayList<ModificationEvent>(collection));
                object = syncQueue;
                synchronized (object) {
                    syncQueue.notify();
                }
            }
            catch (InterruptedException interruptedException) {
                logger.warn("", (Throwable)interruptedException);
            }
        }
    }

    private void initializeSyncHosts(String string) throws FrameworkException {
        SimpleDateFormat simpleDateFormat = new SimpleDateFormat("yyyy/MM/dd HH:mm:ss");
        String string2 = StructrApp.getInstance().getInstanceId();
        Iterator<SyncHostInfo> iterator = this.syncHosts.iterator();
        while (iterator.hasNext()) {
            SyncHostInfo syncHostInfo = iterator.next();
            boolean bl = true;
            try {
                SingleTransmission<ReplicationStatus> singleTransmission = new SingleTransmission<ReplicationStatus>(new ReplicationStatus(string2));
                ReplicationStatus replicationStatus = CloudService.doRemote(SecurityContext.getSuperUserInstance(), singleTransmission, syncHostInfo, new LoggingListener());
                if (replicationStatus != null) {
                    String string3 = replicationStatus.getSlaveId();
                    if (string3 != null) {
                        long l = replicationStatus.getLastSync();
                        String string4 = "not synced yet";
                        if (l != 0L) {
                            string4 = "last sync was " + simpleDateFormat.format(l);
                        }
                        logger.info("Determined instance ID of {} to be {}, {}.", new Object[]{syncHostInfo, string3, string4});
                        syncHostInfo.setReplicationStatus(replicationStatus);
                    } else {
                        bl = false;
                    }
                } else {
                    bl = false;
                }
            }
            catch (Throwable throwable) {
                logger.warn("", throwable);
                bl = false;
            }
            if (bl) continue;
            logger.warn("Synchronization slave {} not reachable, removing from list.", (Object)syncHostInfo);
            iterator.remove();
        }
        int n = this.syncHosts.size();
        this.requiredSyncCount = Integer.valueOf(string);
        if (n < this.requiredSyncCount) {
            throw new IllegalStateException("synchronization policy requires at least " + this.requiredSyncCount + " hosts, but only " + n + " are reachable.");
        }
        logger.info("Synchronization to {} host{} required.", new Object[]{this.requiredSyncCount, this.requiredSyncCount == 1 ? "" : "s"});
        for (SyncHostInfo syncHostInfo : this.syncHosts) {
            this.checkAndInitializeSyncHost(syncHostInfo);
        }
    }

    private void checkAndInitializeSyncHost(SyncHostInfo syncHostInfo) throws FrameworkException {
        String string = StructrApp.getInstance().getInstanceId();
        SimpleDateFormat simpleDateFormat = new SimpleDateFormat("yyyy/MM/dd HH:mm:ss");
        long l = (Long)StructrApp.getInstance().getGlobalSetting(string + ".lastModified", (Object)0L);
        if (l == 0L) {
            this.synchronizeSlave(syncHostInfo);
        } else if (syncHostInfo.getLastSyncTimestamp() != l) {
            logger.info("Replication host {} is out of sync, last remote update was {} whereas last local update was {}", new Object[]{syncHostInfo, simpleDateFormat.format(syncHostInfo.getLastSyncTimestamp()), simpleDateFormat.format(l)});
            this.synchronizeSlave(syncHostInfo);
        } else {
            logger.info("Replication host {} is in sync, last update was {}", new Object[]{syncHostInfo, simpleDateFormat.format(l)});
        }
    }

    private void synchronizeSlave(SyncHostInfo syncHostInfo) {
        logger.info("Establishing initial replication.");
        try (Tx tx = StructrApp.getInstance().tx();){
            CloudService.doRemote(SecurityContext.getSuperUserInstance(), new UpdateTransmission(), syncHostInfo, new LoggingListener());
            tx.success();
        }
        catch (Throwable throwable) {
            logger.warn("", throwable);
        }
        logger.info("Done.");
    }

    private class LoggingListener
    implements CloudListener {
        private LoggingListener() {
        }

        @Override
        public void transmissionStarted() {
            logger.info("Transmission started");
        }

        @Override
        public void transmissionFinished() {
            logger.info("Transmission finished");
        }

        @Override
        public void transmissionAborted() {
            logger.info("Transmission aborted");
        }

        @Override
        public void transmissionProgress(String string) {
            logger.info("Transmission progress {}", (Object)string);
        }
    }

    private static class SyncHostInfo
    implements CloudHost {
        private ReplicationStatus status = null;
        private String instanceId = null;
        private String host = null;
        private String user = null;
        private String pwd = null;
        private int port = -1;

        public SyncHostInfo(String string, String string2, String string3, String string4) {
            this.host = string;
            this.user = string2;
            this.pwd = string3;
            this.port = Integer.valueOf(string4);
        }

        public String toString() {
            return this.host + ":" + this.port;
        }

        @Override
        public String getHostName() {
            return this.host;
        }

        @Override
        public String getUserName() {
            return this.user;
        }

        @Override
        public String getPassword() {
            return this.pwd;
        }

        @Override
        public int getPort() {
            return this.port;
        }

        public void setReplicationStatus(ReplicationStatus replicationStatus) {
            this.instanceId = replicationStatus.getSlaveId();
            this.status = replicationStatus;
        }

        public long getLastSyncTimestamp() {
            return this.status.getLastSync();
        }

        public String getInstanceId() {
            return this.instanceId;
        }
    }

    private static class SyncListener
    implements CloudListener {
        private int successCount = 0;
        private int requiredSuccessCount = 0;

        public SyncListener(int n) {
            this.requiredSuccessCount = n;
        }

        @Override
        public void transmissionStarted() {
        }

        @Override
        public void transmissionFinished() {
            ++this.successCount;
        }

        @Override
        public void transmissionAborted() {
        }

        @Override
        public void transmissionProgress(String string) {
        }

        public boolean wasSuccessful() {
            return this.successCount >= this.requiredSuccessCount;
        }
    }

    public static enum SyncRole {
        master,
        slave;

    }
}

