/*
 * Decompiled with CFR 0.152.
 */
package org.structr.cloud.sync;

import java.io.IOException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.structr.api.DatabaseService;
import org.structr.api.graph.Node;
import org.structr.api.graph.Relationship;
import org.structr.cloud.CloudConnection;
import org.structr.cloud.CloudTransmission;
import org.structr.cloud.message.NodeDataContainer;
import org.structr.cloud.message.RelationshipDataContainer;
import org.structr.cloud.sync.Synchronize;
import org.structr.cloud.transmission.PushTransmission;
import org.structr.common.SecurityContext;
import org.structr.common.error.FrameworkException;
import org.structr.core.app.StructrApp;
import org.structr.core.graph.NodeFactory;
import org.structr.core.graph.NodeInterface;
import org.structr.core.graph.RelationshipFactory;
import org.structr.core.graph.RelationshipInterface;
import org.structr.dynamic.File;

public class UpdateTransmission
implements CloudTransmission {
    private static final Logger logger = LoggerFactory.getLogger((String)UpdateTransmission.class.getName());

    public Boolean doRemote(CloudConnection cloudConnection) throws IOException, FrameworkException {
        NodeInterface nodeInterface;
        cloudConnection.send(new Synchronize());
        DatabaseService databaseService = StructrApp.getInstance().getDatabaseService();
        NodeFactory nodeFactory = new NodeFactory(SecurityContext.getSuperUserInstance());
        RelationshipFactory relationshipFactory = new RelationshipFactory(SecurityContext.getSuperUserInstance());
        for (Node node : databaseService.getAllNodes()) {
            nodeInterface = nodeFactory.instantiate(node);
            if (nodeInterface instanceof File) {
                PushTransmission.sendFile(cloudConnection, (File)nodeInterface, 65536);
                continue;
            }
            cloudConnection.send(new NodeDataContainer(nodeInterface, 0));
        }
        for (Node node : databaseService.getAllRelationships()) {
            nodeInterface = relationshipFactory.instantiate((Relationship)node);
            cloudConnection.send(new RelationshipDataContainer((RelationshipInterface)nodeInterface, 0));
        }
        cloudConnection.waitForTransmission();
        return true;
    }
}

