/*
 * Decompiled with CFR 0.152.
 */
package org.structr.cloud.transmission;

import java.io.IOException;
import java.util.Iterator;
import java.util.Set;
import org.structr.cloud.CloudConnection;
import org.structr.cloud.CloudTransmission;
import org.structr.cloud.ExportSet;
import org.structr.cloud.message.End;
import org.structr.cloud.message.FileNodeChunk;
import org.structr.cloud.message.FileNodeDataContainer;
import org.structr.cloud.message.FileNodeEndChunk;
import org.structr.cloud.message.NodeDataContainer;
import org.structr.cloud.message.RelationshipDataContainer;
import org.structr.common.error.FrameworkException;
import org.structr.core.GraphObject;
import org.structr.core.graph.NodeInterface;
import org.structr.core.graph.RelationshipInterface;
import org.structr.dynamic.File;

public class PushTransmission
implements CloudTransmission {
    private ExportSet exportSet = null;
    private int sequenceNumber = 0;

    public PushTransmission(GraphObject graphObject, boolean bl) throws FrameworkException {
        this.exportSet = ExportSet.getInstance(graphObject, bl);
    }

    public PushTransmission() {
        this.exportSet = ExportSet.getInstance();
    }

    public ExportSet getExportSet() {
        return this.exportSet;
    }

    public Boolean doRemote(CloudConnection cloudConnection) throws IOException, FrameworkException {
        this.sequenceNumber = 0;
        Set<NodeInterface> set = this.exportSet.getNodes();
        for (NodeInterface object2 : set) {
            if (object2 instanceof File) {
                PushTransmission.sendFile(cloudConnection, (File)object2, 65536);
                continue;
            }
            cloudConnection.send(new NodeDataContainer(object2, this.sequenceNumber++));
        }
        Set<RelationshipInterface> set2 = this.exportSet.getRelationships();
        Iterator iterator = set2.iterator();
        while (iterator.hasNext()) {
            RelationshipInterface relationshipInterface = (RelationshipInterface)iterator.next();
            if (set.contains(relationshipInterface.getSourceNode()) && set.contains(relationshipInterface.getTargetNode())) {
                cloudConnection.send(new RelationshipDataContainer(relationshipInterface, this.sequenceNumber++));
                continue;
            }
            System.out.println("NOT sending relationship data container " + relationshipInterface + " because source or target node are not in the export set.");
        }
        cloudConnection.send(new End());
        cloudConnection.waitForTransmission();
        return true;
    }

    public static void sendFile(CloudConnection cloudConnection, File file, int n) throws FrameworkException, IOException {
        FileNodeDataContainer fileNodeDataContainer = new FileNodeDataContainer(file);
        cloudConnection.send(fileNodeDataContainer);
        for (FileNodeChunk fileNodeChunk : FileNodeDataContainer.getChunks(file, n)) {
            cloudConnection.send(fileNodeChunk);
        }
        cloudConnection.send(new FileNodeEndChunk(fileNodeDataContainer.getSourceNodeId(), fileNodeDataContainer.getFileSize()));
    }
}

