/*
 * Decompiled with CFR 0.152.
 */
package org.apache.directory.api.ldap.codec.api;

import java.util.Set;
import org.apache.directory.api.ldap.codec.api.ConfigurableBinaryAttributeDetector;
import org.apache.directory.api.ldap.codec.api.SchemaBinaryAttributeDetector;
import org.apache.directory.api.util.Strings;
import org.apache.mina.util.ConcurrentHashSet;

public class DefaultConfigurableBinaryAttributeDetector
extends SchemaBinaryAttributeDetector
implements ConfigurableBinaryAttributeDetector {
    private Set<String> binaryAttributes = new ConcurrentHashSet();
    public static final String[] DEFAULT_BINARY_ATTRIBUTES = new String[]{"entryACI", "prescriptiveACI", "subentryACI", "audio", "javaByteCode", "javaClassByteCode", "krb5key", "m-byteCode", "privateKey", "publicKey", "userPKCS12", "userSMIMECertificate", "cACertificate", "userCertificate", "authorityRevocationList", "certificateRevocationList", "deltaRevocationList", "crossCertificatePair", "personalSignature", "photo", "jpegPhoto", "supportedAlgorithms", "javaSerializedData", "userPassword", "objectSid", "objectGUID", "thumbnailLogo", "thumbnailPhoto", "x500uniqueIdentifier"};

    public DefaultConfigurableBinaryAttributeDetector() {
        this.setBinaryAttributes(DEFAULT_BINARY_ATTRIBUTES);
    }

    @Override
    public boolean isBinary(String attributeId) {
        boolean isBinary = super.isBinary(attributeId);
        if (isBinary) {
            return true;
        }
        String attrId = Strings.toLowerCaseAscii((String)attributeId);
        return this.binaryAttributes.contains(attrId);
    }

    @Override
    public void addBinaryAttribute(String ... binaryAttributes) {
        if (binaryAttributes != null) {
            for (String binaryAttribute : binaryAttributes) {
                String attrId = Strings.toLowerCaseAscii((String)binaryAttribute);
                this.binaryAttributes.add(attrId);
            }
        }
    }

    @Override
    public void removeBinaryAttribute(String ... binaryAttributes) {
        if (binaryAttributes != null) {
            for (String binaryAttribute : binaryAttributes) {
                String attrId = Strings.toLowerCaseAscii((String)binaryAttribute);
                this.binaryAttributes.remove(attrId);
            }
        }
    }

    @Override
    public void setBinaryAttributes(String ... binaryAttributes) {
        this.binaryAttributes.clear();
        if (binaryAttributes == null) {
            binaryAttributes = DEFAULT_BINARY_ATTRIBUTES;
        }
        this.addBinaryAttribute(binaryAttributes);
    }
}

