/*
 * Decompiled with CFR 0.152.
 */
package org.structr.payment;

import java.util.Set;
import org.apache.commons.lang.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.structr.api.config.Settings;
import org.structr.api.service.LicenseManager;
import org.structr.core.entity.AbstractSchemaNode;
import org.structr.module.StructrModule;
import org.structr.schema.action.Actions;

public class StructrPaymentsModule
implements StructrModule {
    private static final Logger logger = LoggerFactory.getLogger((String)StructrPaymentsModule.class.getName());

    public void onLoad(LicenseManager licenseManager) {
        logger.info("Checking payment provider configuration..");
        this.checkString("paypal.mode", (String)Settings.getOrCreateStringSetting((String[])new String[]{"paypal", "mode"}).getValue(), "paypal.mode not set, please set to either sandbox or live.");
        this.checkString("paypal.username", (String)Settings.getOrCreateStringSetting((String[])new String[]{"paypal", "username"}).getValue(), "paypal.username not set in structr.conf.");
        this.checkString("paypal.password", (String)Settings.getOrCreateStringSetting((String[])new String[]{"paypal", "password"}).getValue(), "paypal.password not set in structr.conf.");
        this.checkString("paypal.signature", (String)Settings.getOrCreateStringSetting((String[])new String[]{"paypal", "signature"}).getValue(), "paypal.signature not set in structr.conf.");
        this.checkString("paypal.redirect", (String)Settings.getOrCreateStringSetting((String[])new String[]{"paypal", "redirect"}).getValue(), "paypal.redirect not set in structr.conf.");
        this.checkString("stripe.apikey", (String)Settings.getOrCreateStringSetting((String[])new String[]{"stripe", "apikey"}).getValue(), "stripe.apikey not set in structr.conf.");
    }

    public String getName() {
        return "payments";
    }

    public Set<String> getDependencies() {
        return null;
    }

    public Set<String> getFeatures() {
        return null;
    }

    public void insertImportStatements(AbstractSchemaNode abstractSchemaNode, StringBuilder stringBuilder) {
    }

    public void insertSourceCode(AbstractSchemaNode abstractSchemaNode, StringBuilder stringBuilder) {
    }

    public void insertSaveAction(AbstractSchemaNode abstractSchemaNode, StringBuilder stringBuilder, Actions.Type type) {
    }

    public Set<String> getInterfacesForType(AbstractSchemaNode abstractSchemaNode) {
        return null;
    }

    private void checkString(String string, String string2, String string3) {
        if (StringUtils.isEmpty((String)string2)) {
            logger.warn("{}", (Object)string3);
        } else {
            logger.info("{}: {}", new Object[]{string, string2});
        }
    }
}

