/*
 * Decompiled with CFR 0.152.
 */
package org.structr.payment.impl.paypal;

import java.util.ArrayList;
import java.util.Currency;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import org.structr.api.config.Settings;
import urn.ebay.api.PayPalAPI.DoExpressCheckoutPaymentReq;
import urn.ebay.api.PayPalAPI.DoExpressCheckoutPaymentRequestType;
import urn.ebay.api.PayPalAPI.DoExpressCheckoutPaymentResponseType;
import urn.ebay.api.PayPalAPI.GetExpressCheckoutDetailsReq;
import urn.ebay.api.PayPalAPI.GetExpressCheckoutDetailsRequestType;
import urn.ebay.api.PayPalAPI.GetExpressCheckoutDetailsResponseType;
import urn.ebay.api.PayPalAPI.PayPalAPIInterfaceServiceService;
import urn.ebay.api.PayPalAPI.SetExpressCheckoutReq;
import urn.ebay.api.PayPalAPI.SetExpressCheckoutRequestType;
import urn.ebay.api.PayPalAPI.SetExpressCheckoutResponseType;
import urn.ebay.apis.CoreComponentTypes.BasicAmountType;
import urn.ebay.apis.eBLBaseComponents.CurrencyCodeType;
import urn.ebay.apis.eBLBaseComponents.DoExpressCheckoutPaymentRequestDetailsType;
import urn.ebay.apis.eBLBaseComponents.PaymentActionCodeType;
import urn.ebay.apis.eBLBaseComponents.PaymentDetailsType;
import urn.ebay.apis.eBLBaseComponents.SetExpressCheckoutRequestDetailsType;

public class PayPalHelper {
    public static SetExpressCheckoutResponseType getExpressCheckoutToken(List<PaymentDetailsType> list, String string, String string2) throws Throwable {
        SetExpressCheckoutRequestDetailsType setExpressCheckoutRequestDetailsType = new SetExpressCheckoutRequestDetailsType();
        setExpressCheckoutRequestDetailsType.setReturnURL(string);
        setExpressCheckoutRequestDetailsType.setCancelURL(string2);
        setExpressCheckoutRequestDetailsType.setPaymentDetails(list);
        SetExpressCheckoutRequestType setExpressCheckoutRequestType = new SetExpressCheckoutRequestType(setExpressCheckoutRequestDetailsType);
        setExpressCheckoutRequestType.setVersion("104.0");
        SetExpressCheckoutReq setExpressCheckoutReq = new SetExpressCheckoutReq();
        setExpressCheckoutReq.setSetExpressCheckoutRequest(setExpressCheckoutRequestType);
        PayPalAPIInterfaceServiceService payPalAPIInterfaceServiceService = new PayPalAPIInterfaceServiceService(PayPalHelper.getPayPalConfig());
        return payPalAPIInterfaceServiceService.setExpressCheckout(setExpressCheckoutReq);
    }

    public static GetExpressCheckoutDetailsResponseType getExpressCheckoutResponse(String string) throws Throwable {
        GetExpressCheckoutDetailsRequestType getExpressCheckoutDetailsRequestType = new GetExpressCheckoutDetailsRequestType(string);
        getExpressCheckoutDetailsRequestType.setVersion("104.0");
        GetExpressCheckoutDetailsReq getExpressCheckoutDetailsReq = new GetExpressCheckoutDetailsReq();
        getExpressCheckoutDetailsReq.setGetExpressCheckoutDetailsRequest(getExpressCheckoutDetailsRequestType);
        PayPalAPIInterfaceServiceService payPalAPIInterfaceServiceService = new PayPalAPIInterfaceServiceService(PayPalHelper.getPayPalConfig());
        return payPalAPIInterfaceServiceService.getExpressCheckoutDetails(getExpressCheckoutDetailsReq);
    }

    public static DoExpressCheckoutPaymentResponseType commitExpressCheckout(String string, CurrencyCodeType currencyCodeType, int n, String string2, String string3) throws Throwable {
        PaymentDetailsType paymentDetailsType = new PaymentDetailsType();
        paymentDetailsType.setNotifyURL(string);
        paymentDetailsType.setOrderTotal(PayPalHelper.getAmountForCurrency(currencyCodeType.name(), n));
        paymentDetailsType.setPaymentAction(PaymentActionCodeType.SALE);
        ArrayList<PaymentDetailsType> arrayList = new ArrayList<PaymentDetailsType>();
        arrayList.add(paymentDetailsType);
        DoExpressCheckoutPaymentRequestDetailsType doExpressCheckoutPaymentRequestDetailsType = new DoExpressCheckoutPaymentRequestDetailsType();
        doExpressCheckoutPaymentRequestDetailsType.setToken(string2);
        doExpressCheckoutPaymentRequestDetailsType.setPayerID(string3);
        doExpressCheckoutPaymentRequestDetailsType.setPaymentDetails(arrayList);
        DoExpressCheckoutPaymentRequestType doExpressCheckoutPaymentRequestType = new DoExpressCheckoutPaymentRequestType(doExpressCheckoutPaymentRequestDetailsType);
        doExpressCheckoutPaymentRequestType.setVersion("104.0");
        DoExpressCheckoutPaymentReq doExpressCheckoutPaymentReq = new DoExpressCheckoutPaymentReq();
        doExpressCheckoutPaymentReq.setDoExpressCheckoutPaymentRequest(doExpressCheckoutPaymentRequestType);
        PayPalAPIInterfaceServiceService payPalAPIInterfaceServiceService = new PayPalAPIInterfaceServiceService(PayPalHelper.getPayPalConfig());
        return payPalAPIInterfaceServiceService.doExpressCheckoutPayment(doExpressCheckoutPaymentReq);
    }

    public static BasicAmountType getAmountForCurrency(String string, int n) {
        Currency currency = Currency.getInstance(string);
        CurrencyCodeType currencyCodeType = CurrencyCodeType.fromValue((String)currency.getCurrencyCode());
        double d = Math.pow(10.0, currency.getDefaultFractionDigits());
        double d2 = (double)n / d;
        return new BasicAmountType(currencyCodeType, Double.toString(d2));
    }

    private static Map<String, String> getPayPalConfig() {
        LinkedHashMap<String, String> linkedHashMap = new LinkedHashMap<String, String>();
        linkedHashMap.put("mode", (String)Settings.getOrCreateStringSetting((String[])new String[]{"paypal", "mode"}).getValue());
        linkedHashMap.put("acct1.UserName", (String)Settings.getOrCreateStringSetting((String[])new String[]{"paypal", "username"}).getValue());
        linkedHashMap.put("acct1.Password", (String)Settings.getOrCreateStringSetting((String[])new String[]{"paypal", "password"}).getValue());
        linkedHashMap.put("acct1.Signature", (String)Settings.getOrCreateStringSetting((String[])new String[]{"paypal", "signature"}).getValue());
        return linkedHashMap;
    }
}

