/*
 * Decompiled with CFR 0.152.
 */
package org.structr.payment.impl.paypal;

import java.util.LinkedList;
import java.util.List;
import org.structr.payment.api.APIError;
import org.structr.payment.api.APIResponse;
import org.structr.payment.api.CheckoutState;
import org.structr.payment.impl.paypal.PayPalError;
import urn.ebay.apis.eBLBaseComponents.AbstractResponseType;
import urn.ebay.apis.eBLBaseComponents.AckCodeType;
import urn.ebay.apis.eBLBaseComponents.ErrorType;

public abstract class PayPalResponse
implements APIResponse {
    private final List<APIError> errors = new LinkedList<APIError>();
    private CheckoutState checkoutState = null;

    public PayPalResponse(AbstractResponseType abstractResponseType) {
        this.checkoutState = this.getCheckoutState(abstractResponseType.getAck());
        for (ErrorType errorType : abstractResponseType.getErrors()) {
            this.errors.add(new PayPalError(errorType.getErrorCode(), errorType.getShortMessage(), errorType.getLongMessage()));
        }
    }

    @Override
    public final CheckoutState getCheckoutState() {
        return this.checkoutState;
    }

    @Override
    public final List<APIError> getErrors() {
        return this.errors;
    }

    private CheckoutState getCheckoutState(AckCodeType ackCodeType) {
        switch (ackCodeType) {
            case CUSTOMCODE: {
                return CheckoutState.Custom;
            }
            case FAILURE: {
                return CheckoutState.Failure;
            }
            case FAILUREWITHWARNING: {
                return CheckoutState.FailureWithWarning;
            }
            case PARTIALSUCCESS: {
                return CheckoutState.PartialSuccess;
            }
            case SUCCESS: {
                return CheckoutState.Success;
            }
            case SUCCESSWITHWARNING: {
                return CheckoutState.SuccessWithWarning;
            }
            case WARNING: {
                return CheckoutState.Warning;
            }
        }
        return null;
    }
}

