/*
 * Decompiled with CFR 0.152.
 */
package org.structr.payment.impl.stripe;

import com.stripe.Stripe;
import com.stripe.exception.APIConnectionException;
import com.stripe.exception.APIException;
import com.stripe.exception.AuthenticationException;
import com.stripe.exception.CardException;
import com.stripe.exception.InvalidRequestException;
import com.stripe.model.Charge;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.structr.api.config.Settings;
import org.structr.common.error.FrameworkException;
import org.structr.payment.api.APIError;
import org.structr.payment.api.BeginCheckoutResponse;
import org.structr.payment.api.CheckoutState;
import org.structr.payment.api.ConfirmCheckoutResponse;
import org.structr.payment.api.Payment;
import org.structr.payment.api.PaymentProvider;
import org.structr.payment.api.PaymentState;

public class StripePaymentProvider
implements PaymentProvider {
    private static final Logger logger = LoggerFactory.getLogger((String)StripePaymentProvider.class.getName());

    @Override
    public BeginCheckoutResponse beginCheckout(Payment payment, String string, String string2) throws FrameworkException {
        throw new FrameworkException(422, "Begin checkout not supported by this payment provider. Please use the confirmCheckout endpoint.");
    }

    @Override
    public ConfirmCheckoutResponse confirmCheckout(Payment payment, String string, String string2, String string3) throws FrameworkException {
        Stripe.apiKey = (String)Settings.getOrCreateStringSetting((String[])new String[]{"stripe", "apikey"}).getValue();
        try {
            HashMap<String, Object> hashMap = new HashMap<String, Object>();
            hashMap.put("amount", payment.getTotal());
            hashMap.put("currency", payment.getCurrencyCode());
            hashMap.put("source", string2);
            hashMap.put("description", payment.getDescription());
            Charge.create(hashMap);
            payment.setPaymentState(PaymentState.completed);
            return new ConfirmResponse(CheckoutState.Success);
        }
        catch (APIException aPIException) {
            payment.setPaymentState(PaymentState.error);
            return new ConfirmResponse(CheckoutState.Failure, "1", "APIException", aPIException.getMessage());
        }
        catch (APIConnectionException aPIConnectionException) {
            payment.setPaymentState(PaymentState.error);
            return new ConfirmResponse(CheckoutState.Failure, "1", "APIConnectionException", aPIConnectionException.getMessage());
        }
        catch (InvalidRequestException invalidRequestException) {
            payment.setPaymentState(PaymentState.error);
            return new ConfirmResponse(CheckoutState.Failure, "1", "InvalidRequestException", invalidRequestException.getMessage());
        }
        catch (AuthenticationException authenticationException) {
            payment.setPaymentState(PaymentState.error);
            return new ConfirmResponse(CheckoutState.Failure, "1", "AuthenticationException", authenticationException.getMessage());
        }
        catch (CardException cardException) {
            payment.setPaymentState(PaymentState.error);
            return new ConfirmResponse(CheckoutState.Failure, cardException.getCode(), cardException.getCharge(), cardException.getMessage());
        }
    }

    @Override
    public void cancelCheckout(Payment payment) throws FrameworkException {
        try {
            payment.setToken(null);
            payment.setPaymentState(PaymentState.cancelled);
        }
        catch (FrameworkException frameworkException) {
            logger.warn("", (Throwable)frameworkException);
        }
    }

    private static class APIErrorImpl
    implements APIError {
        private String errorCode = null;
        private String shortMessage = null;
        private String longMessage = null;

        public APIErrorImpl(String string, String string2, String string3) {
            this.errorCode = string;
            this.shortMessage = string2;
            this.longMessage = string3;
        }

        @Override
        public String getShortMessage() {
            return this.shortMessage;
        }

        @Override
        public String getLongMessage() {
            return this.longMessage;
        }

        @Override
        public String getErrorCode() {
            return this.errorCode;
        }
    }

    private static class ConfirmResponse
    implements ConfirmCheckoutResponse {
        private final List<APIError> errors = new LinkedList<APIError>();
        private CheckoutState state = null;

        public ConfirmResponse(CheckoutState checkoutState) {
            this(checkoutState, null, null, null);
        }

        public ConfirmResponse(CheckoutState checkoutState, String string, String string2, String string3) {
            this.state = checkoutState;
            if (string != null && string2 != null && string3 != null) {
                this.errors.add(new APIErrorImpl(string, string2, string3));
            }
        }

        @Override
        public CheckoutState getCheckoutState() {
            return this.state;
        }

        @Override
        public List<APIError> getErrors() {
            return this.errors;
        }
    }
}

