/*
 * Decompiled with CFR 0.152.
 */
package org.renjin.gcc.runtime;

import java.util.Arrays;
import org.renjin.gcc.runtime.LongPtr;
import org.renjin.gcc.runtime.MallocThunk;
import org.renjin.gcc.runtime.Ptr;
import org.renjin.gcc.runtime.Realloc;

public class DoublePtr
implements Ptr {
    public static final DoublePtr NULL = new DoublePtr();
    public static final int BYTES = 8;
    public final double[] array;
    public final int offset;

    private DoublePtr() {
        this.array = null;
        this.offset = 0;
    }

    public DoublePtr(double[] array, int offset) {
        this.array = array;
        this.offset = offset;
    }

    public DoublePtr(double ... values) {
        this.array = values;
        this.offset = 0;
    }

    public double[] getArray() {
        return this.array;
    }

    @Override
    public int getOffset() {
        return this.offset;
    }

    @Override
    public DoublePtr realloc(int newSizeInBytes) {
        return new DoublePtr(Realloc.realloc(this.array, this.offset, newSizeInBytes / 8));
    }

    @Override
    public Ptr pointerPlus(int bytes) {
        return new DoublePtr(this.array, this.offset + bytes / 8);
    }

    public String toString() {
        return this.offset + "+" + Arrays.toString(this.array);
    }

    public double unwrap() {
        return this.array[this.offset];
    }

    public double get() {
        return this.array[this.offset];
    }

    public double get(int i) {
        return this.array[this.offset + i];
    }

    public void set(double x) {
        this.array[this.offset] = x;
    }

    public void set(int index, double value) {
        this.array[this.offset + index] = value;
    }

    public static int memcmp(DoublePtr x, DoublePtr y, int numBytes) {
        return DoublePtr.memcmp(x.array, x.offset, y.array, y.offset, numBytes);
    }

    public static int memcmp(double[] x, int xi, double[] y, int yi, int n) {
        while (n > 0) {
            long yb;
            long xb = Double.doubleToRawLongBits(xi);
            if (xb != (yb = Double.doubleToRawLongBits(yi)) || n < 8) {
                LongPtr.memcmp(xb, yb, n);
            }
            ++xi;
            ++yi;
            n -= 8;
        }
        return 0;
    }

    public static void memset(double[] str, int strOffset, int c, int n) {
        assert (n % 8 == 0);
        double doubleValue = DoublePtr.memset(c);
        Arrays.fill(str, strOffset, strOffset + n / 8, doubleValue);
    }

    public static double memset(int c) {
        return Double.longBitsToDouble(LongPtr.memset(c));
    }

    public static DoublePtr cast(Object voidPointer) {
        if (voidPointer instanceof MallocThunk) {
            return ((MallocThunk)voidPointer).doublePtr();
        }
        if (voidPointer == null) {
            return NULL;
        }
        return (DoublePtr)voidPointer;
    }
}

