/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sis.referencing.operation.transform;

import java.io.Serializable;
import java.util.Arrays;
import java.util.IdentityHashMap;
import java.util.List;
import org.apache.sis.internal.jdk7.Objects;
import org.apache.sis.internal.referencing.ExtendedPrecisionMatrix;
import org.apache.sis.internal.referencing.WKTUtilities;
import org.apache.sis.internal.util.DoubleDouble;
import org.apache.sis.internal.util.UnmodifiableArrayList;
import org.apache.sis.io.wkt.FormattableObject;
import org.apache.sis.io.wkt.Formatter;
import org.apache.sis.parameter.DefaultParameterValue;
import org.apache.sis.parameter.Parameterized;
import org.apache.sis.parameter.Parameters;
import org.apache.sis.referencing.operation.matrix.Matrices;
import org.apache.sis.referencing.operation.matrix.MatrixSIS;
import org.apache.sis.referencing.operation.matrix.NoninvertibleMatrixException;
import org.apache.sis.referencing.operation.transform.ConcatenatedTransform;
import org.apache.sis.referencing.operation.transform.LinearTransform;
import org.apache.sis.referencing.operation.transform.MathTransforms;
import org.apache.sis.util.ArgumentChecks;
import org.apache.sis.util.logging.Logging;
import org.apache.sis.util.resources.Errors;
import org.opengis.parameter.GeneralParameterDescriptor;
import org.opengis.parameter.GeneralParameterValue;
import org.opengis.parameter.ParameterDescriptor;
import org.opengis.parameter.ParameterDescriptorGroup;
import org.opengis.parameter.ParameterNotFoundException;
import org.opengis.parameter.ParameterValue;
import org.opengis.parameter.ParameterValueGroup;
import org.opengis.referencing.operation.MathTransform;
import org.opengis.referencing.operation.MathTransformFactory;
import org.opengis.referencing.operation.Matrix;
import org.opengis.referencing.operation.OperationMethod;
import org.opengis.util.FactoryException;

public class ContextualParameters
extends Parameters
implements Serializable {
    private static final long serialVersionUID = 4899134192407586472L;
    private final ParameterDescriptorGroup descriptor;
    private Matrix normalize;
    private Matrix denormalize;
    private ParameterValue<?>[] values;
    private boolean isFrozen;

    public ContextualParameters(OperationMethod operationMethod) {
        ArgumentChecks.ensureNonNull("method", operationMethod);
        this.descriptor = operationMethod.getParameters();
        this.normalize = ContextualParameters.linear("sourceDimensions", operationMethod.getSourceDimensions());
        this.denormalize = ContextualParameters.linear("targetDimensions", operationMethod.getTargetDimensions());
        this.values = new ParameterValue[this.descriptor.descriptors().size()];
    }

    private static MatrixSIS linear(String string, Integer n) {
        if (n == null) {
            throw new IllegalArgumentException(Errors.format((short)64, string));
        }
        int n2 = n + 1;
        return Matrices.create(n2, n2, ExtendedPrecisionMatrix.IDENTITY);
    }

    @Override
    public final ParameterDescriptorGroup getDescriptor() {
        return this.descriptor;
    }

    private void ensureModifiable() throws IllegalStateException {
        if (this.isFrozen) {
            throw new IllegalStateException(Errors.format((short)123, this.getClass()));
        }
    }

    public final MatrixSIS getMatrix(boolean bl) {
        Matrix matrix;
        Matrix matrix2 = matrix = bl ? this.normalize : this.denormalize;
        if (!this.isFrozen) {
            return (MatrixSIS)matrix;
        }
        return Matrices.unmodifiable(matrix);
    }

    public MatrixSIS normalizeGeographicInputs(double d) {
        this.ensureModifiable();
        DoubleDouble doubleDouble = DoubleDouble.createDegreesToRadians();
        DoubleDouble doubleDouble2 = null;
        if (d != 0.0) {
            doubleDouble2 = new DoubleDouble(-d);
            doubleDouble2.multiply(doubleDouble);
        }
        MatrixSIS matrixSIS = (MatrixSIS)this.normalize;
        matrixSIS.convertBefore(0, doubleDouble, doubleDouble2);
        matrixSIS.convertBefore(1, doubleDouble, null);
        return matrixSIS;
    }

    public MatrixSIS denormalizeGeographicOutputs(double d) {
        this.ensureModifiable();
        DoubleDouble doubleDouble = DoubleDouble.createRadiansToDegrees();
        MatrixSIS matrixSIS = (MatrixSIS)this.denormalize;
        matrixSIS.convertAfter(0, doubleDouble, d != 0.0 ? Double.valueOf(d) : null);
        matrixSIS.convertAfter(1, doubleDouble, null);
        return matrixSIS;
    }

    public MathTransform completeTransform(MathTransformFactory mathTransformFactory, MathTransform mathTransform) throws FactoryException {
        Object object;
        Object object2;
        if (!this.isFrozen) {
            this.isFrozen = true;
            object2 = new IdentityHashMap(this.values.length);
            for (ParameterValue<?> parameterValue : this.values) {
                if (parameterValue == null) break;
                ParameterDescriptor<?> parameterDescriptor = (parameterValue = DefaultParameterValue.unmodifiable(parameterValue)).getDescriptor();
                if (object2.put(parameterDescriptor, parameterValue) == null) continue;
                throw new IllegalStateException(Errors.format((short)19, parameterDescriptor.getName()));
            }
            this.values = new ParameterValue[object2.size()];
            assert (this.descriptor.descriptors().containsAll(object2.keySet()));
            object = this.descriptor.descriptors().iterator();
            int n = 0;
            while (n < this.values.length) {
                ParameterValue parameterValue = (ParameterValue)object2.get(object.next());
                if (parameterValue == null) continue;
                this.values[n++] = parameterValue;
            }
        }
        object2 = mathTransformFactory.createAffineTransform(this.normalize);
        object = mathTransformFactory.createAffineTransform(this.denormalize);
        Matrix matrix = MathTransforms.getMatrix((MathTransform)object2);
        if (matrix != null) {
            this.normalize = matrix;
        }
        if ((matrix = MathTransforms.getMatrix(object)) != null) {
            this.denormalize = matrix;
        }
        return mathTransformFactory.createConcatenatedTransform(mathTransformFactory.createConcatenatedTransform((MathTransform)object2, mathTransform), (MathTransform)object);
    }

    @Override
    public ParameterValue<?> parameter(String string) throws ParameterNotFoundException {
        GeneralParameterDescriptor generalParameterDescriptor = this.descriptor.descriptor(string);
        if (!(generalParameterDescriptor instanceof ParameterDescriptor)) {
            throw this.parameterNotFound(string);
        }
        for (int i = 0; i < this.values.length; ++i) {
            ParameterValue<Object> parameterValue = this.values[i];
            if (parameterValue == null) {
                parameterValue = ((ParameterDescriptor)generalParameterDescriptor).createValue();
                this.values[i] = parameterValue;
            } else if (parameterValue.getDescriptor() != generalParameterDescriptor) continue;
            return parameterValue;
        }
        if (this.isFrozen) {
            return ((ParameterDescriptor)generalParameterDescriptor).createValue();
        }
        throw new IllegalStateException(Errors.format((short)108, this.descriptor.getName()));
    }

    @Override
    public List<GeneralParameterValue> values() {
        int n;
        for (n = this.values.length; n != 0 && this.values[n - 1] == null; --n) {
        }
        return UnmodifiableArrayList.wrap(this.values, 0, n);
    }

    @Override
    public List<ParameterValueGroup> groups(String string) {
        throw this.parameterNotFound(string);
    }

    @Override
    public ParameterValueGroup addGroup(String string) {
        throw this.parameterNotFound(string);
    }

    private ParameterNotFoundException parameterNotFound(String string) {
        return new ParameterNotFoundException(Errors.format((short)147, this.descriptor.getName(), string), string);
    }

    @Override
    public ContextualParameters clone() {
        ParameterValue<?> parameterValue;
        ParameterValue<?>[] parameterValueArray = Arrays.copyOf(this.values, this.descriptor.descriptors().size());
        for (int i = 0; i < parameterValueArray.length && (parameterValue = parameterValueArray[i]) != null; ++i) {
            parameterValueArray[i] = parameterValueArray[i].clone();
        }
        ContextualParameters contextualParameters = (ContextualParameters)super.clone();
        contextualParameters.values = parameterValueArray;
        contextualParameters.normalize = this.normalize.clone();
        contextualParameters.denormalize = this.denormalize.clone();
        return contextualParameters;
    }

    public int hashCode() {
        return this.normalize.hashCode() + 31 * this.denormalize.hashCode() ^ Arrays.hashCode(this.values) ^ 0x5D6CA6A8;
    }

    public boolean equals(Object object) {
        if (object != null && object.getClass() == this.getClass()) {
            ContextualParameters contextualParameters = (ContextualParameters)object;
            return Objects.equals(this.descriptor, contextualParameters.descriptor) && Objects.equals(this.normalize, contextualParameters.normalize) && Objects.equals(this.denormalize, contextualParameters.denormalize) && Arrays.equals(this.values, contextualParameters.values);
        }
        return false;
    }

    final int beforeFormat(List<Object> list, int n, boolean bl) {
        Object object;
        Matrix matrix;
        Object object2;
        Matrix matrix2 = null;
        Matrix matrix3 = null;
        if (n != 0 && (object2 = list.get(n - 1)) instanceof MathTransform) {
            matrix2 = MathTransforms.getMatrix((MathTransform)object2);
        }
        if (n + 1 < list.size() && (object2 = list.get(n + 1)) instanceof MathTransform) {
            matrix3 = MathTransforms.getMatrix((MathTransform)object2);
        }
        boolean bl2 = matrix2 != null;
        boolean bl3 = matrix3 != null;
        Matrix matrix4 = matrix = bl ? this.denormalize : this.normalize;
        if (!bl) {
            try {
                matrix = Matrices.inverse(matrix);
            }
            catch (NoninvertibleMatrixException noninvertibleMatrixException) {
                ContextualParameters.unexpectedException(noninvertibleMatrixException);
                return n;
            }
        }
        if (bl2) {
            matrix = Matrices.multiply(matrix, matrix2);
        }
        matrix2 = Matrices.isIdentity(matrix, 8.999280057595393E-8) ? null : matrix;
        Matrix matrix5 = matrix = bl ? this.normalize : this.denormalize;
        if (!bl) {
            try {
                matrix = Matrices.inverse(matrix);
            }
            catch (NoninvertibleMatrixException noninvertibleMatrixException) {
                ContextualParameters.unexpectedException(noninvertibleMatrixException);
                return n;
            }
        }
        if (bl3) {
            matrix = Matrices.multiply(matrix3, matrix);
        }
        Matrix matrix6 = matrix3 = Matrices.isIdentity(matrix, 8.999280057595393E-8) ? null : matrix;
        if (matrix2 == null) {
            if (bl2) {
                object = list.remove(--n);
                assert (object instanceof LinearTransform);
            }
        } else if (bl2) {
            object = list.set(n - 1, matrix2);
            assert (object instanceof LinearTransform);
        } else {
            list.add(n++, matrix2);
        }
        list.set(n, new WKT(bl));
        if (matrix3 == null) {
            if (bl3) {
                object = list.remove(n + 1);
                assert (object instanceof LinearTransform);
            }
        } else {
            ++n;
            if (bl3) {
                object = list.set(n, matrix3);
                assert (object instanceof LinearTransform);
            } else {
                list.add(n, matrix3);
            }
        }
        return n;
    }

    private static void unexpectedException(NoninvertibleMatrixException noninvertibleMatrixException) {
        Logging.unexpectedException(Logging.getLogger("org.apache.sis.io.wkt"), ConcatenatedTransform.class, "formatTo", noninvertibleMatrixException);
    }

    private final class WKT
    extends FormattableObject
    implements Parameterized {
        private final boolean inverse;

        WKT(boolean bl) {
            this.inverse = bl;
        }

        @Override
        public ParameterDescriptorGroup getParameterDescriptors() {
            return ContextualParameters.this.getDescriptor();
        }

        @Override
        public ParameterValueGroup getParameterValues() {
            return ContextualParameters.this;
        }

        @Override
        protected String formatTo(Formatter formatter) {
            if (this.inverse) {
                formatter.append(new WKT(false));
                return "Inverse_MT";
            }
            WKTUtilities.appendParamMT(ContextualParameters.this, formatter);
            return "Param_MT";
        }
    }
}

