/*
 * Decompiled with CFR 0.152.
 */
package com.jayway.restassured.internal.http;

import com.jayway.restassured.config.DecoderConfig;
import com.jayway.restassured.internal.http.ContentEncoding;
import com.jayway.restassured.internal.http.DeflateEncoding;
import com.jayway.restassured.internal.http.GZIPEncoding;
import java.util.HashMap;
import java.util.Map;
import org.apache.http.impl.client.AbstractHttpClient;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ContentEncodingRegistry {
    private final boolean useNoWrapForInflateDecoding;
    protected Map<String, ContentEncoding> availableEncoders;

    public ContentEncodingRegistry(DecoderConfig decoderConfig) {
        this.useNoWrapForInflateDecoding = (decoderConfig == null ? DecoderConfig.decoderConfig() : decoderConfig).shouldUseNoWrapForInflateDecoding();
        this.availableEncoders = this.getDefaultEncoders();
    }

    protected Map<String, ContentEncoding> getDefaultEncoders() {
        HashMap<String, ContentEncoding> map = new HashMap<String, ContentEncoding>();
        map.put(ContentEncoding.Type.GZIP.toString(), new GZIPEncoding());
        map.put(ContentEncoding.Type.DEFLATE.toString(), new DeflateEncoding(this.useNoWrapForInflateDecoding));
        return map;
    }

    void setInterceptors(AbstractHttpClient client, Object ... encodings) {
        client.removeRequestInterceptorByClass(ContentEncoding.RequestInterceptor.class);
        client.removeResponseInterceptorByClass(ContentEncoding.ResponseInterceptor.class);
        for (Object encName : encodings) {
            ContentEncoding enc = this.availableEncoders.get(encName.toString());
            if (enc == null) continue;
            client.addRequestInterceptor(enc.getRequestInterceptor());
            client.addResponseInterceptor(enc.getResponseInterceptor());
        }
    }
}

