/*
 * Decompiled with CFR 0.152.
 */
package org.structr.odf.entity;

import java.io.File;
import java.io.OutputStream;
import java.net.URI;
import org.odftoolkit.odfdom.doc.OdfDocument;
import org.odftoolkit.odfdom.pkg.OdfPackage;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.structr.common.SecurityContext;
import org.structr.common.View;
import org.structr.common.error.FrameworkException;
import org.structr.core.Export;
import org.structr.core.GraphObject;
import org.structr.core.app.App;
import org.structr.core.app.StructrApp;
import org.structr.core.entity.AbstractNode;
import org.structr.core.property.EndNode;
import org.structr.core.property.Property;
import org.structr.core.property.PropertyKey;
import org.structr.core.property.StringProperty;
import org.structr.odf.entity.ODTExporter;
import org.structr.odf.relations.DocumentResult;
import org.structr.odf.relations.DocumentTemplate;
import org.structr.odf.relations.TransformationRules;
import org.structr.transform.VirtualType;
import org.structr.web.common.FileHelper;
import org.structr.web.entity.FileBase;
import org.structr.web.entity.Image;
import org.w3c.dom.NamedNodeMap;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

public abstract class ODFExporter
extends AbstractNode {
    private final String ODF_IMAGE_PARENT_NAME = "draw:frame";
    private final String ODF_IMAGE_ATTRIBUTE_PARENT_IMAGE_NAME = "draw:name";
    private final String ODF_IMAGE_ATTRIBUTE_FILE_PATH = "xlink:href";
    private final String ODF_IMAGE_DIRECTORY = "Pictures/";
    protected static final Logger logger = LoggerFactory.getLogger((String)ODTExporter.class.getName());
    public static final Property<VirtualType> transformationProvider = new EndNode("transformationProvider", TransformationRules.class);
    public static final Property<FileBase> documentTemplate = new EndNode("documentTemplate", DocumentTemplate.class);
    public static final Property<FileBase> resultDocument = new EndNode("resultDocument", DocumentResult.class);
    public static final View defaultView = new View(ODTExporter.class, "public", new Property[]{id, type, transformationProvider, documentTemplate, resultDocument});
    public static final View uiView = new View(ODTExporter.class, "ui", new Property[]{id, name, owner, type, createdBy, deleted, hidden, createdDate, lastModifiedDate, visibleToPublicUsers, visibleToAuthenticatedUsers, visibilityStartDate, visibilityEndDate, transformationProvider, documentTemplate, resultDocument});

    @Export
    public void createDocumentFromTemplate() throws FrameworkException {
        FileBase fileBase = (FileBase)this.getProperty((PropertyKey)documentTemplate);
        FileBase fileBase2 = (FileBase)this.getProperty((PropertyKey)resultDocument);
        try {
            if (fileBase2 == null) {
                fileBase2 = FileHelper.createFile((SecurityContext)this.securityContext, (byte[])new byte[0], (String)fileBase.getContentType(), FileBase.class, (String)this.getName().concat("_").concat(fileBase.getName()));
                fileBase2.setProperty((PropertyKey)FileBase.parent, fileBase.getProperty((PropertyKey)FileBase.parent));
                fileBase2.unlockSystemPropertiesOnce();
                fileBase2.setProperty((PropertyKey)AbstractNode.type, (Object)File.class.getSimpleName());
                this.setProperty((PropertyKey)resultDocument, fileBase2);
            }
            OdfDocument odfDocument = OdfDocument.loadDocument((String)fileBase.getFileOnDisk().getAbsolutePath());
            odfDocument.save((OutputStream)fileBase2.getOutputStream());
            odfDocument.close();
        }
        catch (Exception exception) {
            logger.error("Error while creating ODS from template", (Throwable)exception);
        }
    }

    @Export
    public void exportImage(String string) {
        FileBase fileBase = (FileBase)this.getProperty((PropertyKey)resultDocument);
        try {
            App app = StructrApp.getInstance();
            Image image = (Image)app.nodeQuery(Image.class).and((PropertyKey)GraphObject.id, (Object)string).getFirst();
            String string2 = (String)image.getProperty((PropertyKey)new StringProperty("name"));
            String string3 = (String)image.getProperty((PropertyKey)new StringProperty("contentType"));
            String string4 = null;
            OdfDocument odfDocument = OdfDocument.loadDocument((String)fileBase.getFileOnDisk().getAbsolutePath());
            NodeList nodeList = odfDocument.getContentRoot().getElementsByTagName("draw:frame");
            for (int i = 0; i < nodeList.getLength(); ++i) {
                Node node = nodeList.item(i);
                NamedNodeMap namedNodeMap = node.getAttributes();
                Node node2 = namedNodeMap.getNamedItem("draw:name");
                if (node2 == null || !node2.getTextContent().equals(string2)) continue;
                NamedNodeMap namedNodeMap2 = node.getFirstChild().getAttributes();
                Node node3 = namedNodeMap2.getNamedItem("xlink:href");
                string4 = node3.getTextContent();
                node3.setTextContent("Pictures/" + string2);
            }
            OdfPackage odfPackage = odfDocument.getPackage();
            if (string4 != null && string4.length() > 0) {
                odfPackage.remove(string4);
            }
            odfPackage.insert(new URI(image.getFileOnDisk().getAbsolutePath()), "Pictures/" + string2, string3);
            odfPackage.save(fileBase.getFileOnDisk().getAbsolutePath());
            odfPackage.close();
            odfDocument.close();
        }
        catch (Exception exception) {
            logger.error("Error while exporting image to document", (Throwable)exception);
        }
    }
}

