/*
 * Decompiled with CFR 0.152.
 */
package org.renjin.repackaged.guava.base;

import java.lang.ref.WeakReference;
import org.renjin.repackaged.guava.annotations.GwtCompatible;
import org.renjin.repackaged.guava.base.CharMatcher;
import org.renjin.repackaged.guava.base.Enums;
import org.renjin.repackaged.guava.base.Optional;

@GwtCompatible(emulated=true)
final class Platform {
    private Platform() {
    }

    static long systemNanoTime() {
        return System.nanoTime();
    }

    static CharMatcher precomputeCharMatcher(CharMatcher matcher) {
        return matcher.precomputedInternal();
    }

    static <T extends Enum<T>> Optional<T> getEnumIfPresent(Class<T> enumClass, String value) {
        WeakReference<Enum<?>> ref = Enums.getEnumConstants(enumClass).get(value);
        return ref == null ? Optional.absent() : Optional.of(enumClass.cast(ref.get()));
    }
}

