/*
 * Decompiled with CFR 0.152.
 */
package org.odftoolkit.simple.common.navigation;

import org.odftoolkit.odfdom.dom.OdfDocumentNamespace;
import org.odftoolkit.odfdom.dom.element.OdfStyleBase;
import org.odftoolkit.odfdom.dom.element.text.TextSElement;
import org.odftoolkit.odfdom.incubator.doc.text.OdfTextSpan;
import org.odftoolkit.odfdom.pkg.OdfElement;
import org.odftoolkit.odfdom.pkg.OdfFileDom;
import org.odftoolkit.simple.Component;
import org.odftoolkit.simple.common.TextExtractor;
import org.odftoolkit.simple.common.field.ConditionField;
import org.odftoolkit.simple.common.field.Field;
import org.odftoolkit.simple.common.field.Fields;
import org.odftoolkit.simple.common.field.ReferenceField;
import org.odftoolkit.simple.common.field.VariableField;
import org.odftoolkit.simple.common.navigation.InvalidNavigationException;
import org.odftoolkit.simple.common.navigation.Selection;
import org.odftoolkit.simple.common.navigation.TextSelection;
import org.w3c.dom.Element;
import org.w3c.dom.Node;

public class FieldSelection
extends Selection {
    private TextSelection textSelection;
    private boolean mIsInserted;
    private OdfTextSpan spanContainer;

    public Field replaceWithSimpleField(Field.FieldType fieldType) {
        int leftLength = this.textSelection.getText().length();
        int index = this.textSelection.getIndex();
        this.prepareSpanContainer(leftLength, index);
        Field field = null;
        switch (fieldType) {
            case DATE_FIELD: {
                field = Fields.createDateField((OdfElement)this.spanContainer);
                break;
            }
            case FIXED_DATE_FIELD: {
                field = Fields.createFixedDateField((OdfElement)this.spanContainer);
                break;
            }
            case TIME_FIELD: {
                field = Fields.createTimeField((OdfElement)this.spanContainer);
                break;
            }
            case FIXED_TIME_FIELD: {
                field = Fields.createFixedTimeField((OdfElement)this.spanContainer);
                break;
            }
            case PREVIOUS_PAGE_NUMBER_FIELD: {
                field = Fields.createPreviousPageNumberField((OdfElement)this.spanContainer);
                break;
            }
            case CURRENT_PAGE_NUMBER_FIELD: {
                field = Fields.createCurrentPageNumberField((OdfElement)this.spanContainer);
                break;
            }
            case NEXT_PAGE_NUMBER_FIELD: {
                field = Fields.createNextPageNumberField((OdfElement)this.spanContainer);
                break;
            }
            case PAGE_COUNT_FIELD: {
                field = Fields.createPageCountField((OdfElement)this.spanContainer);
                break;
            }
            case TITLE_FIELD: {
                field = Fields.createTitleField((OdfElement)this.spanContainer);
                break;
            }
            case SUBJECT_FIELD: {
                field = Fields.createSubjectField((OdfElement)this.spanContainer);
                break;
            }
            case AUTHOR_NAME_FIELD: {
                field = Fields.createAuthorNameField((OdfElement)this.spanContainer);
                break;
            }
            case AUTHOR_INITIALS_FIELD: {
                field = Fields.createAuthorInitialsField((OdfElement)this.spanContainer);
                break;
            }
            case CHAPTER_FIELD: {
                field = Fields.createChapterField((OdfElement)this.spanContainer);
                break;
            }
            case REFERENCE_FIELD: 
            case SIMPLE_VARIABLE_FIELD: 
            case USER_VARIABLE_FIELD: 
            case CONDITION_FIELD: 
            case HIDDEN_TEXT_FIELD: {
                throw new IllegalArgumentException("this is not a vaild simple field type.");
            }
        }
        this.textSelection.mMatchedText = ((Component)field).getOdfElement().getTextContent();
        int textLength = this.textSelection.mMatchedText.length();
        int offset = textLength - leftLength;
        Selection.SelectionManager.refresh(this.textSelection.getContainerElement(), offset, index + textLength);
        return field;
    }

    public void replaceWithReferenceField(ReferenceField field, ReferenceField.DisplayType type) {
        int leftLength = this.textSelection.getText().length();
        int index = this.textSelection.getIndex();
        this.prepareSpanContainer(leftLength, index);
        field.appendReferenceTo((OdfElement)this.spanContainer, type);
        this.textSelection.mMatchedText = field.getOdfElement().getTextContent();
        int textLength = this.textSelection.mMatchedText.length();
        int offset = textLength - leftLength;
        Selection.SelectionManager.refresh(this.textSelection.getContainerElement(), offset, index + textLength);
    }

    public void replaceWithVariableField(VariableField field) {
        int leftLength = this.textSelection.getText().length();
        int index = this.textSelection.getIndex();
        this.prepareSpanContainer(leftLength, index);
        field.displayField((OdfElement)this.spanContainer);
        this.textSelection.mMatchedText = field.getOdfElement().getTextContent();
        int textLength = this.textSelection.mMatchedText.length();
        int offset = textLength - leftLength;
        Selection.SelectionManager.refresh(this.textSelection.getContainerElement(), offset, index + textLength);
    }

    public ConditionField replaceWithConditionField(String condition, String trueText, String falseText) {
        int leftLength = this.textSelection.getText().length();
        int index = this.textSelection.getIndex();
        this.prepareSpanContainer(leftLength, index);
        this.textSelection.mMatchedText = "";
        int offset = -leftLength;
        Selection.SelectionManager.refresh(this.textSelection.getContainerElement(), offset, index);
        return Fields.createConditionField((OdfElement)this.spanContainer, condition, trueText, falseText);
    }

    public ConditionField replaceWithHiddenTextField(String condition, String text) {
        int leftLength = this.textSelection.getText().length();
        int index = this.textSelection.getIndex();
        this.prepareSpanContainer(leftLength, index);
        this.textSelection.mMatchedText = "";
        int offset = -leftLength;
        Selection.SelectionManager.refresh(this.textSelection.getContainerElement(), offset, index);
        return Fields.createHiddenTextField((OdfElement)this.spanContainer, condition, text);
    }

    public void applyStyle(OdfStyleBase style) throws InvalidNavigationException {
        if (this.spanContainer == null) {
            this.textSelection.applyStyle(style);
        } else {
            this.spanContainer.setProperties(style.getStyleProperties());
        }
    }

    public FieldSelection(TextSelection selection) {
        this.textSelection = selection;
        this.spanContainer = null;
    }

    @Override
    public void cut() throws InvalidNavigationException {
        this.textSelection.cut();
    }

    public void replaceWith(String newText) throws InvalidNavigationException {
        this.textSelection.replaceWith(newText);
    }

    @Override
    public void pasteAtEndOf(Selection positionItem) throws InvalidNavigationException {
        this.textSelection.pasteAtEndOf(positionItem);
    }

    @Override
    public void pasteAtFrontOf(Selection positionItem) throws InvalidNavigationException {
        this.textSelection.pasteAtFrontOf(positionItem);
    }

    @Override
    protected void refresh(int offset) {
        this.textSelection.refresh(offset);
    }

    @Override
    protected void refreshAfterFrontalDelete(Selection deletedItem) {
        this.textSelection.refreshAfterFrontalDelete(deletedItem);
    }

    @Override
    protected void refreshAfterFrontalInsert(Selection insertedItem) {
        this.textSelection.refreshAfterFrontalInsert(insertedItem);
    }

    private void prepareSpanContainer(int leftLength, int index) {
        if (this.spanContainer == null) {
            OdfElement parentElement = this.textSelection.getContainerElement();
            this.delete(index, leftLength, (Node)parentElement);
            this.spanContainer = new OdfTextSpan((OdfFileDom)parentElement.getOwnerDocument());
            this.mIsInserted = false;
            this.insertSpan(this.spanContainer, index, (Node)parentElement);
        } else {
            Node childNode = this.spanContainer.getFirstChild();
            while (childNode != null) {
                this.spanContainer.removeChild(childNode);
                childNode = this.spanContainer.getFirstChild();
            }
        }
    }

    private void delete(int fromIndex, int leftLength, Node pNode) {
        if (fromIndex == 0 && leftLength == 0) {
            return;
        }
        int nodeLength = 0;
        for (Node node = pNode.getFirstChild(); node != null; node = node.getNextSibling()) {
            if (fromIndex == 0 && leftLength == 0) {
                return;
            }
            if (node.getNodeType() == 3) {
                nodeLength = node.getNodeValue().length();
            } else if (node.getNodeType() == 1) {
                if (node.getLocalName().equals("s")) {
                    try {
                        nodeLength = Integer.parseInt(((Element)node).getAttributeNS(OdfDocumentNamespace.TEXT.getUri(), "c"));
                    }
                    catch (Exception e) {
                        nodeLength = 1;
                    }
                } else {
                    nodeLength = node.getLocalName().equals("line-break") ? 1 : (node.getLocalName().equals("tab") ? 1 : TextExtractor.getText((OdfElement)node).length());
                }
            }
            if (nodeLength <= fromIndex) {
                fromIndex -= nodeLength;
                continue;
            }
            if (node.getNodeType() == 3) {
                String value = node.getNodeValue();
                StringBuffer buffer = new StringBuffer();
                buffer.append(value.substring(0, fromIndex));
                int endLength = fromIndex + leftLength;
                int nextLength = value.length() - endLength;
                fromIndex = 0;
                if (nextLength >= 0) {
                    buffer.append(value.substring(endLength, value.length()));
                    leftLength = 0;
                } else {
                    leftLength = endLength - value.length();
                }
                node.setNodeValue(buffer.toString());
                continue;
            }
            if (node.getNodeType() != 1) continue;
            if (node.getLocalName().equals("s")) {
                ((TextSElement)node).setTextCAttribute(new Integer(nodeLength - fromIndex));
                leftLength -= nodeLength - fromIndex;
                fromIndex = 0;
                continue;
            }
            if (node.getLocalName().equals("line-break") || node.getLocalName().equals("tab")) {
                fromIndex = 0;
                --leftLength;
                continue;
            }
            this.delete(fromIndex, leftLength, node);
            int length = fromIndex + leftLength - nodeLength;
            leftLength = length > 0 ? length : 0;
            fromIndex = 0;
        }
    }

    private void insertSpan(OdfTextSpan textSpan, int fromIndex, Node pNode) {
        if (fromIndex < 0) {
            fromIndex = 0;
        }
        if (fromIndex == 0 && this.mIsInserted) {
            return;
        }
        int nodeLength = 0;
        for (Node node = pNode.getFirstChild(); node != null; node = node.getNextSibling()) {
            if (fromIndex <= 0 && this.mIsInserted) {
                return;
            }
            if (node.getNodeType() == 3) {
                nodeLength = node.getNodeValue().length();
                if (fromIndex != 0 && nodeLength < fromIndex) {
                    fromIndex -= nodeLength;
                    continue;
                }
                String value = node.getNodeValue();
                StringBuffer buffer = new StringBuffer();
                buffer.append(value.substring(0, fromIndex));
                node.setNodeValue(buffer.toString());
                Node nextNode = node.getNextSibling();
                Node parNode = node.getParentNode();
                Node newNode = node.cloneNode(true);
                newNode.setNodeValue(value.substring(fromIndex, value.length()));
                if (nextNode != null) {
                    parNode.insertBefore((Node)textSpan, nextNode);
                    parNode.insertBefore(newNode, nextNode);
                } else {
                    parNode.appendChild((Node)textSpan);
                    parNode.appendChild(newNode);
                }
                this.mIsInserted = true;
                return;
            }
            if (node.getNodeType() != 1) continue;
            if (node.getLocalName().equals("s")) {
                try {
                    nodeLength = Integer.parseInt(((Element)node).getAttributeNS(OdfDocumentNamespace.TEXT.getUri(), "c"));
                }
                catch (Exception e) {
                    nodeLength = 1;
                }
                fromIndex -= nodeLength;
                continue;
            }
            if (node.getLocalName().equals("line-break")) {
                nodeLength = 1;
                --fromIndex;
                continue;
            }
            if (node.getLocalName().equals("tab")) {
                nodeLength = 1;
                --fromIndex;
                continue;
            }
            nodeLength = TextExtractor.getText((OdfElement)node).length();
            this.insertSpan(textSpan, fromIndex, node);
            fromIndex -= nodeLength;
        }
    }
}

