/*
 * Decompiled with CFR 0.152.
 */
package com.shiftphones.shifternetzwerk.aop.logging;

import java.io.Serializable;
import kotlin.Metadata;
import kotlin.collections.ArraysKt;
import kotlin.jvm.internal.Intrinsics;
import org.aspectj.lang.JoinPoint;
import org.aspectj.lang.ProceedingJoinPoint;
import org.aspectj.lang.Signature;
import org.aspectj.lang.annotation.AfterThrowing;
import org.aspectj.lang.annotation.Around;
import org.aspectj.lang.annotation.Aspect;
import org.aspectj.lang.annotation.Pointcut;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.core.env.Environment;
import org.springframework.core.env.Profiles;

@Aspect
@Metadata(mv={1, 1, 16}, bv={1, 0, 3}, k=1, d1={"\u00004\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0003\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\b\u0017\u0018\u00002\u00020\u0001B\r\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004J\b\u0010\u0005\u001a\u00020\u0006H\u0007J\u0018\u0010\u0007\u001a\u00020\u00062\u0006\u0010\b\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\u000bH\u0007J\u0012\u0010\f\u001a\u0004\u0018\u00010\u00012\u0006\u0010\b\u001a\u00020\rH\u0007J\u0018\u0010\u000e\u001a\n \u0010*\u0004\u0018\u00010\u000f0\u000f2\u0006\u0010\b\u001a\u00020\tH\u0002J\b\u0010\u0011\u001a\u00020\u0006H\u0007R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0012"}, d2={"Lcom/shiftphones/shifternetzwerk/aop/logging/LoggingAspect;", "", "env", "Lorg/springframework/core/env/Environment;", "(Lorg/springframework/core/env/Environment;)V", "applicationPackagePointcut", "", "logAfterThrowing", "joinPoint", "Lorg/aspectj/lang/JoinPoint;", "e", "", "logAround", "Lorg/aspectj/lang/ProceedingJoinPoint;", "logger", "Lorg/slf4j/Logger;", "kotlin.jvm.PlatformType", "springBeanPointcut", "shifternetzwerk"})
public class LoggingAspect {
    private final Environment env;

    @Pointcut(value="within(@org.springframework.stereotype.Repository *) || within(@org.springframework.stereotype.Service *) || within(@org.springframework.web.bind.annotation.RestController *)")
    public final void springBeanPointcut() {
    }

    @Pointcut(value="within(com.shiftphones.shifternetzwerk.repository..*) || within(com.shiftphones.shifternetzwerk.service..*) || within(com.shiftphones.shifternetzwerk.web.rest..*)")
    public final void applicationPackagePointcut() {
    }

    private final Logger logger(JoinPoint joinPoint) {
        Signature signature = joinPoint.getSignature();
        Intrinsics.checkExpressionValueIsNotNull((Object)signature, (String)"joinPoint.signature");
        return LoggerFactory.getLogger((String)signature.getDeclaringTypeName());
    }

    @AfterThrowing(pointcut="applicationPackagePointcut() && springBeanPointcut()", throwing="e")
    public final void logAfterThrowing(@NotNull JoinPoint joinPoint, @NotNull Throwable e) {
        Intrinsics.checkParameterIsNotNull((Object)joinPoint, (String)"joinPoint");
        Intrinsics.checkParameterIsNotNull((Object)e, (String)"e");
        if (this.env.acceptsProfiles(Profiles.of((String[])new String[]{"dev"}))) {
            Logger logger = this.logger(joinPoint);
            Object[] objectArray = new Object[4];
            Signature signature = joinPoint.getSignature();
            Intrinsics.checkExpressionValueIsNotNull((Object)signature, (String)"joinPoint.signature");
            objectArray[0] = signature.getName();
            objectArray[1] = e.getCause() != null ? (Serializable)e.getCause() : (Serializable)((Object)"NULL");
            objectArray[2] = e.getMessage();
            objectArray[3] = e;
            logger.error("Exception in {}() with cause = '{}' and exception = '{}'", objectArray);
        } else {
            Logger logger = this.logger(joinPoint);
            Signature signature = joinPoint.getSignature();
            Intrinsics.checkExpressionValueIsNotNull((Object)signature, (String)"joinPoint.signature");
            logger.error("Exception in {}() with cause = {}", (Object)signature.getName(), (Object)(e.getCause() != null ? (Serializable)e.getCause() : (Serializable)((Object)"NULL")));
        }
    }

    @Around(value="applicationPackagePointcut() && springBeanPointcut()")
    @Nullable
    public final Object logAround(@NotNull ProceedingJoinPoint joinPoint) {
        Logger log;
        Intrinsics.checkParameterIsNotNull((Object)joinPoint, (String)"joinPoint");
        Logger logger = log = this.logger((JoinPoint)joinPoint);
        Intrinsics.checkExpressionValueIsNotNull((Object)logger, (String)"log");
        if (logger.isDebugEnabled()) {
            StringBuilder stringBuilder = new StringBuilder().append("Enter: ");
            Signature signature = joinPoint.getSignature();
            Intrinsics.checkExpressionValueIsNotNull((Object)signature, (String)"joinPoint.signature");
            StringBuilder stringBuilder2 = stringBuilder.append(signature.getName()).append("() with argument[s] = ");
            Object[] objectArray = joinPoint.getArgs();
            Intrinsics.checkExpressionValueIsNotNull((Object)objectArray, (String)"joinPoint.args");
            log.debug(stringBuilder2.append(ArraysKt.joinToString$default((Object[])objectArray, null, null, null, (int)0, null, null, (int)63, null)).toString());
        }
        try {
            Object result = joinPoint.proceed();
            if (log.isDebugEnabled()) {
                StringBuilder stringBuilder = new StringBuilder().append("Exit: ");
                Signature signature = joinPoint.getSignature();
                Intrinsics.checkExpressionValueIsNotNull((Object)signature, (String)"joinPoint.signature");
                log.debug(stringBuilder.append(signature.getName()).append("() with result = ").append(result).toString());
            }
            return result;
        }
        catch (IllegalArgumentException e) {
            StringBuilder stringBuilder = new StringBuilder().append("Illegal argument: ");
            Object[] objectArray = joinPoint.getArgs();
            Intrinsics.checkExpressionValueIsNotNull((Object)objectArray, (String)"joinPoint.args");
            StringBuilder stringBuilder3 = stringBuilder.append(ArraysKt.joinToString$default((Object[])objectArray, null, null, null, (int)0, null, null, (int)63, null)).append(" in ");
            Signature signature = joinPoint.getSignature();
            Intrinsics.checkExpressionValueIsNotNull((Object)signature, (String)"joinPoint.signature");
            log.error(stringBuilder3.append(signature.getName()).append("()").toString());
            throw (Throwable)e;
        }
    }

    public LoggingAspect(@NotNull Environment env) {
        Intrinsics.checkParameterIsNotNull((Object)env, (String)"env");
        this.env = env;
    }
}

