/*
 * Decompiled with CFR 0.152.
 */
package com.shiftphones.shifternetzwerk.service;

import com.shiftphones.shifternetzwerk.config.audit.AuditEventConverter;
import com.shiftphones.shifternetzwerk.domain.PersistentAuditEvent;
import com.shiftphones.shifternetzwerk.repository.PersistenceAuditEventRepository;
import io.github.jhipster.config.JHipsterProperties;
import java.time.Instant;
import java.time.temporal.ChronoUnit;
import java.util.Optional;
import java.util.function.Function;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.boot.actuate.audit.AuditEvent;
import org.springframework.data.domain.Page;
import org.springframework.data.domain.Pageable;
import org.springframework.scheduling.annotation.Scheduled;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

@Service
@Transactional
@Metadata(mv={1, 1, 16}, bv={1, 0, 3}, k=1, d1={"\u0000R\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\t\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0000\b\u0017\u0018\u00002\u00020\u0001B\u001d\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u00a2\u0006\u0002\u0010\bJ\u0016\u0010\f\u001a\b\u0012\u0004\u0012\u00020\u000e0\r2\u0006\u0010\u000f\u001a\u00020\u0010H\u0017J\u0016\u0010\u0011\u001a\b\u0012\u0004\u0012\u00020\u000e0\u00122\u0006\u0010\u0013\u001a\u00020\u0014H\u0017J&\u0010\u0015\u001a\b\u0012\u0004\u0012\u00020\u000e0\u00122\u0006\u0010\u0016\u001a\u00020\u00172\u0006\u0010\u0018\u001a\u00020\u00172\u0006\u0010\u0013\u001a\u00020\u0014H\u0017J\b\u0010\u0019\u001a\u00020\u001aH\u0017R\u000e\u0010\u0004\u001a\u00020\u0005X\u0092\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0007X\u0092\u0004\u00a2\u0006\u0002\n\u0000R\u0016\u0010\t\u001a\n \u000b*\u0004\u0018\u00010\n0\nX\u0092\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0002\u001a\u00020\u0003X\u0092\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u001b"}, d2={"Lcom/shiftphones/shifternetzwerk/service/AuditEventService;", "", "persistenceAuditEventRepository", "Lcom/shiftphones/shifternetzwerk/repository/PersistenceAuditEventRepository;", "auditEventConverter", "Lcom/shiftphones/shifternetzwerk/config/audit/AuditEventConverter;", "jHipsterProperties", "Lio/github/jhipster/config/JHipsterProperties;", "(Lcom/shiftphones/shifternetzwerk/repository/PersistenceAuditEventRepository;Lcom/shiftphones/shifternetzwerk/config/audit/AuditEventConverter;Lio/github/jhipster/config/JHipsterProperties;)V", "log", "Lorg/slf4j/Logger;", "kotlin.jvm.PlatformType", "find", "Ljava/util/Optional;", "Lorg/springframework/boot/actuate/audit/AuditEvent;", "id", "", "findAll", "Lorg/springframework/data/domain/Page;", "pageable", "Lorg/springframework/data/domain/Pageable;", "findByDates", "fromDate", "Ljava/time/Instant;", "toDate", "removeOldAuditEvents", "", "shifternetzwerk"})
public class AuditEventService {
    private final Logger log;
    private final PersistenceAuditEventRepository persistenceAuditEventRepository;
    private final AuditEventConverter auditEventConverter;
    private final JHipsterProperties jHipsterProperties;

    @Scheduled(cron="0 0 12 * * ?")
    public void removeOldAuditEvents() {
        Instant instant = Instant.now();
        JHipsterProperties.AuditEvents auditEvents = this.jHipsterProperties.getAuditEvents();
        Intrinsics.checkExpressionValueIsNotNull((Object)auditEvents, (String)"jHipsterProperties.auditEvents");
        Instant instant2 = instant.minus(auditEvents.getRetentionPeriod(), ChronoUnit.DAYS);
        Intrinsics.checkExpressionValueIsNotNull((Object)instant2, (String)"Instant.now().minus(jHip\u2026oLong(), ChronoUnit.DAYS)");
        Iterable $this$forEach$iv = this.persistenceAuditEventRepository.findByAuditEventDateBefore(instant2);
        boolean $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            PersistentAuditEvent it = (PersistentAuditEvent)element$iv;
            boolean bl = false;
            this.log.debug("Deleting audit data " + it);
            this.persistenceAuditEventRepository.delete((Object)it);
        }
    }

    @Transactional(readOnly=true)
    @NotNull
    public Page<AuditEvent> findAll(@NotNull Pageable pageable) {
        Intrinsics.checkParameterIsNotNull((Object)pageable, (String)"pageable");
        Page page = this.persistenceAuditEventRepository.findAll(pageable).map((Function)new /* Unavailable Anonymous Inner Class!! */);
        Intrinsics.checkExpressionValueIsNotNull((Object)page, (String)"persistenceAuditEventRep\u2026convertToAuditEvent(it) }");
        return page;
    }

    @Transactional(readOnly=true)
    @NotNull
    public Page<AuditEvent> findByDates(@NotNull Instant fromDate, @NotNull Instant toDate, @NotNull Pageable pageable) {
        Intrinsics.checkParameterIsNotNull((Object)fromDate, (String)"fromDate");
        Intrinsics.checkParameterIsNotNull((Object)toDate, (String)"toDate");
        Intrinsics.checkParameterIsNotNull((Object)pageable, (String)"pageable");
        Page page = this.persistenceAuditEventRepository.findAllByAuditEventDateBetween(fromDate, toDate, pageable).map((Function)new /* Unavailable Anonymous Inner Class!! */);
        Intrinsics.checkExpressionValueIsNotNull((Object)page, (String)"persistenceAuditEventRep\u2026convertToAuditEvent(it) }");
        return page;
    }

    @Transactional(readOnly=true)
    @NotNull
    public Optional<AuditEvent> find(long id) {
        Optional<AuditEvent> optional = this.persistenceAuditEventRepository.findById((Object)id).map((Function)new /* Unavailable Anonymous Inner Class!! */);
        Intrinsics.checkExpressionValueIsNotNull(optional, (String)"persistenceAuditEventRep\u2026convertToAuditEvent(it) }");
        return optional;
    }

    public AuditEventService(@NotNull PersistenceAuditEventRepository persistenceAuditEventRepository, @NotNull AuditEventConverter auditEventConverter, @NotNull JHipsterProperties jHipsterProperties) {
        Intrinsics.checkParameterIsNotNull((Object)persistenceAuditEventRepository, (String)"persistenceAuditEventRepository");
        Intrinsics.checkParameterIsNotNull((Object)auditEventConverter, (String)"auditEventConverter");
        Intrinsics.checkParameterIsNotNull((Object)jHipsterProperties, (String)"jHipsterProperties");
        this.persistenceAuditEventRepository = persistenceAuditEventRepository;
        this.auditEventConverter = auditEventConverter;
        this.jHipsterProperties = jHipsterProperties;
        this.log = LoggerFactory.getLogger(this.getClass());
    }

    public static final /* synthetic */ AuditEventConverter access$getAuditEventConverter$p(AuditEventService $this) {
        return $this.auditEventConverter;
    }
}

