/*
 * Decompiled with CFR 0.152.
 */
package com.shiftphones.shifternetzwerk.service;

import com.shiftphones.shifternetzwerk.domain.Histownedproduct;
import com.shiftphones.shifternetzwerk.domain.Product;
import com.shiftphones.shifternetzwerk.domain.Productinstance;
import com.shiftphones.shifternetzwerk.domain.Serialnumber;
import com.shiftphones.shifternetzwerk.domain.Shifter;
import com.shiftphones.shifternetzwerk.domain.UserProductInstance;
import com.shiftphones.shifternetzwerk.repository.HistownedproductRepository;
import com.shiftphones.shifternetzwerk.repository.ProductinstanceRepository;
import com.shiftphones.shifternetzwerk.repository.SerialnumberRepository;
import com.shiftphones.shifternetzwerk.repository.ShifterRepository;
import com.shiftphones.shifternetzwerk.web.rest.ResourceHelperService;
import java.time.ZonedDateTime;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Set;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.data.repository.CrudRepository;
import org.springframework.data.repository.CrudRepositoryExtensionsKt;
import org.springframework.stereotype.Service;

@Service
@Metadata(mv={1, 1, 16}, bv={1, 0, 3}, k=1, d1={"\u0000R\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0010\t\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\b\u0017\u0018\u00002\u00020\u0001B-\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u0012\u0006\u0010\b\u001a\u00020\t\u0012\u0006\u0010\n\u001a\u00020\u000b\u00a2\u0006\u0002\u0010\fJ\u0010\u0010\u0016\u001a\u00020\u00172\u0006\u0010\u0018\u001a\u00020\u0019H\u0016J\u0010\u0010\u001a\u001a\u00020\u001b2\u0006\u0010\u001c\u001a\u00020\u001dH\u0016J\u0012\u0010\u001e\u001a\u0004\u0018\u00010\u001f2\u0006\u0010\u001c\u001a\u00020\u001dH\u0016J\u0010\u0010 \u001a\u00020\u00172\u0006\u0010!\u001a\u00020\u0019H\u0012R\u0014\u0010\b\u001a\u00020\tX\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\r\u0010\u000eR\u0016\u0010\u000f\u001a\n \u0011*\u0004\u0018\u00010\u00100\u0010X\u0092\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u0004\u001a\u00020\u0005X\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0012\u0010\u0013R\u000e\u0010\n\u001a\u00020\u000bX\u0092\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u0006\u001a\u00020\u0007X\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0014\u0010\u0015R\u000e\u0010\u0002\u001a\u00020\u0003X\u0092\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\""}, d2={"Lcom/shiftphones/shifternetzwerk/service/ProductInstanceService;", "", "shifterRepository", "Lcom/shiftphones/shifternetzwerk/repository/ShifterRepository;", "productinstanceRepository", "Lcom/shiftphones/shifternetzwerk/repository/ProductinstanceRepository;", "serialnumberRepository", "Lcom/shiftphones/shifternetzwerk/repository/SerialnumberRepository;", "histownedproductRepository", "Lcom/shiftphones/shifternetzwerk/repository/HistownedproductRepository;", "resourceHelperService", "Lcom/shiftphones/shifternetzwerk/web/rest/ResourceHelperService;", "(Lcom/shiftphones/shifternetzwerk/repository/ShifterRepository;Lcom/shiftphones/shifternetzwerk/repository/ProductinstanceRepository;Lcom/shiftphones/shifternetzwerk/repository/SerialnumberRepository;Lcom/shiftphones/shifternetzwerk/repository/HistownedproductRepository;Lcom/shiftphones/shifternetzwerk/web/rest/ResourceHelperService;)V", "getHistownedproductRepository", "()Lcom/shiftphones/shifternetzwerk/repository/HistownedproductRepository;", "log", "Lorg/slf4j/Logger;", "kotlin.jvm.PlatformType", "getProductinstanceRepository", "()Lcom/shiftphones/shifternetzwerk/repository/ProductinstanceRepository;", "getSerialnumberRepository", "()Lcom/shiftphones/shifternetzwerk/repository/SerialnumberRepository;", "create", "Lcom/shiftphones/shifternetzwerk/domain/Productinstance;", "pi", "Lcom/shiftphones/shifternetzwerk/domain/UserProductInstance;", "endOwnership", "", "piId", "", "findActiveOwnerShip", "Lcom/shiftphones/shifternetzwerk/domain/Histownedproduct;", "stdSaveLogic", "upi", "shifternetzwerk"})
public class ProductInstanceService {
    private final Logger log;
    private final ShifterRepository shifterRepository;
    @NotNull
    private final ProductinstanceRepository productinstanceRepository;
    @NotNull
    private final SerialnumberRepository serialnumberRepository;
    @NotNull
    private final HistownedproductRepository histownedproductRepository;
    private final ResourceHelperService resourceHelperService;

    @NotNull
    public Productinstance create(@NotNull UserProductInstance pi) {
        Intrinsics.checkParameterIsNotNull((Object)pi, (String)"pi");
        Productinstance result = this.stdSaveLogic(pi);
        this.log.info("Created new serviceProvider " + result.getId());
        return result;
    }

    /*
     * WARNING - void declaration
     */
    private Productinstance stdSaveLogic(UserProductInstance upi) {
        Shifter shifter = (Shifter)CrudRepositoryExtensionsKt.findByIdOrNull((CrudRepository)((CrudRepository)this.shifterRepository), (Object)upi.getShifterId());
        if (shifter != null) {
            Set $this$mapTo$iv$iv;
            Shifter shifter2 = shifter;
            boolean bl = false;
            boolean bl2 = false;
            Shifter shifter3 = shifter2;
            boolean bl3 = false;
            Iterable $this$map$iv = upi.getSerialNumbers();
            boolean $i$f$map22 = false;
            Iterable iterable = $this$map$iv;
            Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
            boolean $i$f$mapTo = false;
            for (Object item$iv$iv : $this$mapTo$iv$iv) {
                void it;
                String string = (String)item$iv$iv;
                Collection collection = destination$iv$iv;
                boolean bl4 = false;
                Serialnumber serialnumber = new Serialnumber(null, (String)it, null, 5, null);
                collection.add(serialnumber);
            }
            List serialnumbers = CollectionsKt.toList((Iterable)((List)destination$iv$iv));
            Set $i$f$map22 = CollectionsKt.toMutableSet((Iterable)serialnumbers);
            $this$mapTo$iv$iv = null;
            destination$iv$iv = new Product(Long.valueOf(upi.getProductId()), null, null, null, null, null, 62, null);
            Productinstance pi = new Productinstance(null, Boolean.valueOf(false), $i$f$map22, $this$mapTo$iv$iv, (Product)destination$iv$iv, 9, null);
            Productinstance result = (Productinstance)this.getProductinstanceRepository().save((Object)pi);
            Iterable $this$forEach$iv = serialnumbers;
            boolean $i$f$forEach = false;
            for (Object element$iv : $this$forEach$iv) {
                Serialnumber it = (Serialnumber)element$iv;
                boolean bl5 = false;
                it.setProductinstance(result);
            }
            this.getSerialnumberRepository().saveAll((Iterable)serialnumbers);
            Histownedproduct hist = new Histownedproduct(null, ZonedDateTime.now(), null, pi, shifter3, 5, null);
            this.getHistownedproductRepository().save((Object)hist);
            pi.getOwneds().add(hist);
            this.getProductinstanceRepository().save((Object)pi);
            shifter3.getHistownedproducts().add(hist);
            this.shifterRepository.save((Object)shifter3);
            Productinstance productinstance = result;
            Intrinsics.checkExpressionValueIsNotNull((Object)productinstance, (String)"result");
            return productinstance;
        }
        throw (Throwable)new RuntimeException("Shifter not found " + upi.getShifterId());
    }

    @Nullable
    public Histownedproduct findActiveOwnerShip(long piId) {
        Productinstance productinstance = (Productinstance)CrudRepositoryExtensionsKt.findByIdOrNull((CrudRepository)((CrudRepository)this.getProductinstanceRepository()), (Object)piId);
        if (productinstance != null) {
            Productinstance productinstance2 = productinstance;
            boolean bl = false;
            boolean bl2 = false;
            Productinstance pi = productinstance2;
            boolean bl3 = false;
            Iterable iterable = pi.getOwneds();
            boolean bl4 = false;
            Iterable iterable2 = iterable;
            boolean bl5 = false;
            Object var12_13 = null;
            for (Object t : iterable2) {
                Histownedproduct it = (Histownedproduct)t;
                boolean bl6 = false;
                if (!(it.getValidTo() == null)) continue;
                var12_13 = t;
            }
            Histownedproduct histownedproduct = var12_13;
            if (histownedproduct != null) {
                iterable = histownedproduct;
                bl4 = false;
                boolean bl7 = false;
                Iterable it = iterable;
                boolean bl8 = false;
                return it;
            }
            return null;
        }
        throw (Throwable)new RuntimeException("unknown productid " + piId);
    }

    public void endOwnership(long piId) {
        Histownedproduct histownedproduct = this.findActiveOwnerShip(piId);
        if (histownedproduct != null) {
            Histownedproduct histownedproduct2 = histownedproduct;
            boolean bl = false;
            boolean bl2 = false;
            Histownedproduct it = histownedproduct2;
            boolean bl3 = false;
            Shifter shifter = it.getShifter();
            if (shifter == null) {
                Intrinsics.throwNpe();
            }
            Long l = shifter.getId();
            if (l == null) {
                Intrinsics.throwNpe();
            }
            this.resourceHelperService.isCurrentUserPowerUserOrOneOfTheShifterAndThrowIfNotAllowed(l.longValue());
            it.setValidTo(ZonedDateTime.now());
            this.getHistownedproductRepository().save((Object)it);
            return;
        }
        throw (Throwable)new RuntimeException("no open ownership found piId " + piId);
    }

    @NotNull
    public ProductinstanceRepository getProductinstanceRepository() {
        return this.productinstanceRepository;
    }

    @NotNull
    public SerialnumberRepository getSerialnumberRepository() {
        return this.serialnumberRepository;
    }

    @NotNull
    public HistownedproductRepository getHistownedproductRepository() {
        return this.histownedproductRepository;
    }

    public ProductInstanceService(@NotNull ShifterRepository shifterRepository, @NotNull ProductinstanceRepository productinstanceRepository, @NotNull SerialnumberRepository serialnumberRepository, @NotNull HistownedproductRepository histownedproductRepository, @NotNull ResourceHelperService resourceHelperService) {
        Intrinsics.checkParameterIsNotNull((Object)shifterRepository, (String)"shifterRepository");
        Intrinsics.checkParameterIsNotNull((Object)productinstanceRepository, (String)"productinstanceRepository");
        Intrinsics.checkParameterIsNotNull((Object)serialnumberRepository, (String)"serialnumberRepository");
        Intrinsics.checkParameterIsNotNull((Object)histownedproductRepository, (String)"histownedproductRepository");
        Intrinsics.checkParameterIsNotNull((Object)resourceHelperService, (String)"resourceHelperService");
        this.shifterRepository = shifterRepository;
        this.productinstanceRepository = productinstanceRepository;
        this.serialnumberRepository = serialnumberRepository;
        this.histownedproductRepository = histownedproductRepository;
        this.resourceHelperService = resourceHelperService;
        this.log = LoggerFactory.getLogger(this.getClass());
    }
}

