/*
 * Decompiled with CFR 0.152.
 */
package com.shiftphones.shifternetzwerk.service;

import com.shiftphones.shifternetzwerk.repository.ServiceProviderRepositoryDbDirectSearch;
import com.shiftphones.shifternetzwerk.service.ShortShifterOverview;
import com.shiftphones.shifternetzwerk.web.rest.ResourceHelperService;
import java.util.List;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.cache.annotation.CacheConfig;
import org.springframework.cache.annotation.Cacheable;
import org.springframework.stereotype.Service;

@Service
@CacheConfig(cacheNames={"shifterOwv"})
@Metadata(mv={1, 1, 16}, bv={1, 0, 3}, k=1, d1={"\u00000\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\b\u0017\u0018\u00002\u00020\u0001B\u0015\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0002\u0010\u0006J\u0016\u0010\n\u001a\b\u0012\u0004\u0012\u00020\f0\u000b2\u0006\u0010\r\u001a\u00020\u000eH\u0017R\u0016\u0010\u0007\u001a\n \t*\u0004\u0018\u00010\b0\bX\u0092\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0004\u001a\u00020\u0005X\u0092\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0002\u001a\u00020\u0003X\u0092\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u000f"}, d2={"Lcom/shiftphones/shifternetzwerk/service/ShifterOverviewService;", "", "shifterService", "Lcom/shiftphones/shifternetzwerk/repository/ServiceProviderRepositoryDbDirectSearch;", "resourceHelperService", "Lcom/shiftphones/shifternetzwerk/web/rest/ResourceHelperService;", "(Lcom/shiftphones/shifternetzwerk/repository/ServiceProviderRepositoryDbDirectSearch;Lcom/shiftphones/shifternetzwerk/web/rest/ResourceHelperService;)V", "log", "Lorg/slf4j/Logger;", "kotlin.jvm.PlatformType", "getAll", "", "Lcom/shiftphones/shifternetzwerk/service/ShortShifterOverview;", "userId", "", "shifternetzwerk"})
public class ShifterOverviewService {
    private final Logger log;
    private final ServiceProviderRepositoryDbDirectSearch shifterService;
    private final ResourceHelperService resourceHelperService;

    @Cacheable(key="#userId", value={"shifterOwv"})
    @NotNull
    public List<ShortShifterOverview> getAll(@NotNull String userId) {
        Intrinsics.checkParameterIsNotNull((Object)userId, (String)"userId");
        this.log.info("noncached " + userId);
        return this.shifterService.findAllShifter(userId);
    }

    public ShifterOverviewService(@NotNull ServiceProviderRepositoryDbDirectSearch shifterService, @NotNull ResourceHelperService resourceHelperService) {
        Intrinsics.checkParameterIsNotNull((Object)shifterService, (String)"shifterService");
        Intrinsics.checkParameterIsNotNull((Object)resourceHelperService, (String)"resourceHelperService");
        this.shifterService = shifterService;
        this.resourceHelperService = resourceHelperService;
        this.log = LoggerFactory.getLogger(this.getClass());
    }
}

