/*
 * Decompiled with CFR 0.152.
 */
package com.shiftphones.shifternetzwerk.service;

import com.shiftphones.shifternetzwerk.domain.Authority;
import com.shiftphones.shifternetzwerk.domain.User;
import com.shiftphones.shifternetzwerk.repository.AuthorityRepository;
import com.shiftphones.shifternetzwerk.repository.UserRepository;
import com.shiftphones.shifternetzwerk.security.SecurityUtils;
import com.shiftphones.shifternetzwerk.service.UserService;
import com.shiftphones.shifternetzwerk.service.dto.UserDTO;
import java.time.Instant;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.function.Consumer;
import java.util.function.Function;
import kotlin.Metadata;
import kotlin.TypeCastException;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.JvmStatic;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import kotlin.sequences.Sequence;
import kotlin.sequences.SequencesKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.cache.Cache;
import org.springframework.cache.CacheManager;
import org.springframework.data.domain.Page;
import org.springframework.data.domain.Pageable;
import org.springframework.security.authentication.AbstractAuthenticationToken;
import org.springframework.security.oauth2.client.authentication.OAuth2AuthenticationToken;
import org.springframework.security.oauth2.core.user.OAuth2User;
import org.springframework.security.oauth2.server.resource.authentication.JwtAuthenticationToken;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

/*
 * Exception performing whole class analysis ignored.
 */
@Service
@Transactional
@Metadata(mv={1, 1, 16}, bv={1, 0, 3}, k=1, d1={"\u0000d\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010!\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010$\n\u0002\b\b\b\u0017\u0018\u0000 '2\u00020\u0001:\u0001'B\u001d\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u00a2\u0006\u0002\u0010\bJ\u0010\u0010\f\u001a\u00020\r2\u0006\u0010\u000e\u001a\u00020\u000fH\u0012J\u0016\u0010\u0010\u001a\b\u0012\u0004\u0012\u00020\u00120\u00112\u0006\u0010\u0013\u001a\u00020\u0014H\u0017J\u000e\u0010\u0015\u001a\b\u0012\u0004\u0012\u00020\u00170\u0016H\u0017J\u0010\u0010\u0018\u001a\u00020\u00122\u0006\u0010\u0019\u001a\u00020\u001aH\u0017J\u0016\u0010\u001b\u001a\b\u0012\u0004\u0012\u00020\u000f0\u001c2\u0006\u0010\u001d\u001a\u00020\u0017H\u0017J$\u0010\u001e\u001a\u00020\u000f2\u0012\u0010\u001f\u001a\u000e\u0012\u0004\u0012\u00020\u0017\u0012\u0004\u0012\u00020\u00010 2\u0006\u0010\u000e\u001a\u00020\u000fH\u0012J:\u0010!\u001a\u00020\r2\b\u0010\"\u001a\u0004\u0018\u00010\u00172\b\u0010#\u001a\u0004\u0018\u00010\u00172\b\u0010$\u001a\u0004\u0018\u00010\u00172\b\u0010%\u001a\u0004\u0018\u00010\u00172\b\u0010&\u001a\u0004\u0018\u00010\u0017H\u0016R\u000e\u0010\u0004\u001a\u00020\u0005X\u0092\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0007X\u0092\u0004\u00a2\u0006\u0002\n\u0000R\u0016\u0010\t\u001a\n \u000b*\u0004\u0018\u00010\n0\nX\u0092\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0002\u001a\u00020\u0003X\u0092\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006("}, d2={"Lcom/shiftphones/shifternetzwerk/service/UserService;", "", "userRepository", "Lcom/shiftphones/shifternetzwerk/repository/UserRepository;", "authorityRepository", "Lcom/shiftphones/shifternetzwerk/repository/AuthorityRepository;", "cacheManager", "Lorg/springframework/cache/CacheManager;", "(Lcom/shiftphones/shifternetzwerk/repository/UserRepository;Lcom/shiftphones/shifternetzwerk/repository/AuthorityRepository;Lorg/springframework/cache/CacheManager;)V", "log", "Lorg/slf4j/Logger;", "kotlin.jvm.PlatformType", "clearUserCaches", "", "user", "Lcom/shiftphones/shifternetzwerk/domain/User;", "getAllManagedUsers", "Lorg/springframework/data/domain/Page;", "Lcom/shiftphones/shifternetzwerk/service/dto/UserDTO;", "pageable", "Lorg/springframework/data/domain/Pageable;", "getAuthorities", "", "", "getUserFromAuthentication", "authToken", "Lorg/springframework/security/authentication/AbstractAuthenticationToken;", "getUserWithAuthoritiesByLogin", "Ljava/util/Optional;", "login", "syncUserWithIdP", "details", "", "updateUser", "firstName", "lastName", "email", "langKey", "imageUrl", "Companion", "shifternetzwerk"})
public class UserService {
    private final Logger log;
    private final UserRepository userRepository;
    private final AuthorityRepository authorityRepository;
    private final CacheManager cacheManager;
    public static final Companion Companion = new Companion(null);

    public void updateUser(@Nullable String firstName, @Nullable String lastName, @Nullable String email, @Nullable String langKey, @Nullable String imageUrl) {
        Function1 function1 = (Function1)new /* Unavailable Anonymous Inner Class!! */;
        SecurityUtils.getCurrentUserLogin().flatMap((Function)new sam.java_util_function_Function.0(function1)).ifPresent((Consumer)new /* Unavailable Anonymous Inner Class!! */);
    }

    @Transactional(readOnly=true)
    @NotNull
    public Page<UserDTO> getAllManagedUsers(@NotNull Pageable pageable) {
        Intrinsics.checkParameterIsNotNull((Object)pageable, (String)"pageable");
        Page page = this.userRepository.findAllByLoginNot(pageable, "anonymoususer").map((Function)getAllManagedUsers.1.INSTANCE);
        Intrinsics.checkExpressionValueIsNotNull((Object)page, (String)"userRepository.findAllBy\u2026USER).map { UserDTO(it) }");
        return page;
    }

    @Transactional(readOnly=true)
    @NotNull
    public Optional<User> getUserWithAuthoritiesByLogin(@NotNull String login) {
        Intrinsics.checkParameterIsNotNull((Object)login, (String)"login");
        return this.userRepository.findOneWithAuthoritiesByLogin(login);
    }

    @Transactional(readOnly=true)
    @NotNull
    public List<String> getAuthorities() {
        List list = this.authorityRepository.findAll();
        Intrinsics.checkExpressionValueIsNotNull((Object)list, (String)"authorityRepository.findAll()");
        Sequence sequence = SequencesKt.map((Sequence)CollectionsKt.asSequence((Iterable)list), (Function1)((Function1)getAuthorities.1.INSTANCE));
        boolean bl = false;
        List list2 = new ArrayList();
        return (List)SequencesKt.filterNotNullTo((Sequence)sequence, (Collection)list2);
    }

    /*
     * WARNING - void declaration
     */
    private User syncUserWithIdP(Map<String, ? extends Object> details, User user) {
        Optional existingUser;
        void $this$mapTo$iv;
        List dbAuthorities = this.getAuthorities();
        Sequence sequence = CollectionsKt.asSequence((Iterable)user.getAuthorities());
        boolean bl = false;
        Collection destination$iv = new ArrayList();
        boolean $i$f$mapTo = false;
        Iterator iterator = $this$mapTo$iv.iterator();
        while (iterator.hasNext()) {
            void receiver;
            Object item$iv;
            Object e = item$iv = iterator.next();
            Collection collection = destination$iv;
            boolean bl2 = false;
            String string = ((Authority)receiver).getName();
            collection.add(string);
        }
        List userAuthorities = (List)destination$iv;
        for (String authority : userAuthorities) {
            if (CollectionsKt.contains((Iterable)dbAuthorities, (Object)authority)) continue;
            this.log.debug("Saving authority '" + authority + "' in local database");
            Authority authorityToSave = new Authority(authority);
            this.authorityRepository.save((Object)authorityToSave);
        }
        String string = user.getLogin();
        if (string == null) {
            Intrinsics.throwNpe();
        }
        if ((existingUser = this.userRepository.findOneByLogin(string)).isPresent()) {
            if (details.get("updated_at") != null) {
                Instant dbModifiedDate = ((User)existingUser.get()).getLastModifiedDate();
                Object object = details.get("updated_at");
                if (object == null) {
                    throw new TypeCastException("null cannot be cast to non-null type java.time.Instant");
                }
                Instant idpModifiedDate = (Instant)object;
                if (idpModifiedDate.isAfter(dbModifiedDate)) {
                    this.log.debug("Updating user '" + user.getLogin() + "' in local database");
                    this.updateUser(user.getFirstName(), user.getLastName(), user.getEmail(), user.getLangKey(), user.getImageUrl());
                }
            } else {
                this.log.debug("Updating user '" + user.getLogin() + "' in local database");
                this.updateUser(user.getFirstName(), user.getLastName(), user.getEmail(), user.getLangKey(), user.getImageUrl());
            }
        } else {
            this.log.debug("Saving user '" + user.getLogin() + "' in local database");
            this.userRepository.save((Object)user);
            this.clearUserCaches(user);
        }
        return user;
    }

    @Transactional
    @NotNull
    public UserDTO getUserFromAuthentication(@NotNull AbstractAuthenticationToken authToken) {
        Map map;
        Intrinsics.checkParameterIsNotNull((Object)authToken, (String)"authToken");
        AbstractAuthenticationToken abstractAuthenticationToken = authToken;
        if (abstractAuthenticationToken instanceof OAuth2AuthenticationToken) {
            OAuth2User oAuth2User = ((OAuth2AuthenticationToken)authToken).getPrincipal();
            Intrinsics.checkExpressionValueIsNotNull((Object)oAuth2User, (String)"authToken.principal");
            Map map2 = oAuth2User.getAttributes();
            map = map2;
            Intrinsics.checkExpressionValueIsNotNull((Object)map2, (String)"authToken.principal.attributes");
        } else if (abstractAuthenticationToken instanceof JwtAuthenticationToken) {
            Map map3 = ((JwtAuthenticationToken)authToken).getTokenAttributes();
            map = map3;
            Intrinsics.checkExpressionValueIsNotNull((Object)map3, (String)"authToken.tokenAttributes");
        } else {
            throw (Throwable)new IllegalArgumentException("AuthenticationToken is not OAuth2 or JWT!");
        }
        Map attributes = map;
        User user = Companion.access$getUser((Companion)Companion, (Map)attributes);
        this.log.info("User " + user.getLogin() + " has the following auths " + user.getAuthorities());
        return new UserDTO(this.syncUserWithIdP(attributes, user));
    }

    private void clearUserCaches(User user) {
        block3: {
            Cache cache = this.cacheManager.getCache("usersByLogin");
            if (cache != null) {
                String string = user.getLogin();
                if (string == null) {
                    Intrinsics.throwNpe();
                }
                cache.evict((Object)string);
            }
            if (user.getEmail() == null) break block3;
            Cache cache2 = this.cacheManager.getCache("usersByEmail");
            if (cache2 != null) {
                cache2.evict((Object)user.getEmail());
            }
        }
    }

    public UserService(@NotNull UserRepository userRepository, @NotNull AuthorityRepository authorityRepository, @NotNull CacheManager cacheManager) {
        Intrinsics.checkParameterIsNotNull((Object)userRepository, (String)"userRepository");
        Intrinsics.checkParameterIsNotNull((Object)authorityRepository, (String)"authorityRepository");
        Intrinsics.checkParameterIsNotNull((Object)cacheManager, (String)"cacheManager");
        this.userRepository = userRepository;
        this.authorityRepository = authorityRepository;
        this.cacheManager = cacheManager;
        this.log = LoggerFactory.getLogger(this.getClass());
    }

    public static final /* synthetic */ void access$clearUserCaches(UserService $this, User user) {
        $this.clearUserCaches(user);
    }

    public static final /* synthetic */ Logger access$getLog$p(UserService $this) {
        return $this.log;
    }

    @JvmStatic
    private static final User getUser(Map<String, ? extends Object> details) {
        return Companion.access$getUser((Companion)Companion, details);
    }
}

