/*
 * Decompiled with CFR 0.152.
 */
package com.shiftphones.shifternetzwerk.web.rest;

import com.shiftphones.shifternetzwerk.service.AuditEventService;
import io.github.jhipster.web.util.PaginationUtil;
import io.github.jhipster.web.util.ResponseUtil;
import java.time.Instant;
import java.time.LocalDate;
import java.time.ZoneId;
import java.util.List;
import java.util.Optional;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.springframework.boot.actuate.audit.AuditEvent;
import org.springframework.data.domain.Page;
import org.springframework.data.domain.Pageable;
import org.springframework.http.HttpHeaders;
import org.springframework.http.HttpStatus;
import org.springframework.http.ResponseEntity;
import org.springframework.util.MultiValueMap;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.RestController;
import org.springframework.web.servlet.support.ServletUriComponentsBuilder;
import org.springframework.web.util.UriComponentsBuilder;

@RestController
@RequestMapping(value={"/management/audits"})
@Metadata(mv={1, 1, 16}, bv={1, 0, 3}, k=1, d1={"\u0000:\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\t\n\u0002\b\u0002\n\u0002\u0010 \n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u0017\u0018\u00002\u00020\u0001B\r\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004J\u001f\u0010\u0005\u001a\b\u0012\u0004\u0012\u00020\u00070\u00062\n\b\u0001\u0010\b\u001a\u0004\u0018\u00010\tH\u0017\u00a2\u0006\u0002\u0010\nJ\u001c\u0010\u000b\u001a\u000e\u0012\n\u0012\b\u0012\u0004\u0012\u00020\u00070\f0\u00062\u0006\u0010\r\u001a\u00020\u000eH\u0017J0\u0010\u000f\u001a\u000e\u0012\n\u0012\b\u0012\u0004\u0012\u00020\u00070\f0\u00062\b\b\u0001\u0010\u0010\u001a\u00020\u00112\b\b\u0001\u0010\u0012\u001a\u00020\u00112\u0006\u0010\r\u001a\u00020\u000eH\u0017R\u000e\u0010\u0002\u001a\u00020\u0003X\u0092\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0013"}, d2={"Lcom/shiftphones/shifternetzwerk/web/rest/AuditResource;", "", "auditEventService", "Lcom/shiftphones/shifternetzwerk/service/AuditEventService;", "(Lcom/shiftphones/shifternetzwerk/service/AuditEventService;)V", "get", "Lorg/springframework/http/ResponseEntity;", "Lorg/springframework/boot/actuate/audit/AuditEvent;", "id", "", "(Ljava/lang/Long;)Lorg/springframework/http/ResponseEntity;", "getAll", "", "pageable", "Lorg/springframework/data/domain/Pageable;", "getByDates", "fromDate", "Ljava/time/LocalDate;", "toDate", "shifternetzwerk"})
public class AuditResource {
    private final AuditEventService auditEventService;

    @GetMapping
    @NotNull
    public ResponseEntity<List<AuditEvent>> getAll(@NotNull Pageable pageable) {
        Intrinsics.checkParameterIsNotNull((Object)pageable, (String)"pageable");
        Page page = this.auditEventService.findAll(pageable);
        HttpHeaders headers = PaginationUtil.generatePaginationHttpHeaders((UriComponentsBuilder)((UriComponentsBuilder)ServletUriComponentsBuilder.fromCurrentRequest()), (Page)page);
        return new ResponseEntity((Object)page.getContent(), (MultiValueMap)headers, HttpStatus.OK);
    }

    @GetMapping(params={"fromDate", "toDate"})
    @NotNull
    public ResponseEntity<List<AuditEvent>> getByDates(@RequestParam(value="fromDate") @NotNull LocalDate fromDate, @RequestParam(value="toDate") @NotNull LocalDate toDate, @NotNull Pageable pageable) {
        Intrinsics.checkParameterIsNotNull((Object)fromDate, (String)"fromDate");
        Intrinsics.checkParameterIsNotNull((Object)toDate, (String)"toDate");
        Intrinsics.checkParameterIsNotNull((Object)pageable, (String)"pageable");
        Instant from = fromDate.atStartOfDay(ZoneId.systemDefault()).toInstant();
        Instant to = toDate.atStartOfDay(ZoneId.systemDefault()).plusDays(1L).toInstant();
        Instant instant = from;
        Intrinsics.checkExpressionValueIsNotNull((Object)instant, (String)"from");
        Instant instant2 = to;
        Intrinsics.checkExpressionValueIsNotNull((Object)instant2, (String)"to");
        Page page = this.auditEventService.findByDates(instant, instant2, pageable);
        HttpHeaders headers = PaginationUtil.generatePaginationHttpHeaders((UriComponentsBuilder)((UriComponentsBuilder)ServletUriComponentsBuilder.fromCurrentRequest()), (Page)page);
        return new ResponseEntity((Object)page.getContent(), (MultiValueMap)headers, HttpStatus.OK);
    }

    @GetMapping(value={"/{id:.+}"})
    @NotNull
    public ResponseEntity<AuditEvent> get(@PathVariable @Nullable Long id) {
        Long l = id;
        if (l == null) {
            Intrinsics.throwNpe();
        }
        ResponseEntity responseEntity = ResponseUtil.wrapOrNotFound((Optional)this.auditEventService.find(l.longValue()));
        Intrinsics.checkExpressionValueIsNotNull((Object)responseEntity, (String)"ResponseUtil.wrapOrNotFo\u2026tEventService.find(id!!))");
        return responseEntity;
    }

    public AuditResource(@NotNull AuditEventService auditEventService) {
        Intrinsics.checkParameterIsNotNull((Object)auditEventService, (String)"auditEventService");
        this.auditEventService = auditEventService;
    }
}

