/*
 * Decompiled with CFR 0.152.
 */
package com.shiftphones.shifternetzwerk.web.rest;

import com.shiftphones.shifternetzwerk.domain.MailTo;
import com.shiftphones.shifternetzwerk.domain.Message;
import com.shiftphones.shifternetzwerk.repository.MailToRepository;
import com.shiftphones.shifternetzwerk.repository.MessageRepository;
import com.shiftphones.shifternetzwerk.web.rest.RestCreationResult;
import com.shiftphones.shifternetzwerk.web.rest.errors.BadRequestAlertException;
import io.github.jhipster.web.util.HeaderUtil;
import java.net.URI;
import java.util.LinkedHashSet;
import java.util.Set;
import javax.validation.Valid;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.http.ResponseEntity;
import org.springframework.transaction.annotation.Transactional;
import org.springframework.web.bind.annotation.DeleteMapping;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(value={"/api"})
@Metadata(mv={1, 1, 16}, bv={1, 0, 3}, k=1, d1={"\u0000B\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\t\n\u0000\b\u0017\u0018\u00002\u00020\u0001B\u0015\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0002\u0010\u0006J\u0018\u0010\f\u001a\b\u0012\u0004\u0012\u00020\u000e0\r2\b\b\u0001\u0010\u000f\u001a\u00020\u0010H\u0017J\u0018\u0010\u0011\u001a\b\u0012\u0004\u0012\u00020\u00120\r2\b\b\u0001\u0010\u0013\u001a\u00020\u0014H\u0017R\u0014\u0010\u0007\u001a\u0004\u0018\u00010\b8\u0012@\u0012X\u0093\u000e\u00a2\u0006\u0002\n\u0000R\u0016\u0010\t\u001a\n \u000b*\u0004\u0018\u00010\n0\nX\u0092\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0004\u001a\u00020\u0005X\u0092\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0002\u001a\u00020\u0003X\u0092\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0015"}, d2={"Lcom/shiftphones/shifternetzwerk/web/rest/MessageResource;", "", "messageRepository", "Lcom/shiftphones/shifternetzwerk/repository/MessageRepository;", "mailToRepository", "Lcom/shiftphones/shifternetzwerk/repository/MailToRepository;", "(Lcom/shiftphones/shifternetzwerk/repository/MessageRepository;Lcom/shiftphones/shifternetzwerk/repository/MailToRepository;)V", "applicationName", "", "log", "Lorg/slf4j/Logger;", "kotlin.jvm.PlatformType", "createMessage", "Lorg/springframework/http/ResponseEntity;", "Lcom/shiftphones/shifternetzwerk/web/rest/RestCreationResult;", "message", "Lcom/shiftphones/shifternetzwerk/domain/Message;", "deleteMessage", "Ljava/lang/Void;", "id", "", "shifternetzwerk"})
public class MessageResource {
    private final Logger log;
    @Value(value="${jhipster.clientApp.name}")
    private String applicationName;
    private final MessageRepository messageRepository;
    private final MailToRepository mailToRepository;

    @PostMapping(value={"/messages"})
    @Transactional
    @NotNull
    public ResponseEntity<RestCreationResult> createMessage(@Valid @RequestBody @NotNull Message message) {
        Intrinsics.checkParameterIsNotNull((Object)message, (String)"message");
        this.log.debug("REST request to save Message : {}", (Object)message);
        if (message.getId() != null) {
            throw (Throwable)new BadRequestAlertException("A new message cannot already have an ID", "message", "idexists");
        }
        message.makeSaveEnsurements();
        try {
            Set mailTos = message.getMailTos();
            Message message2 = message;
            boolean bl = false;
            Set set = new LinkedHashSet();
            message2.setMailTos(set);
            Message result = (Message)this.messageRepository.save((Object)message);
            Iterable $this$forEach$iv = mailTos;
            boolean $i$f$forEach = false;
            for (Object element$iv : $this$forEach$iv) {
                MailTo it = (MailTo)element$iv;
                boolean bl2 = false;
                it.setMessage(result);
                this.mailToRepository.save((Object)it);
            }
            ResponseEntity.BodyBuilder bodyBuilder = (ResponseEntity.BodyBuilder)ResponseEntity.created((URI)new URI("/api/messages/" + result.getId())).headers(HeaderUtil.createEntityCreationAlert((String)this.applicationName, (boolean)true, (String)"message", (String)String.valueOf(result.getId())));
            Long l = result.getId();
            if (l == null) {
                Intrinsics.throwNpe();
            }
            ResponseEntity responseEntity = bodyBuilder.body((Object)new RestCreationResult(l.longValue()));
            Intrinsics.checkExpressionValueIsNotNull((Object)responseEntity, (String)"ResponseEntity.created(U\u2026ationResult(result.id!!))");
            return responseEntity;
        }
        catch (Exception e) {
            this.log.error("err occured", (Throwable)e);
            throw (Throwable)new RuntimeException("");
        }
    }

    @DeleteMapping(value={"/messages/{id}"})
    @NotNull
    public ResponseEntity<Void> deleteMessage(@PathVariable long id) {
        this.log.debug("REST request to delete Message : {}", (Object)id);
        this.messageRepository.deleteById((Object)id);
        ResponseEntity responseEntity = ResponseEntity.noContent().headers(HeaderUtil.createEntityDeletionAlert((String)this.applicationName, (boolean)true, (String)"message", (String)String.valueOf(id))).build();
        Intrinsics.checkExpressionValueIsNotNull((Object)responseEntity, (String)"ResponseEntity.noContent\u2026, id.toString())).build()");
        return responseEntity;
    }

    public MessageResource(@NotNull MessageRepository messageRepository, @NotNull MailToRepository mailToRepository) {
        Intrinsics.checkParameterIsNotNull((Object)messageRepository, (String)"messageRepository");
        Intrinsics.checkParameterIsNotNull((Object)mailToRepository, (String)"mailToRepository");
        this.messageRepository = messageRepository;
        this.mailToRepository = mailToRepository;
        this.log = LoggerFactory.getLogger(this.getClass());
    }
}

