/*
 * Decompiled with CFR 0.152.
 */
package com.shiftphones.shifternetzwerk.web.rest;

import com.shiftphones.shifternetzwerk.domain.Product;
import com.shiftphones.shifternetzwerk.hateoas.ProductHateOasResource;
import com.shiftphones.shifternetzwerk.repository.ProductRepository;
import com.shiftphones.shifternetzwerk.web.rest.ProductHateOasList;
import com.shiftphones.shifternetzwerk.web.rest.Products;
import com.shiftphones.shifternetzwerk.web.rest.errors.BadRequestAlertException;
import io.github.jhipster.web.util.HeaderUtil;
import io.github.jhipster.web.util.ResponseUtil;
import java.net.URI;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Optional;
import javax.validation.Valid;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.http.ResponseEntity;
import org.springframework.web.bind.annotation.DeleteMapping;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.PutMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(value={"/api"})
@Metadata(mv={1, 1, 16}, bv={1, 0, 3}, k=1, d1={"\u0000B\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\t\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u0017\u0018\u00002\u00020\u0001B\r\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004J\u0018\u0010\n\u001a\b\u0012\u0004\u0012\u00020\f0\u000b2\b\b\u0001\u0010\r\u001a\u00020\fH\u0017J\u0018\u0010\u000e\u001a\b\u0012\u0004\u0012\u00020\u000f0\u000b2\b\b\u0001\u0010\u0010\u001a\u00020\u0011H\u0017J\b\u0010\u0012\u001a\u00020\u0001H\u0017J\u0018\u0010\u0013\u001a\b\u0012\u0004\u0012\u00020\u00140\u000b2\b\b\u0001\u0010\u0010\u001a\u00020\u0011H\u0017J\u0018\u0010\u0015\u001a\b\u0012\u0004\u0012\u00020\f0\u000b2\b\b\u0001\u0010\r\u001a\u00020\fH\u0017R\u0014\u0010\u0005\u001a\u0004\u0018\u00010\u00068\u0012@\u0012X\u0093\u000e\u00a2\u0006\u0002\n\u0000R\u0016\u0010\u0007\u001a\n \t*\u0004\u0018\u00010\b0\bX\u0092\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0002\u001a\u00020\u0003X\u0092\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0016"}, d2={"Lcom/shiftphones/shifternetzwerk/web/rest/ProductResource;", "", "productRepository", "Lcom/shiftphones/shifternetzwerk/repository/ProductRepository;", "(Lcom/shiftphones/shifternetzwerk/repository/ProductRepository;)V", "applicationName", "", "log", "Lorg/slf4j/Logger;", "kotlin.jvm.PlatformType", "createProduct", "Lorg/springframework/http/ResponseEntity;", "Lcom/shiftphones/shifternetzwerk/domain/Product;", "product", "deleteProduct", "Ljava/lang/Void;", "id", "", "getAllProducts", "getProduct", "Lcom/shiftphones/shifternetzwerk/hateoas/ProductHateOasResource;", "updateProduct", "shifternetzwerk"})
public class ProductResource {
    private final Logger log;
    @Value(value="${jhipster.clientApp.name}")
    private String applicationName;
    private final ProductRepository productRepository;

    @PostMapping(value={"/products"})
    @NotNull
    public ResponseEntity<Product> createProduct(@Valid @RequestBody @NotNull Product product) {
        Intrinsics.checkParameterIsNotNull((Object)product, (String)"product");
        this.log.debug("REST request to save Product : {}", (Object)product);
        if (product.getId() != null) {
            throw (Throwable)new BadRequestAlertException("A new product cannot already have an ID", "product", "idexists");
        }
        Product result = (Product)this.productRepository.save((Object)product);
        ResponseEntity responseEntity = ((ResponseEntity.BodyBuilder)ResponseEntity.created((URI)new URI("/api/products/" + result.getId())).headers(HeaderUtil.createEntityCreationAlert((String)this.applicationName, (boolean)true, (String)"product", (String)String.valueOf(result.getId())))).body((Object)result);
        Intrinsics.checkExpressionValueIsNotNull((Object)responseEntity, (String)"ResponseEntity.created(U\u2026            .body(result)");
        return responseEntity;
    }

    @PutMapping(value={"/products"})
    @NotNull
    public ResponseEntity<Product> updateProduct(@Valid @RequestBody @NotNull Product product) {
        Intrinsics.checkParameterIsNotNull((Object)product, (String)"product");
        this.log.debug("REST request to update Product : {}", (Object)product);
        if (product.getId() == null) {
            throw (Throwable)new BadRequestAlertException("Invalid id", "product", "idnull");
        }
        Product result = (Product)this.productRepository.save((Object)product);
        ResponseEntity responseEntity = ((ResponseEntity.BodyBuilder)ResponseEntity.ok().headers(HeaderUtil.createEntityUpdateAlert((String)this.applicationName, (boolean)true, (String)"product", (String)String.valueOf(product.getId())))).body((Object)result);
        Intrinsics.checkExpressionValueIsNotNull((Object)responseEntity, (String)"ResponseEntity.ok()\n    \u2026            .body(result)");
        return responseEntity;
    }

    /*
     * WARNING - void declaration
     */
    @GetMapping(value={"/products"})
    @NotNull
    public Object getAllProducts() {
        void $this$mapTo$iv$iv;
        this.log.debug("REST request to get all Products");
        List list = this.productRepository.findAll();
        Intrinsics.checkExpressionValueIsNotNull((Object)list, (String)"productRepository.findAll()");
        Iterable $this$map$iv = list;
        boolean $i$f$map = false;
        Iterable iterable = $this$map$iv;
        Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
        boolean $i$f$mapTo = false;
        for (Object item$iv$iv : $this$mapTo$iv$iv) {
            void it;
            Product product = (Product)item$iv$iv;
            Collection collection = destination$iv$iv;
            boolean bl = false;
            void v1 = it;
            Intrinsics.checkExpressionValueIsNotNull((Object)v1, (String)"it");
            ProductHateOasResource productHateOasResource = new ProductHateOasResource((Product)v1);
            collection.add(productHateOasResource);
        }
        List products = CollectionsKt.toList((Iterable)((List)destination$iv$iv));
        ResponseEntity responseEntity = ResponseEntity.ok((Object)new ProductHateOasList(new Products(products)));
        Intrinsics.checkExpressionValueIsNotNull((Object)responseEntity, (String)"ResponseEntity.ok<Any>(P\u2026List(Products(products)))");
        return responseEntity;
    }

    @GetMapping(value={"/products/{id}"})
    @NotNull
    public ResponseEntity<ProductHateOasResource> getProduct(@PathVariable long id) {
        Optional product;
        this.log.debug("REST request to get Product : {}", (Object)id);
        Optional optional = product = this.productRepository.findById((Object)id);
        Intrinsics.checkExpressionValueIsNotNull((Object)optional, (String)"product");
        if (optional.isPresent()) {
            Object t = product.get();
            Intrinsics.checkExpressionValueIsNotNull(t, (String)"product.get()");
            ResponseEntity responseEntity = ResponseUtil.wrapOrNotFound(Optional.of(new ProductHateOasResource((Product)t)));
            Intrinsics.checkExpressionValueIsNotNull((Object)responseEntity, (String)"ResponseUtil.wrapOrNotFo\u2026Resource(product.get())))");
            return responseEntity;
        }
        ResponseEntity responseEntity = ResponseUtil.wrapOrNotFound(Optional.empty());
        Intrinsics.checkExpressionValueIsNotNull((Object)responseEntity, (String)"ResponseUtil.wrapOrNotFound(Optional.empty())");
        return responseEntity;
    }

    @DeleteMapping(value={"/products/{id}"})
    @NotNull
    public ResponseEntity<Void> deleteProduct(@PathVariable long id) {
        this.log.debug("REST request to delete Product : {}", (Object)id);
        this.productRepository.deleteById((Object)id);
        ResponseEntity responseEntity = ResponseEntity.noContent().headers(HeaderUtil.createEntityDeletionAlert((String)this.applicationName, (boolean)true, (String)"product", (String)String.valueOf(id))).build();
        Intrinsics.checkExpressionValueIsNotNull((Object)responseEntity, (String)"ResponseEntity.noContent\u2026, id.toString())).build()");
        return responseEntity;
    }

    public ProductResource(@NotNull ProductRepository productRepository) {
        Intrinsics.checkParameterIsNotNull((Object)productRepository, (String)"productRepository");
        this.productRepository = productRepository;
        this.log = LoggerFactory.getLogger(this.getClass());
    }
}

