/*
 * Decompiled with CFR 0.152.
 */
package com.shiftphones.shifternetzwerk.web.rest;

import com.shiftphones.shifternetzwerk.domain.Telephonenumber;
import com.shiftphones.shifternetzwerk.domain.UserDialogTelephoneNumber;
import com.shiftphones.shifternetzwerk.domain.Userprofile;
import com.shiftphones.shifternetzwerk.hateoas.TelefonnumberHateOasResource;
import com.shiftphones.shifternetzwerk.repository.TelephonenumberRepository;
import com.shiftphones.shifternetzwerk.service.TelefonService;
import com.shiftphones.shifternetzwerk.web.rest.ResourceHelperService;
import com.shiftphones.shifternetzwerk.web.rest.errors.BadRequestAlertException;
import io.github.jhipster.web.util.HeaderUtil;
import io.github.jhipster.web.util.ResponseUtil;
import java.net.URI;
import java.util.Optional;
import javax.validation.Valid;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.http.ResponseEntity;
import org.springframework.security.access.prepost.PreAuthorize;
import org.springframework.transaction.annotation.Transactional;
import org.springframework.web.bind.annotation.DeleteMapping;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.PutMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(value={"/api"})
@Metadata(mv={1, 1, 16}, bv={1, 0, 3}, k=1, d1={"\u0000P\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\t\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u0017\u0018\u00002\u00020\u0001B\u001d\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u00a2\u0006\u0002\u0010\bJ\u0018\u0010\u000e\u001a\b\u0012\u0004\u0012\u00020\u00100\u000f2\b\b\u0001\u0010\u0011\u001a\u00020\u0012H\u0017J\u0018\u0010\u0013\u001a\b\u0012\u0004\u0012\u00020\u00140\u000f2\b\b\u0001\u0010\u0015\u001a\u00020\u0016H\u0017J\u0018\u0010\u0017\u001a\b\u0012\u0004\u0012\u00020\u00180\u000f2\b\b\u0001\u0010\u0015\u001a\u00020\u0016H\u0017J\u0018\u0010\u0019\u001a\b\u0012\u0004\u0012\u00020\u00100\u000f2\b\b\u0001\u0010\u0011\u001a\u00020\u0010H\u0017R\u0014\u0010\t\u001a\u0004\u0018\u00010\n8\u0012@\u0012X\u0093\u000e\u00a2\u0006\u0002\n\u0000R\u0016\u0010\u000b\u001a\n \r*\u0004\u0018\u00010\f0\fX\u0092\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0007X\u0092\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0004\u001a\u00020\u0005X\u0092\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0002\u001a\u00020\u0003X\u0092\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u001a"}, d2={"Lcom/shiftphones/shifternetzwerk/web/rest/TelephonenumberResource;", "", "telephonenumberRepository", "Lcom/shiftphones/shifternetzwerk/repository/TelephonenumberRepository;", "telefonService", "Lcom/shiftphones/shifternetzwerk/service/TelefonService;", "resourceHelperService", "Lcom/shiftphones/shifternetzwerk/web/rest/ResourceHelperService;", "(Lcom/shiftphones/shifternetzwerk/repository/TelephonenumberRepository;Lcom/shiftphones/shifternetzwerk/service/TelefonService;Lcom/shiftphones/shifternetzwerk/web/rest/ResourceHelperService;)V", "applicationName", "", "log", "Lorg/slf4j/Logger;", "kotlin.jvm.PlatformType", "createTelephonenumber", "Lorg/springframework/http/ResponseEntity;", "Lcom/shiftphones/shifternetzwerk/domain/Telephonenumber;", "telephonenumber", "Lcom/shiftphones/shifternetzwerk/domain/UserDialogTelephoneNumber;", "deleteTelephonenumber", "Ljava/lang/Void;", "id", "", "getTelephonenumber", "Lcom/shiftphones/shifternetzwerk/hateoas/TelefonnumberHateOasResource;", "updateTelephonenumber", "shifternetzwerk"})
public class TelephonenumberResource {
    private final Logger log;
    @Value(value="${jhipster.clientApp.name}")
    private String applicationName;
    private final TelephonenumberRepository telephonenumberRepository;
    private final TelefonService telefonService;
    private final ResourceHelperService resourceHelperService;

    @PostMapping(value={"/telephonenumbers"})
    @NotNull
    public ResponseEntity<Telephonenumber> createTelephonenumber(@RequestBody @NotNull UserDialogTelephoneNumber telephonenumber) {
        Intrinsics.checkParameterIsNotNull((Object)telephonenumber, (String)"telephonenumber");
        this.log.debug("REST request to save Telephonenumber : {}", (Object)telephonenumber);
        if (telephonenumber.getId() != null) {
            throw (Throwable)new BadRequestAlertException("A new telephonenumber cannot already have an ID", "telephonenumber", "idexists");
        }
        this.resourceHelperService.isCurrentUserPowerUserOrGivenUserAndThrow(telephonenumber.getUserProfileId());
        Telephonenumber result = this.telefonService.createTelefonnumberByUser(telephonenumber);
        ResponseEntity responseEntity = ((ResponseEntity.BodyBuilder)ResponseEntity.created((URI)new URI("/api/telephonenumbers/" + result.getId())).headers(HeaderUtil.createEntityCreationAlert((String)this.applicationName, (boolean)true, (String)"telephonenumber", (String)String.valueOf(result.getId())))).body((Object)result);
        Intrinsics.checkExpressionValueIsNotNull((Object)responseEntity, (String)"ResponseEntity.created(U\u2026            .body(result)");
        return responseEntity;
    }

    @PreAuthorize(value="hasRole(\"ROLE_POWERUSER\")")
    @PutMapping(value={"/telephonenumbers"})
    @Transactional
    @NotNull
    public ResponseEntity<Telephonenumber> updateTelephonenumber(@Valid @RequestBody @NotNull Telephonenumber telephonenumber) {
        Intrinsics.checkParameterIsNotNull((Object)telephonenumber, (String)"telephonenumber");
        this.log.debug("REST request to update Telephonenumber : {}", (Object)telephonenumber);
        if (telephonenumber.getId() == null) {
            throw (Throwable)new BadRequestAlertException("Invalid id", "telephonenumber", "idnull");
        }
        Userprofile userprofile = telephonenumber.getUser();
        if (userprofile == null) {
            Intrinsics.throwNpe();
        }
        String string = userprofile.getId();
        if (string == null) {
            Intrinsics.throwNpe();
        }
        this.resourceHelperService.isCurrentUserPowerUserOrGivenUserAndThrow(string);
        Telephonenumber result = (Telephonenumber)this.telephonenumberRepository.save((Object)telephonenumber);
        ResponseEntity responseEntity = ((ResponseEntity.BodyBuilder)ResponseEntity.ok().headers(HeaderUtil.createEntityUpdateAlert((String)this.applicationName, (boolean)true, (String)"telephonenumber", (String)String.valueOf(telephonenumber.getId())))).body((Object)result);
        Intrinsics.checkExpressionValueIsNotNull((Object)responseEntity, (String)"ResponseEntity.ok()\n    \u2026            .body(result)");
        return responseEntity;
    }

    @GetMapping(value={"/telephonenumbers/{id}"})
    @Transactional(readOnly=true)
    @NotNull
    public ResponseEntity<TelefonnumberHateOasResource> getTelephonenumber(@PathVariable long id) {
        Optional telephonenumber;
        this.log.debug("REST request to get Telephonenumber : {}", (Object)id);
        Optional optional = telephonenumber = this.telephonenumberRepository.findById((Object)id);
        Intrinsics.checkExpressionValueIsNotNull((Object)optional, (String)"telephonenumber");
        if (optional.isPresent()) {
            Userprofile userprofile = ((Telephonenumber)telephonenumber.get()).getUser();
            if (userprofile == null) {
                Intrinsics.throwNpe();
            }
            String string = userprofile.getId();
            if (string == null) {
                Intrinsics.throwNpe();
            }
            this.resourceHelperService.isCurrentUserPowerUserOrGivenUserAndThrow(string);
            Object t = telephonenumber.get();
            Intrinsics.checkExpressionValueIsNotNull(t, (String)"telephonenumber.get()");
            ResponseEntity responseEntity = ResponseUtil.wrapOrNotFound(Optional.of(new TelefonnumberHateOasResource((Telephonenumber)t)));
            Intrinsics.checkExpressionValueIsNotNull((Object)responseEntity, (String)"ResponseUtil.wrapOrNotFo\u2026(telephonenumber.get())))");
            return responseEntity;
        }
        ResponseEntity responseEntity = ResponseUtil.wrapOrNotFound(Optional.empty());
        Intrinsics.checkExpressionValueIsNotNull((Object)responseEntity, (String)"ResponseUtil.wrapOrNotFound(Optional.empty())");
        return responseEntity;
    }

    @DeleteMapping(value={"/telephonenumbers/{id}"})
    @Transactional
    @NotNull
    public ResponseEntity<Void> deleteTelephonenumber(@PathVariable long id) {
        this.log.debug("REST request to delete Telephonenumber : {}", (Object)id);
        Userprofile userprofile = ((Telephonenumber)this.telephonenumberRepository.findById((Object)id).get()).getUser();
        if (userprofile == null) {
            Intrinsics.throwNpe();
        }
        String string = userprofile.getId();
        if (string == null) {
            Intrinsics.throwNpe();
        }
        this.resourceHelperService.isCurrentUserPowerUserOrGivenUserAndThrow(string);
        this.telephonenumberRepository.deleteById((Object)id);
        ResponseEntity responseEntity = ResponseEntity.noContent().headers(HeaderUtil.createEntityDeletionAlert((String)this.applicationName, (boolean)true, (String)"telephonenumber", (String)String.valueOf(id))).build();
        Intrinsics.checkExpressionValueIsNotNull((Object)responseEntity, (String)"ResponseEntity.noContent\u2026, id.toString())).build()");
        return responseEntity;
    }

    public TelephonenumberResource(@NotNull TelephonenumberRepository telephonenumberRepository, @NotNull TelefonService telefonService, @NotNull ResourceHelperService resourceHelperService) {
        Intrinsics.checkParameterIsNotNull((Object)telephonenumberRepository, (String)"telephonenumberRepository");
        Intrinsics.checkParameterIsNotNull((Object)telefonService, (String)"telefonService");
        Intrinsics.checkParameterIsNotNull((Object)resourceHelperService, (String)"resourceHelperService");
        this.telephonenumberRepository = telephonenumberRepository;
        this.telefonService = telefonService;
        this.resourceHelperService = resourceHelperService;
        this.log = LoggerFactory.getLogger(this.getClass());
    }
}

