/*
 * Decompiled with CFR 0.152.
 */
package com.shiftphones.shifternetzwerk.web.rest;

import com.shiftphones.shifternetzwerk.domain.UserFavourite;
import com.shiftphones.shifternetzwerk.domain.Userprofile;
import com.shiftphones.shifternetzwerk.hateoas.ShortUserProfile;
import com.shiftphones.shifternetzwerk.hateoas.UserprofileHateOasResource;
import com.shiftphones.shifternetzwerk.repository.ShifterRepository;
import com.shiftphones.shifternetzwerk.repository.UserprofileRepository;
import com.shiftphones.shifternetzwerk.web.rest.ResourceHelperService;
import com.shiftphones.shifternetzwerk.web.rest.errors.BadRequestAlertException;
import io.github.jhipster.web.util.HeaderUtil;
import io.github.jhipster.web.util.ResponseUtil;
import java.net.URI;
import java.util.Optional;
import java.util.function.Consumer;
import javax.validation.Valid;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.Ref;
import org.jetbrains.annotations.NotNull;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.data.repository.CrudRepository;
import org.springframework.data.repository.CrudRepositoryExtensionsKt;
import org.springframework.http.ResponseEntity;
import org.springframework.transaction.annotation.Transactional;
import org.springframework.web.bind.annotation.DeleteMapping;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.PutMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(value={"/api"})
@Metadata(mv={1, 1, 16}, bv={1, 0, 3}, k=1, d1={"\u0000P\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\b\u0017\u0018\u00002\u00020\u0001B\u001d\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u00a2\u0006\u0002\u0010\bJ\u0018\u0010\u000e\u001a\b\u0012\u0004\u0012\u00020\u00100\u000f2\b\b\u0001\u0010\u0011\u001a\u00020\u0010H\u0017J\u0018\u0010\u0012\u001a\b\u0012\u0004\u0012\u00020\u00100\u000f2\b\b\u0001\u0010\u0011\u001a\u00020\u0010H\u0017J\u0018\u0010\u0013\u001a\b\u0012\u0004\u0012\u00020\u00140\u000f2\b\b\u0001\u0010\u0015\u001a\u00020\nH\u0017J\u0018\u0010\u0016\u001a\b\u0012\u0004\u0012\u00020\u00170\u000f2\b\b\u0001\u0010\u0015\u001a\u00020\nH\u0017J\u0018\u0010\u0018\u001a\b\u0012\u0004\u0012\u00020\u00170\u000f2\b\b\u0001\u0010\u0019\u001a\u00020\u001aH\u0017J\u0018\u0010\u001b\u001a\b\u0012\u0004\u0012\u00020\u00170\u000f2\b\b\u0001\u0010\u0019\u001a\u00020\u001aH\u0017J\u0018\u0010\u001c\u001a\b\u0012\u0004\u0012\u00020\u00100\u000f2\b\b\u0001\u0010\u0011\u001a\u00020\u0010H\u0017R\u0014\u0010\t\u001a\u0004\u0018\u00010\n8\u0012@\u0012X\u0093\u000e\u00a2\u0006\u0002\n\u0000R\u0016\u0010\u000b\u001a\n \r*\u0004\u0018\u00010\f0\fX\u0092\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0004\u001a\u00020\u0005X\u0092\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0007X\u0092\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0002\u001a\u00020\u0003X\u0092\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u001d"}, d2={"Lcom/shiftphones/shifternetzwerk/web/rest/UserprofileResource;", "", "userprofileRepository", "Lcom/shiftphones/shifternetzwerk/repository/UserprofileRepository;", "resourceHelperService", "Lcom/shiftphones/shifternetzwerk/web/rest/ResourceHelperService;", "shifterRepository", "Lcom/shiftphones/shifternetzwerk/repository/ShifterRepository;", "(Lcom/shiftphones/shifternetzwerk/repository/UserprofileRepository;Lcom/shiftphones/shifternetzwerk/web/rest/ResourceHelperService;Lcom/shiftphones/shifternetzwerk/repository/ShifterRepository;)V", "applicationName", "", "log", "Lorg/slf4j/Logger;", "kotlin.jvm.PlatformType", "createUserprofile", "Lorg/springframework/http/ResponseEntity;", "Lcom/shiftphones/shifternetzwerk/domain/Userprofile;", "userprofile", "createUserprofileOnlyForMigration", "deleteUserprofile", "Ljava/lang/Void;", "id", "getUserprofile", "Lcom/shiftphones/shifternetzwerk/hateoas/UserprofileHateOasResource;", "putFavouriteShifterInUserProfile", "favrourite", "Lcom/shiftphones/shifternetzwerk/domain/UserFavourite;", "removeFavouriteShifterInUserProfile", "updateUserprofile", "shifternetzwerk"})
public class UserprofileResource {
    private final Logger log;
    @Value(value="${jhipster.clientApp.name}")
    private String applicationName;
    private final UserprofileRepository userprofileRepository;
    private final ResourceHelperService resourceHelperService;
    private final ShifterRepository shifterRepository;

    @PostMapping(value={"/userprofiles"})
    @NotNull
    public ResponseEntity<Userprofile> createUserprofile(@Valid @RequestBody @NotNull Userprofile userprofile) {
        Intrinsics.checkParameterIsNotNull((Object)userprofile, (String)"userprofile");
        this.log.debug("REST request to save Userprofile : {}", (Object)userprofile);
        if (userprofile.getId() != null) {
            throw (Throwable)new BadRequestAlertException("A new userprofile cannot already have an ID", "userprofile", "idexists");
        }
        String userId = this.resourceHelperService.getUserId();
        Userprofile userprofile2 = (Userprofile)CrudRepositoryExtensionsKt.findByIdOrNull((CrudRepository)((CrudRepository)this.userprofileRepository), (Object)userId);
        if (userprofile2 != null) {
            Userprofile userprofile3 = userprofile2;
            boolean bl = false;
            boolean bl2 = false;
            Userprofile it = userprofile3;
            boolean bl3 = false;
            throw (Throwable)new BadRequestAlertException("The current user has already a userprofile", "userprofile", "userprofileidexists");
        }
        userprofile.setId(userId);
        Userprofile result = (Userprofile)this.userprofileRepository.save((Object)userprofile);
        ResponseEntity responseEntity = ((ResponseEntity.BodyBuilder)ResponseEntity.created((URI)new URI("/api/userprofiles/" + result.getId())).headers(HeaderUtil.createEntityCreationAlert((String)this.applicationName, (boolean)true, (String)"userprofile", (String)String.valueOf(result.getId())))).body((Object)result);
        Intrinsics.checkExpressionValueIsNotNull((Object)responseEntity, (String)"ResponseEntity.created(U\u2026            .body(result)");
        return responseEntity;
    }

    @PostMapping(value={"/userprofilesMigration"})
    @NotNull
    public ResponseEntity<Userprofile> createUserprofileOnlyForMigration(@Valid @RequestBody @NotNull Userprofile userprofile) {
        Intrinsics.checkParameterIsNotNull((Object)userprofile, (String)"userprofile");
        this.log.error("REST request createUserprofileOnlyForMigration only in dev or test: {}", (Object)userprofile);
        String userId = userprofile.getEmailAddress();
        Userprofile userprofile2 = (Userprofile)CrudRepositoryExtensionsKt.findByIdOrNull((CrudRepository)((CrudRepository)this.userprofileRepository), (Object)userId);
        if (userprofile2 != null) {
            Userprofile userprofile3 = userprofile2;
            boolean bl = false;
            boolean bl2 = false;
            Userprofile it = userprofile3;
            boolean bl3 = false;
            throw (Throwable)new BadRequestAlertException("The current user has already a userprofile", "userprofile", "userprofileidexists");
        }
        userprofile.setId(userId);
        Userprofile result = (Userprofile)this.userprofileRepository.save((Object)userprofile);
        ResponseEntity responseEntity = ((ResponseEntity.BodyBuilder)ResponseEntity.created((URI)new URI("/api/userprofiles/" + result.getId())).headers(HeaderUtil.createEntityCreationAlert((String)this.applicationName, (boolean)true, (String)"userprofile", (String)String.valueOf(result.getId())))).body((Object)result);
        Intrinsics.checkExpressionValueIsNotNull((Object)responseEntity, (String)"ResponseEntity.created(U\u2026            .body(result)");
        return responseEntity;
    }

    /*
     * WARNING - void declaration
     */
    @Transactional
    @PutMapping(value={"/userprofiles/favourite/add"})
    @NotNull
    public ResponseEntity<UserprofileHateOasResource> putFavouriteShifterInUserProfile(@RequestBody @NotNull UserFavourite favrourite) {
        void result;
        Intrinsics.checkParameterIsNotNull((Object)favrourite, (String)"favrourite");
        this.log.debug("REST putFavouriteShifterInUserProfile to save favourite : {}", (Object)favrourite);
        Ref.ObjectRef objectRef = new Ref.ObjectRef();
        objectRef.element = null;
        this.resourceHelperService.isCurrentUserPowerUserOrGivenUserAndThrow(favrourite.getUserProfileId());
        Optional optional = this.userprofileRepository.findById((Object)favrourite.getUserProfileId());
        if (optional != null) {
            optional.ifPresent((Consumer)new /* Unavailable Anonymous Inner Class!! */);
        }
        UserprofileHateOasResource userprofileHateOasResource = (UserprofileHateOasResource)result.element;
        if (userprofileHateOasResource != null) {
            UserprofileHateOasResource userprofileHateOasResource2 = userprofileHateOasResource;
            boolean bl = false;
            boolean bl2 = false;
            UserprofileHateOasResource it = userprofileHateOasResource2;
            boolean bl3 = false;
            ResponseEntity responseEntity = ResponseEntity.ok((Object)it);
            Intrinsics.checkExpressionValueIsNotNull((Object)responseEntity, (String)"ResponseEntity.ok(it)");
            return responseEntity;
        }
        ResponseEntity responseEntity = ResponseUtil.wrapOrNotFound(Optional.empty());
        Intrinsics.checkExpressionValueIsNotNull((Object)responseEntity, (String)"ResponseUtil.wrapOrNotFound(Optional.empty())");
        return responseEntity;
    }

    @PutMapping(value={"/userprofiles"})
    @NotNull
    public ResponseEntity<Userprofile> updateUserprofile(@Valid @RequestBody @NotNull Userprofile userprofile) {
        Intrinsics.checkParameterIsNotNull((Object)userprofile, (String)"userprofile");
        this.log.debug("REST request to update Userprofile : {}", (Object)userprofile);
        if (userprofile.getId() == null) {
            throw (Throwable)new BadRequestAlertException("Invalid id", "userprofile", "idnull");
        }
        String string = userprofile.getId();
        if (string == null) {
            Intrinsics.throwNpe();
        }
        this.resourceHelperService.isCurrentUserPowerUserOrGivenUserAndThrow(string);
        Userprofile result = (Userprofile)this.userprofileRepository.save((Object)userprofile);
        ResponseEntity responseEntity = ((ResponseEntity.BodyBuilder)ResponseEntity.ok().headers(HeaderUtil.createEntityUpdateAlert((String)this.applicationName, (boolean)true, (String)"userprofile", (String)String.valueOf(userprofile.getId())))).body((Object)result);
        Intrinsics.checkExpressionValueIsNotNull((Object)responseEntity, (String)"ResponseEntity.ok()\n    \u2026            .body(result)");
        return responseEntity;
    }

    /*
     * WARNING - void declaration
     */
    @Transactional
    @PutMapping(value={"/userprofiles/favourite/remove"})
    @NotNull
    public ResponseEntity<UserprofileHateOasResource> removeFavouriteShifterInUserProfile(@RequestBody @NotNull UserFavourite favrourite) {
        void result;
        Intrinsics.checkParameterIsNotNull((Object)favrourite, (String)"favrourite");
        this.log.debug("REST putFavouriteShifterInUserProfile to save favourite : {}", (Object)favrourite);
        Ref.ObjectRef objectRef = new Ref.ObjectRef();
        objectRef.element = null;
        this.resourceHelperService.isCurrentUserPowerUserOrGivenUserAndThrow(favrourite.getUserProfileId());
        Optional optional = this.userprofileRepository.findById((Object)favrourite.getUserProfileId());
        if (optional != null) {
            optional.ifPresent((Consumer)new /* Unavailable Anonymous Inner Class!! */);
        }
        UserprofileHateOasResource userprofileHateOasResource = (UserprofileHateOasResource)result.element;
        if (userprofileHateOasResource != null) {
            UserprofileHateOasResource userprofileHateOasResource2 = userprofileHateOasResource;
            boolean bl = false;
            boolean bl2 = false;
            UserprofileHateOasResource it = userprofileHateOasResource2;
            boolean bl3 = false;
            ResponseEntity responseEntity = ResponseEntity.ok((Object)it);
            Intrinsics.checkExpressionValueIsNotNull((Object)responseEntity, (String)"ResponseEntity.ok(it)");
            return responseEntity;
        }
        ResponseEntity responseEntity = ResponseUtil.wrapOrNotFound(Optional.empty());
        Intrinsics.checkExpressionValueIsNotNull((Object)responseEntity, (String)"ResponseUtil.wrapOrNotFound(Optional.empty())");
        return responseEntity;
    }

    @GetMapping(value={"/userprofiles/{id}"})
    @Transactional
    @NotNull
    public ResponseEntity<UserprofileHateOasResource> getUserprofile(@PathVariable @NotNull String id) {
        Optional userprofile;
        Intrinsics.checkParameterIsNotNull((Object)id, (String)"id");
        this.log.debug("REST request to get Userprofile : {}", (Object)id);
        this.resourceHelperService.isCurrentUserPowerUserOrGivenUserAndThrow(id);
        Optional optional = userprofile = this.userprofileRepository.findById((Object)id);
        Intrinsics.checkExpressionValueIsNotNull((Object)optional, (String)"userprofile");
        if (optional.isPresent()) {
            Object t = userprofile.get();
            Intrinsics.checkExpressionValueIsNotNull(t, (String)"userprofile.get()");
            ResponseEntity responseEntity = ResponseUtil.wrapOrNotFound(Optional.of(new UserprofileHateOasResource(new ShortUserProfile((Userprofile)t))));
            Intrinsics.checkExpressionValueIsNotNull((Object)responseEntity, (String)"ResponseUtil.wrapOrNotFo\u2026ile(userprofile.get()))))");
            return responseEntity;
        }
        ResponseEntity responseEntity = ResponseUtil.wrapOrNotFound(Optional.empty());
        Intrinsics.checkExpressionValueIsNotNull((Object)responseEntity, (String)"ResponseUtil.wrapOrNotFound(Optional.empty())");
        return responseEntity;
    }

    @DeleteMapping(value={"/userprofiles/{id}"})
    @NotNull
    public ResponseEntity<Void> deleteUserprofile(@PathVariable @NotNull String id) {
        Intrinsics.checkParameterIsNotNull((Object)id, (String)"id");
        this.log.debug("REST request to delete Userprofile : {}", (Object)id);
        this.resourceHelperService.isCurrentUserPowerUserOrGivenUserAndThrow(id);
        this.userprofileRepository.deleteById((Object)id);
        ResponseEntity responseEntity = ResponseEntity.noContent().headers(HeaderUtil.createEntityDeletionAlert((String)this.applicationName, (boolean)true, (String)"userprofile", (String)id.toString())).build();
        Intrinsics.checkExpressionValueIsNotNull((Object)responseEntity, (String)"ResponseEntity.noContent\u2026, id.toString())).build()");
        return responseEntity;
    }

    public UserprofileResource(@NotNull UserprofileRepository userprofileRepository, @NotNull ResourceHelperService resourceHelperService, @NotNull ShifterRepository shifterRepository) {
        Intrinsics.checkParameterIsNotNull((Object)userprofileRepository, (String)"userprofileRepository");
        Intrinsics.checkParameterIsNotNull((Object)resourceHelperService, (String)"resourceHelperService");
        Intrinsics.checkParameterIsNotNull((Object)shifterRepository, (String)"shifterRepository");
        this.userprofileRepository = userprofileRepository;
        this.resourceHelperService = resourceHelperService;
        this.shifterRepository = shifterRepository;
        this.log = LoggerFactory.getLogger(this.getClass());
    }

    public static final /* synthetic */ ShifterRepository access$getShifterRepository$p(UserprofileResource $this) {
        return $this.shifterRepository;
    }

    public static final /* synthetic */ UserprofileRepository access$getUserprofileRepository$p(UserprofileResource $this) {
        return $this.userprofileRepository;
    }
}

