/*
 * Decompiled with CFR 0.152.
 */
package com.shiftphones.shifternetzwerk.config;

import com.shiftphones.shifternetzwerk.config.SecurityConfiguration;
import com.shiftphones.shifternetzwerk.security.oauth2.AudienceValidator;
import com.shiftphones.shifternetzwerk.security.oauth2.JwtGrantedAuthorityConverter;
import io.github.jhipster.config.JHipsterProperties;
import java.util.List;
import javax.servlet.Filter;
import kotlin.Metadata;
import kotlin.TypeCastException;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Import;
import org.springframework.core.convert.converter.Converter;
import org.springframework.http.HttpMethod;
import org.springframework.security.authentication.AbstractAuthenticationToken;
import org.springframework.security.config.annotation.method.configuration.EnableGlobalMethodSecurity;
import org.springframework.security.config.annotation.web.builders.HttpSecurity;
import org.springframework.security.config.annotation.web.builders.WebSecurity;
import org.springframework.security.config.annotation.web.configuration.EnableWebSecurity;
import org.springframework.security.config.annotation.web.configuration.WebSecurityConfigurerAdapter;
import org.springframework.security.config.annotation.web.configurers.ExpressionUrlAuthorizationConfigurer;
import org.springframework.security.core.authority.mapping.GrantedAuthoritiesMapper;
import org.springframework.security.oauth2.core.DelegatingOAuth2TokenValidator;
import org.springframework.security.oauth2.core.OAuth2TokenValidator;
import org.springframework.security.oauth2.jwt.Jwt;
import org.springframework.security.oauth2.jwt.JwtDecoder;
import org.springframework.security.oauth2.jwt.JwtDecoders;
import org.springframework.security.oauth2.jwt.JwtValidators;
import org.springframework.security.oauth2.jwt.NimbusJwtDecoder;
import org.springframework.security.oauth2.server.resource.authentication.JwtAuthenticationConverter;
import org.springframework.security.web.AuthenticationEntryPoint;
import org.springframework.security.web.access.AccessDeniedHandler;
import org.springframework.security.web.csrf.CookieCsrfTokenRepository;
import org.springframework.security.web.csrf.CsrfFilter;
import org.springframework.security.web.csrf.CsrfTokenRepository;
import org.springframework.security.web.header.writers.ReferrerPolicyHeaderWriter;
import org.springframework.web.filter.CorsFilter;
import org.zalando.problem.spring.web.advice.security.SecurityProblemSupport;

@EnableWebSecurity
@EnableGlobalMethodSecurity(prePostEnabled=true, securedEnabled=true)
@Import(value={SecurityProblemSupport.class})
@Metadata(mv={1, 1, 16}, bv={1, 0, 3}, k=1, d1={"\u0000P\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\b\u0017\u0018\u00002\u00020\u0001B\u001d\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u00a2\u0006\u0002\u0010\bJ\u0014\u0010\u000b\u001a\u000e\u0012\u0004\u0012\u00020\r\u0012\u0004\u0012\u00020\u000e0\fH\u0016J\u0010\u0010\u000f\u001a\u00020\u00102\u0006\u0010\u0011\u001a\u00020\u0012H\u0016J\u0012\u0010\u000f\u001a\u00020\u00102\b\u0010\u0013\u001a\u0004\u0018\u00010\u0014H\u0016J\b\u0010\u0015\u001a\u00020\u0016H\u0017J\b\u0010\u0017\u001a\u00020\u0018H\u0017R\u000e\u0010\u0002\u001a\u00020\u0003X\u0092\u0004\u00a2\u0006\u0002\n\u0000R\u0012\u0010\t\u001a\u00020\n8\u0012@\u0012X\u0093.\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0004\u001a\u00020\u0005X\u0092\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0007X\u0092\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0019"}, d2={"Lcom/shiftphones/shifternetzwerk/config/SecurityConfiguration;", "Lorg/springframework/security/config/annotation/web/configuration/WebSecurityConfigurerAdapter;", "corsFilter", "Lorg/springframework/web/filter/CorsFilter;", "jHipsterProperties", "Lio/github/jhipster/config/JHipsterProperties;", "problemSupport", "Lorg/zalando/problem/spring/web/advice/security/SecurityProblemSupport;", "(Lorg/springframework/web/filter/CorsFilter;Lio/github/jhipster/config/JHipsterProperties;Lorg/zalando/problem/spring/web/advice/security/SecurityProblemSupport;)V", "issuerUri", "", "authenticationConverter", "Lorg/springframework/core/convert/converter/Converter;", "Lorg/springframework/security/oauth2/jwt/Jwt;", "Lorg/springframework/security/authentication/AbstractAuthenticationToken;", "configure", "", "http", "Lorg/springframework/security/config/annotation/web/builders/HttpSecurity;", "web", "Lorg/springframework/security/config/annotation/web/builders/WebSecurity;", "jwtDecoder", "Lorg/springframework/security/oauth2/jwt/JwtDecoder;", "userAuthoritiesMapper", "Lorg/springframework/security/core/authority/mapping/GrantedAuthoritiesMapper;", "shifternetzwerk"})
public class SecurityConfiguration
extends WebSecurityConfigurerAdapter {
    @Value(value="${spring.security.oauth2.client.provider.oidc.issuer-uri}")
    private String issuerUri;
    private final CorsFilter corsFilter;
    private final JHipsterProperties jHipsterProperties;
    private final SecurityProblemSupport problemSupport;

    public void configure(@Nullable WebSecurity web) {
        WebSecurity webSecurity = web;
        if (webSecurity == null) {
            Intrinsics.throwNpe();
        }
        ((WebSecurity.IgnoredRequestConfigurer)((WebSecurity.IgnoredRequestConfigurer)((WebSecurity.IgnoredRequestConfigurer)((WebSecurity.IgnoredRequestConfigurer)((WebSecurity.IgnoredRequestConfigurer)webSecurity.ignoring().antMatchers(HttpMethod.OPTIONS, new String[]{"/**"})).antMatchers(new String[]{"/app/**/*.{js,html}"})).antMatchers(new String[]{"/i18n/**"})).antMatchers(new String[]{"/content/**"})).antMatchers(new String[]{"/swagger-ui/index.html"})).antMatchers(new String[]{"/test/**"});
    }

    public void configure(@NotNull HttpSecurity http) throws Exception {
        Intrinsics.checkParameterIsNotNull((Object)http, (String)"http");
        ((HttpSecurity)((HttpSecurity)((HttpSecurity)((ExpressionUrlAuthorizationConfigurer.AuthorizedUrl)((ExpressionUrlAuthorizationConfigurer.AuthorizedUrl)((ExpressionUrlAuthorizationConfigurer.AuthorizedUrl)((ExpressionUrlAuthorizationConfigurer.AuthorizedUrl)((ExpressionUrlAuthorizationConfigurer.AuthorizedUrl)((ExpressionUrlAuthorizationConfigurer.AuthorizedUrl)((ExpressionUrlAuthorizationConfigurer.AuthorizedUrl)((ExpressionUrlAuthorizationConfigurer.AuthorizedUrl)((ExpressionUrlAuthorizationConfigurer.AuthorizedUrl)((ExpressionUrlAuthorizationConfigurer.AuthorizedUrl)((ExpressionUrlAuthorizationConfigurer.AuthorizedUrl)((HttpSecurity)((HttpSecurity)((HttpSecurity)http.csrf().csrfTokenRepository((CsrfTokenRepository)CookieCsrfTokenRepository.withHttpOnlyFalse()).and()).addFilterBefore((Filter)this.corsFilter, CsrfFilter.class).exceptionHandling().authenticationEntryPoint((AuthenticationEntryPoint)this.problemSupport).accessDeniedHandler((AccessDeniedHandler)this.problemSupport).and()).headers().contentSecurityPolicy("default-src 'self'; frame-src 'self' data:; script-src 'self' 'unsafe-inline' 'unsafe-eval' https://storage.googleapis.com; style-src 'self' 'unsafe-inline'; img-src 'self' data:; font-src 'self' data:").and().referrerPolicy(ReferrerPolicyHeaderWriter.ReferrerPolicy.STRICT_ORIGIN_WHEN_CROSS_ORIGIN).and().featurePolicy("geolocation 'none'; midi 'none'; sync-xhr 'none'; microphone 'none'; camera 'none'; magnetometer 'none'; gyroscope 'none'; speaker 'none'; fullscreen 'self'; payment 'none'").and().frameOptions().deny().and()).authorizeRequests().antMatchers(new String[]{"/shifter/**"})).permitAll().antMatchers(new String[]{"/api/shifter/owv/**"})).permitAll().antMatchers(new String[]{"/api/productgroups"})).permitAll().antMatchers(new String[]{"/api/products"})).permitAll().antMatchers(new String[]{"/authorize"})).authenticated().antMatchers(new String[]{"/api/auth-info"})).permitAll().antMatchers(new String[]{"/api/**"})).authenticated().antMatchers(new String[]{"/management/health"})).permitAll().antMatchers(new String[]{"/management/info"})).permitAll().antMatchers(new String[]{"/management/prometheus"})).permitAll().antMatchers(new String[]{"/management/**"})).hasAuthority("ROLE_ADMIN").and()).oauth2Login().and()).oauth2ResourceServer().jwt().jwtAuthenticationConverter(this.authenticationConverter()).and().and()).oauth2Client();
    }

    @NotNull
    public Converter<Jwt, AbstractAuthenticationToken> authenticationConverter() {
        JwtAuthenticationConverter jwtAuthenticationConverter = new JwtAuthenticationConverter();
        jwtAuthenticationConverter.setJwtGrantedAuthoritiesConverter((Converter)new JwtGrantedAuthorityConverter());
        return (Converter)jwtAuthenticationConverter;
    }

    @Bean
    @NotNull
    public GrantedAuthoritiesMapper userAuthoritiesMapper() {
        return (GrantedAuthoritiesMapper)userAuthoritiesMapper.1.INSTANCE;
    }

    @Bean
    @NotNull
    public JwtDecoder jwtDecoder() {
        String string = this.issuerUri;
        if (string == null) {
            Intrinsics.throwUninitializedPropertyAccessException((String)"issuerUri");
        }
        JwtDecoder jwtDecoder = JwtDecoders.fromOidcIssuerLocation((String)string);
        if (jwtDecoder == null) {
            throw new TypeCastException("null cannot be cast to non-null type org.springframework.security.oauth2.jwt.NimbusJwtDecoder");
        }
        NimbusJwtDecoder jwtDecoder2 = (NimbusJwtDecoder)jwtDecoder;
        JHipsterProperties.Security security = this.jHipsterProperties.getSecurity();
        Intrinsics.checkExpressionValueIsNotNull((Object)security, (String)"jHipsterProperties.security");
        JHipsterProperties.Security.OAuth2 oAuth2 = security.getOauth2();
        Intrinsics.checkExpressionValueIsNotNull((Object)oAuth2, (String)"jHipsterProperties.security.oauth2");
        List list = oAuth2.getAudience();
        Intrinsics.checkExpressionValueIsNotNull((Object)list, (String)"jHipsterProperties.security.oauth2.audience");
        AudienceValidator audienceValidator = new AudienceValidator(list);
        String string2 = this.issuerUri;
        if (string2 == null) {
            Intrinsics.throwUninitializedPropertyAccessException((String)"issuerUri");
        }
        OAuth2TokenValidator withIssuer = JwtValidators.createDefaultWithIssuer((String)string2);
        DelegatingOAuth2TokenValidator withAudience = new DelegatingOAuth2TokenValidator(new OAuth2TokenValidator[]{withIssuer, (OAuth2TokenValidator)audienceValidator});
        jwtDecoder2.setJwtValidator((OAuth2TokenValidator)withAudience);
        return (JwtDecoder)jwtDecoder2;
    }

    public SecurityConfiguration(@NotNull CorsFilter corsFilter, @NotNull JHipsterProperties jHipsterProperties, @NotNull SecurityProblemSupport problemSupport) {
        Intrinsics.checkParameterIsNotNull((Object)corsFilter, (String)"corsFilter");
        Intrinsics.checkParameterIsNotNull((Object)jHipsterProperties, (String)"jHipsterProperties");
        Intrinsics.checkParameterIsNotNull((Object)problemSupport, (String)"problemSupport");
        this.corsFilter = corsFilter;
        this.jHipsterProperties = jHipsterProperties;
        this.problemSupport = problemSupport;
    }
}

