/*
 * Decompiled with CFR 0.152.
 */
package com.shiftphones.shifternetzwerk.security;

import com.shiftphones.shifternetzwerk.security.SecurityUtils;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.function.BiConsumer;
import kotlin.Metadata;
import kotlin.TypeCastException;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.JvmName;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.springframework.security.core.Authentication;
import org.springframework.security.core.GrantedAuthority;
import org.springframework.security.core.authority.SimpleGrantedAuthority;
import org.springframework.security.core.context.SecurityContext;
import org.springframework.security.core.context.SecurityContextHolder;
import org.springframework.security.core.userdetails.UserDetails;
import org.springframework.security.oauth2.core.oidc.user.DefaultOidcUser;
import org.springframework.security.oauth2.jwt.Jwt;
import org.springframework.security.oauth2.server.resource.authentication.JwtAuthenticationToken;

/*
 * Exception performing whole class analysis ignored.
 */
@Metadata(mv={1, 1, 16}, bv={1, 0, 3}, k=2, d1={"\u00008\n\u0000\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0000\n\u0002\u0010$\n\u0002\u0010\u000e\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u001e\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0006\u001a\"\u0010\u0000\u001a\n\u0012\u0004\u0012\u00020\u0002\u0018\u00010\u00012\u0012\u0010\u0003\u001a\u000e\u0012\u0004\u0012\u00020\u0005\u0012\u0004\u0012\u00020\u00060\u0004\u001a\u0012\u0010\u0007\u001a\u0004\u0018\u00010\u00052\b\u0010\b\u001a\u0004\u0018\u00010\t\u001a\b\u0010\n\u001a\u0004\u0018\u00010\u0005\u001a\u0016\u0010\u000b\u001a\n\u0012\u0004\u0012\u00020\u0005\u0018\u00010\u00012\u0006\u0010\b\u001a\u00020\t\u001a\f\u0010\f\u001a\b\u0012\u0004\u0012\u00020\u00050\r\u001a \u0010\u000e\u001a\b\u0012\u0004\u0012\u00020\u00050\u000f2\u0012\u0010\u0003\u001a\u000e\u0012\u0004\u0012\u00020\u0005\u0012\u0004\u0012\u00020\u00060\u0004\u001a\u0006\u0010\u0010\u001a\u00020\u0011\u001a\u000e\u0010\u0012\u001a\u00020\u00112\u0006\u0010\u0013\u001a\u00020\u0005\u001a\u0006\u0010\u0014\u001a\u00020\u0011\u001a\u001a\u0010\u0015\u001a\b\u0012\u0004\u0012\u00020\u00020\u00012\f\u0010\u0016\u001a\b\u0012\u0004\u0012\u00020\u00050\u000f\u00a8\u0006\u0017"}, d2={"extractAuthorityFromClaims", "", "Lorg/springframework/security/core/GrantedAuthority;", "claims", "", "", "", "extractPrincipal", "authentication", "Lorg/springframework/security/core/Authentication;", "extractUserIdIfUnknownUser", "getAuthorities", "getCurrentUserLogin", "Ljava/util/Optional;", "getRolesFromClaims", "", "isAuthenticated", "", "isCurrentUserInRole", "authority", "isCurrentUserPowerUser", "mapRolesToGrantedAuthorities", "roles", "shifternetzwerk"})
@JvmName(name="SecurityUtils")
public final class SecurityUtils {
    @NotNull
    public static final Optional<String> getCurrentUserLogin() {
        SecurityContext securityContext = SecurityContextHolder.getContext();
        Intrinsics.checkExpressionValueIsNotNull((Object)securityContext, (String)"SecurityContextHolder.getContext()");
        Optional<String> optional = Optional.ofNullable(SecurityUtils.extractPrincipal((Authentication)securityContext.getAuthentication()));
        Intrinsics.checkExpressionValueIsNotNull(optional, (String)"Optional.ofNullable(extr\u2026ontext().authentication))");
        return optional;
    }

    @Nullable
    public static final String extractPrincipal(@Nullable Authentication authentication) {
        Object principal;
        if (authentication == null) {
            return null;
        }
        if (authentication instanceof JwtAuthenticationToken) {
            Jwt jwt = (Jwt)((JwtAuthenticationToken)authentication).getToken();
            Intrinsics.checkExpressionValueIsNotNull((Object)jwt, (String)"(authentication).token");
            Map authMap = jwt.getClaims();
            if (authMap instanceof Map && authMap.containsKey("preferred_username")) {
                return String.valueOf(authMap.get("preferred_username"));
            }
            authMap.forEach((BiConsumer)extractPrincipal.1.INSTANCE);
        }
        return (principal = authentication.getPrincipal()) instanceof UserDetails ? ((UserDetails)principal).getUsername() : (principal instanceof DefaultOidcUser ? (((DefaultOidcUser)principal).getAttributes().containsKey("preferred_username") ? String.valueOf(((DefaultOidcUser)principal).getAttributes().get("preferred_username")) : null) : (principal instanceof String ? (String)principal : null));
    }

    @Nullable
    public static final String extractUserIdIfUnknownUser() {
        SecurityContext securityContext = SecurityContextHolder.getContext();
        Intrinsics.checkExpressionValueIsNotNull((Object)securityContext, (String)"SecurityContextHolder.getContext()");
        Authentication authentication = securityContext.getAuthentication();
        if (authentication == null) {
            return null;
        }
        if (authentication instanceof JwtAuthenticationToken) {
            Jwt jwt = (Jwt)((JwtAuthenticationToken)authentication).getToken();
            Intrinsics.checkExpressionValueIsNotNull((Object)jwt, (String)"(authentication).token");
            Map authMap = jwt.getClaims();
            if (authMap instanceof Map && authMap.containsKey("preferred_username")) {
                return String.valueOf(authMap.get("sub"));
            }
            authMap.forEach((BiConsumer)extractUserIdIfUnknownUser.1.INSTANCE);
        }
        return null;
    }

    public static final boolean isAuthenticated() {
        SecurityContext securityContext = SecurityContextHolder.getContext();
        Intrinsics.checkExpressionValueIsNotNull((Object)securityContext, (String)"SecurityContextHolder.getContext()");
        Authentication authentication = securityContext.getAuthentication();
        if (authentication != null) {
            Boolean isAnonymousUser;
            Boolean bl;
            List list = SecurityUtils.getAuthorities((Authentication)authentication);
            if (list != null) {
                boolean bl2;
                block7: {
                    Iterable $this$none$iv = list;
                    boolean $i$f$none = false;
                    if ($this$none$iv instanceof Collection && ((Collection)$this$none$iv).isEmpty()) {
                        bl2 = true;
                    } else {
                        for (Object element$iv : $this$none$iv) {
                            String it = (String)element$iv;
                            boolean bl3 = false;
                            if (!Intrinsics.areEqual((Object)it, (Object)"ROLE_ANONYMOUS")) continue;
                            bl2 = false;
                            break block7;
                        }
                        bl2 = true;
                    }
                }
                bl = bl2;
            } else {
                bl = isAnonymousUser = null;
            }
            if (isAnonymousUser != null) {
                return isAnonymousUser;
            }
        }
        return false;
    }

    public static final boolean isCurrentUserPowerUser() {
        return SecurityUtils.isCurrentUserInRole((String)"ROLE_POWERUSER");
    }

    public static final boolean isCurrentUserInRole(@NotNull String authority) {
        Intrinsics.checkParameterIsNotNull((Object)authority, (String)"authority");
        SecurityContext securityContext = SecurityContextHolder.getContext();
        Intrinsics.checkExpressionValueIsNotNull((Object)securityContext, (String)"SecurityContextHolder.getContext()");
        Authentication authentication = securityContext.getAuthentication();
        if (authentication != null) {
            Boolean isUserPresent;
            Boolean bl;
            List list = SecurityUtils.getAuthorities((Authentication)authentication);
            if (list != null) {
                boolean bl2;
                block7: {
                    Iterable $this$any$iv = list;
                    boolean $i$f$any = false;
                    if ($this$any$iv instanceof Collection && ((Collection)$this$any$iv).isEmpty()) {
                        bl2 = false;
                    } else {
                        for (Object element$iv : $this$any$iv) {
                            String it = (String)element$iv;
                            boolean bl3 = false;
                            if (!Intrinsics.areEqual((Object)it, (Object)authority)) continue;
                            bl2 = true;
                            break block7;
                        }
                        bl2 = false;
                    }
                }
                bl = bl2;
            } else {
                bl = isUserPresent = null;
            }
            if (isUserPresent != null) {
                return isUserPresent;
            }
        }
        return false;
    }

    /*
     * WARNING - void declaration
     */
    @Nullable
    public static final List<String> getAuthorities(@NotNull Authentication authentication) {
        List list;
        Collection authorities;
        Collection collection;
        Intrinsics.checkParameterIsNotNull((Object)authentication, (String)"authentication");
        Authentication authentication2 = authentication;
        if (authentication2 instanceof JwtAuthenticationToken) {
            Jwt jwt = (Jwt)((JwtAuthenticationToken)authentication).getToken();
            Intrinsics.checkExpressionValueIsNotNull((Object)jwt, (String)"authentication.token");
            Map map = jwt.getClaims();
            Intrinsics.checkExpressionValueIsNotNull((Object)map, (String)"authentication.token.claims");
            collection = SecurityUtils.extractAuthorityFromClaims((Map)map);
        } else {
            collection = authentication.getAuthorities();
        }
        Collection collection2 = authorities = collection;
        if (collection2 != null) {
            void $this$mapTo$iv$iv;
            Iterable $this$map$iv = collection2;
            boolean $i$f$map = false;
            Iterable iterable = $this$map$iv;
            Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
            boolean $i$f$mapTo = false;
            for (Object item$iv$iv : $this$mapTo$iv$iv) {
                void p1;
                GrantedAuthority grantedAuthority = (GrantedAuthority)item$iv$iv;
                Collection collection3 = destination$iv$iv;
                boolean bl = false;
                String string = p1.getAuthority();
                collection3.add(string);
            }
            list = (List)destination$iv$iv;
        } else {
            list = null;
        }
        return list;
    }

    @Nullable
    public static final List<GrantedAuthority> extractAuthorityFromClaims(@NotNull Map<String, ? extends Object> claims) {
        Intrinsics.checkParameterIsNotNull(claims, (String)"claims");
        return SecurityUtils.mapRolesToGrantedAuthorities((Collection)SecurityUtils.getRolesFromClaims(claims));
    }

    @NotNull
    public static final Collection<String> getRolesFromClaims(@NotNull Map<String, ? extends Object> claims) {
        Intrinsics.checkParameterIsNotNull(claims, (String)"claims");
        String string = "roles";
        Map<String, ? extends Object> map = claims;
        String string2 = "groups";
        Map<String, ? extends Object> map2 = claims;
        boolean bl = false;
        List list = CollectionsKt.emptyList();
        Object object = map2.getOrDefault(string2, map.getOrDefault(string, list));
        if (object == null) {
            throw new TypeCastException("null cannot be cast to non-null type kotlin.collections.Collection<kotlin.String>");
        }
        return (Collection)object;
    }

    /*
     * WARNING - void declaration
     */
    @NotNull
    public static final List<GrantedAuthority> mapRolesToGrantedAuthorities(@NotNull Collection<String> roles) {
        void $this$mapTo$iv$iv;
        String it;
        Iterable $this$filterTo$iv$iv;
        Intrinsics.checkParameterIsNotNull(roles, (String)"roles");
        Iterable $this$filter$iv = roles;
        boolean $i$f$filter = false;
        Iterable iterable = $this$filter$iv;
        Collection destination$iv$iv = new ArrayList();
        boolean $i$f$filterTo = false;
        for (Object element$iv$iv : $this$filterTo$iv$iv) {
            it = (String)element$iv$iv;
            boolean bl = false;
            if (!StringsKt.startsWith$default((String)it, (String)"ROLE_", (boolean)false, (int)2, null)) continue;
            destination$iv$iv.add(element$iv$iv);
        }
        Iterable $this$map$iv = (List)destination$iv$iv;
        boolean $i$f$map = false;
        $this$filterTo$iv$iv = $this$map$iv;
        destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
        boolean $i$f$mapTo = false;
        for (Object item$iv$iv : $this$mapTo$iv$iv) {
            it = (String)item$iv$iv;
            Collection collection = destination$iv$iv;
            boolean bl = false;
            SimpleGrantedAuthority simpleGrantedAuthority = new SimpleGrantedAuthority(it);
            collection.add(simpleGrantedAuthority);
        }
        return (List)destination$iv$iv;
    }
}

