/*
 * Decompiled with CFR 0.152.
 */
package com.shiftphones.shifternetzwerk.service;

import com.shiftphones.shifternetzwerk.domain.User;
import io.github.jhipster.config.JHipsterProperties;
import java.nio.charset.StandardCharsets;
import java.util.Locale;
import javax.mail.MessagingException;
import javax.mail.internet.MimeMessage;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.context.MessageSource;
import org.springframework.mail.MailException;
import org.springframework.mail.javamail.JavaMailSender;
import org.springframework.mail.javamail.MimeMessageHelper;
import org.springframework.scheduling.annotation.Async;
import org.springframework.stereotype.Service;
import org.thymeleaf.context.Context;
import org.thymeleaf.context.IContext;
import org.thymeleaf.spring5.SpringTemplateEngine;

@Service
@Metadata(mv={1, 1, 16}, bv={1, 0, 3}, k=1, d1={"\u0000J\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000e\n\u0002\b\u0003\n\u0002\u0010\u000b\n\u0002\b\u0006\b\u0017\u0018\u00002\u00020\u0001B%\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u0012\u0006\u0010\b\u001a\u00020\t\u00a2\u0006\u0002\u0010\nJ\u0010\u0010\u000e\u001a\u00020\u000f2\u0006\u0010\u0010\u001a\u00020\u0011H\u0017J\u0010\u0010\u0012\u001a\u00020\u000f2\u0006\u0010\u0010\u001a\u00020\u0011H\u0017J0\u0010\u0013\u001a\u00020\u000f2\u0006\u0010\u0014\u001a\u00020\u00152\u0006\u0010\u0016\u001a\u00020\u00152\u0006\u0010\u0017\u001a\u00020\u00152\u0006\u0010\u0018\u001a\u00020\u00192\u0006\u0010\u001a\u001a\u00020\u0019H\u0017J \u0010\u001b\u001a\u00020\u000f2\u0006\u0010\u0010\u001a\u00020\u00112\u0006\u0010\u001c\u001a\u00020\u00152\u0006\u0010\u001d\u001a\u00020\u0015H\u0017J\u0010\u0010\u001e\u001a\u00020\u000f2\u0006\u0010\u0010\u001a\u00020\u0011H\u0017R\u000e\u0010\u0002\u001a\u00020\u0003X\u0092\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0004\u001a\u00020\u0005X\u0092\u0004\u00a2\u0006\u0002\n\u0000R\u0016\u0010\u000b\u001a\n \r*\u0004\u0018\u00010\f0\fX\u0092\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0007X\u0092\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\b\u001a\u00020\tX\u0092\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u001f"}, d2={"Lcom/shiftphones/shifternetzwerk/service/MailService;", "", "jHipsterProperties", "Lio/github/jhipster/config/JHipsterProperties;", "javaMailSender", "Lorg/springframework/mail/javamail/JavaMailSender;", "messageSource", "Lorg/springframework/context/MessageSource;", "templateEngine", "Lorg/thymeleaf/spring5/SpringTemplateEngine;", "(Lio/github/jhipster/config/JHipsterProperties;Lorg/springframework/mail/javamail/JavaMailSender;Lorg/springframework/context/MessageSource;Lorg/thymeleaf/spring5/SpringTemplateEngine;)V", "log", "Lorg/slf4j/Logger;", "kotlin.jvm.PlatformType", "sendActivationEmail", "", "user", "Lcom/shiftphones/shifternetzwerk/domain/User;", "sendCreationEmail", "sendEmail", "to", "", "subject", "content", "isMultipart", "", "isHtml", "sendEmailFromTemplate", "templateName", "titleKey", "sendPasswordResetMail", "shifternetzwerk"})
public class MailService {
    private final Logger log;
    private final JHipsterProperties jHipsterProperties;
    private final JavaMailSender javaMailSender;
    private final MessageSource messageSource;
    private final SpringTemplateEngine templateEngine;

    @Async
    public void sendEmail(@NotNull String to, @NotNull String subject, @NotNull String content, boolean isMultipart, boolean isHtml) {
        Intrinsics.checkParameterIsNotNull((Object)to, (String)"to");
        Intrinsics.checkParameterIsNotNull((Object)subject, (String)"subject");
        Intrinsics.checkParameterIsNotNull((Object)content, (String)"content");
        this.log.debug("Send email[multipart '{}' and html '{}'] to '{}' with subject '{}' and content={}", new Object[]{isMultipart, isHtml, to, subject, content});
        this.log.debug("Send email[multipart '{}' and html '{}'] to '{}' with subject '{}' and content={}", new Object[]{isMultipart, isHtml, to, subject, content});
        MimeMessage mimeMessage = this.javaMailSender.createMimeMessage();
        try {
            MimeMessageHelper mimeMessageHelper = new MimeMessageHelper(mimeMessage, isMultipart, StandardCharsets.UTF_8.name());
            boolean bl = false;
            boolean bl2 = false;
            MimeMessageHelper $this$apply = mimeMessageHelper;
            boolean bl3 = false;
            $this$apply.setTo(to);
            JHipsterProperties.Mail mail = this.jHipsterProperties.getMail();
            Intrinsics.checkExpressionValueIsNotNull((Object)mail, (String)"jHipsterProperties.mail");
            $this$apply.setFrom(mail.getFrom());
            $this$apply.setSubject(subject);
            $this$apply.setText(content, isHtml);
            this.javaMailSender.send(mimeMessage);
            this.log.debug("Sent email to User '{}'", (Object)to);
        }
        catch (MailException e) {
            this.log.warn("Email could not be sent to user '{}'", (Object)to, (Object)e);
        }
        catch (MessagingException e) {
            this.log.warn("Email could not be sent to user '{}'", (Object)to, (Object)e);
        }
    }

    @Async
    public void sendEmailFromTemplate(@NotNull User user, @NotNull String templateName, @NotNull String titleKey) {
        Intrinsics.checkParameterIsNotNull((Object)user, (String)"user");
        Intrinsics.checkParameterIsNotNull((Object)templateName, (String)"templateName");
        Intrinsics.checkParameterIsNotNull((Object)titleKey, (String)"titleKey");
        Locale locale = Locale.forLanguageTag(user.getLangKey());
        Context context = new Context(locale);
        boolean bl = false;
        boolean bl2 = false;
        Context $this$apply = context;
        boolean bl3 = false;
        $this$apply.setVariable("user", (Object)user);
        JHipsterProperties.Mail mail = this.jHipsterProperties.getMail();
        Intrinsics.checkExpressionValueIsNotNull((Object)mail, (String)"jHipsterProperties.mail");
        $this$apply.setVariable("baseUrl", (Object)mail.getBaseUrl());
        Context context2 = context;
        String content = this.templateEngine.process(templateName, (IContext)context2);
        String subject = this.messageSource.getMessage(titleKey, null, locale);
        String string = user.getEmail();
        if (string == null) {
            Intrinsics.throwNpe();
        }
        String string2 = subject;
        Intrinsics.checkExpressionValueIsNotNull((Object)string2, (String)"subject");
        String string3 = content;
        Intrinsics.checkExpressionValueIsNotNull((Object)string3, (String)"content");
        this.sendEmail(string, string2, string3, false, true);
    }

    @Async
    public void sendActivationEmail(@NotNull User user) {
        Intrinsics.checkParameterIsNotNull((Object)user, (String)"user");
        this.log.debug("Sending activation email to '{}'", (Object)user.getEmail());
        this.sendEmailFromTemplate(user, "mail/activationEmail", "email.activation.title");
    }

    @Async
    public void sendCreationEmail(@NotNull User user) {
        Intrinsics.checkParameterIsNotNull((Object)user, (String)"user");
        this.log.debug("Sending creation email to '{}'", (Object)user.getEmail());
        this.sendEmailFromTemplate(user, "mail/creationEmail", "email.activation.title");
    }

    @Async
    public void sendPasswordResetMail(@NotNull User user) {
        Intrinsics.checkParameterIsNotNull((Object)user, (String)"user");
        this.log.debug("Sending password reset email to '{}'", (Object)user.getEmail());
        this.sendEmailFromTemplate(user, "mail/passwordResetEmail", "email.reset.title");
    }

    public MailService(@NotNull JHipsterProperties jHipsterProperties, @NotNull JavaMailSender javaMailSender, @NotNull MessageSource messageSource, @NotNull SpringTemplateEngine templateEngine) {
        Intrinsics.checkParameterIsNotNull((Object)jHipsterProperties, (String)"jHipsterProperties");
        Intrinsics.checkParameterIsNotNull((Object)javaMailSender, (String)"javaMailSender");
        Intrinsics.checkParameterIsNotNull((Object)messageSource, (String)"messageSource");
        Intrinsics.checkParameterIsNotNull((Object)templateEngine, (String)"templateEngine");
        this.jHipsterProperties = jHipsterProperties;
        this.javaMailSender = javaMailSender;
        this.messageSource = messageSource;
        this.templateEngine = templateEngine;
        this.log = LoggerFactory.getLogger(this.getClass());
    }
}

