/*
 * Decompiled with CFR 0.152.
 */
package com.shiftphones.shifternetzwerk.service;

import com.shiftphones.shifternetzwerk.domain.Address;
import com.shiftphones.shifternetzwerk.domain.Offeredservice;
import com.shiftphones.shifternetzwerk.domain.Shifter;
import com.shiftphones.shifternetzwerk.domain.ShortEntityObject;
import com.shiftphones.shifternetzwerk.domain.Userprofile;
import com.shiftphones.shifternetzwerk.repository.AddressRepository;
import com.shiftphones.shifternetzwerk.repository.OfferedserviceRepository;
import com.shiftphones.shifternetzwerk.repository.ShifterRepository;
import com.shiftphones.shifternetzwerk.repository.UserprofileRepository;
import com.shiftphones.shifternetzwerk.service.ShortIdAnswer;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Optional;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

@Service
@Metadata(mv={1, 1, 16}, bv={1, 0, 3}, k=1, d1={"\u0000R\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\t\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0000\b\u0017\u0018\u00002\u00020\u0001B%\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u0012\u0006\u0010\b\u001a\u00020\t\u00a2\u0006\u0002\u0010\nJ\u0018\u0010\u0014\u001a\u00020\u00152\u0006\u0010\u0016\u001a\u00020\u00172\u0006\u0010\u0018\u001a\u00020\u0019H\u0017J\u0010\u0010\u001a\u001a\u00020\u001b2\u0006\u0010\u001c\u001a\u00020\u001dH\u0017J\u0010\u0010\u001e\u001a\u00020\u001d2\u0006\u0010\u001c\u001a\u00020\u001dH\u0012J\u0010\u0010\u001f\u001a\u00020 2\u0006\u0010\u001c\u001a\u00020\u001dH\u0017R\u0014\u0010\u0004\u001a\u00020\u0005X\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000b\u0010\fR\u0016\u0010\r\u001a\n \u000f*\u0004\u0018\u00010\u000e0\u000eX\u0092\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\b\u001a\u00020\tX\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0010\u0010\u0011R\u000e\u0010\u0002\u001a\u00020\u0003X\u0092\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u0006\u001a\u00020\u0007X\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0012\u0010\u0013\u00a8\u0006!"}, d2={"Lcom/shiftphones/shifternetzwerk/service/ShifterService;", "", "shifterRepository", "Lcom/shiftphones/shifternetzwerk/repository/ShifterRepository;", "addressRepository", "Lcom/shiftphones/shifternetzwerk/repository/AddressRepository;", "usersProfileRepository", "Lcom/shiftphones/shifternetzwerk/repository/UserprofileRepository;", "offeredserviceRepository", "Lcom/shiftphones/shifternetzwerk/repository/OfferedserviceRepository;", "(Lcom/shiftphones/shifternetzwerk/repository/ShifterRepository;Lcom/shiftphones/shifternetzwerk/repository/AddressRepository;Lcom/shiftphones/shifternetzwerk/repository/UserprofileRepository;Lcom/shiftphones/shifternetzwerk/repository/OfferedserviceRepository;)V", "getAddressRepository", "()Lcom/shiftphones/shifternetzwerk/repository/AddressRepository;", "log", "Lorg/slf4j/Logger;", "kotlin.jvm.PlatformType", "getOfferedserviceRepository", "()Lcom/shiftphones/shifternetzwerk/repository/OfferedserviceRepository;", "getUsersProfileRepository", "()Lcom/shiftphones/shifternetzwerk/repository/UserprofileRepository;", "addService2Shifter", "Lcom/shiftphones/shifternetzwerk/service/ShortIdAnswer;", "id", "", "offeredservice", "Lcom/shiftphones/shifternetzwerk/domain/Offeredservice;", "create", "Lcom/shiftphones/shifternetzwerk/domain/ShortEntityObject;", "shifter", "Lcom/shiftphones/shifternetzwerk/domain/Shifter;", "stdSaveLogic", "update", "", "shifternetzwerk"})
public class ShifterService {
    private final Logger log;
    private final ShifterRepository shifterRepository;
    @NotNull
    private final AddressRepository addressRepository;
    @NotNull
    private final UserprofileRepository usersProfileRepository;
    @NotNull
    private final OfferedserviceRepository offeredserviceRepository;

    @Transactional
    @NotNull
    public ShortEntityObject create(@NotNull Shifter shifter) {
        Intrinsics.checkParameterIsNotNull((Object)shifter, (String)"shifter");
        Shifter result = this.stdSaveLogic(shifter);
        Long id = result.getId();
        this.log.info("Created new serviceProvider " + id);
        Long l = id;
        if (l == null) {
            Intrinsics.throwNpe();
        }
        return new ShortEntityObject(l.longValue());
    }

    @Transactional
    public void update(@NotNull Shifter shifter) {
        Intrinsics.checkParameterIsNotNull((Object)shifter, (String)"shifter");
        this.getAddressRepository().removeAddressesByShifter(shifter);
        Shifter result = this.stdSaveLogic(shifter);
        Long id = result.getId();
        this.log.info("updated serviceProvider " + id);
    }

    private Shifter stdSaveLogic(Shifter shifter) {
        Address it;
        boolean bl;
        Userprofile it2;
        Collection<void> collection;
        Iterable $this$mapTo$iv$iv;
        Iterable $this$map$iv;
        Iterable iterable = shifter.getAdresses();
        Object object = shifter;
        boolean $i$f$map = false;
        void var4_6 = $this$map$iv;
        Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
        boolean $i$f$mapTo = false;
        for (Object item$iv$iv : $this$mapTo$iv$iv) {
            Address address = (Address)item$iv$iv;
            collection = destination$iv$iv;
            boolean bl2 = false;
            Address mappedProfile = it2;
            if (it2.getId() != null) {
                Long l;
                bl = false;
                boolean bl3 = false;
                long upid = ((Number)l).longValue();
                boolean bl4 = false;
                Optional up = this.getAddressRepository().findById((Object)upid);
                ((Address)up.get()).setShifter(shifter);
                Object t = up.get();
                Intrinsics.checkExpressionValueIsNotNull(t, (String)"up.get()");
                mappedProfile = (Address)t;
            }
            void var21_29 = mappedProfile;
            collection.add(var21_29);
        }
        collection = (List)destination$iv$iv;
        object.setAdresses(CollectionsKt.toMutableSet((Iterable)collection));
        $this$map$iv = shifter.getUsers();
        $i$f$map = false;
        $this$mapTo$iv$iv = $this$map$iv;
        destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
        $i$f$mapTo = false;
        for (Object item$iv$iv : $this$mapTo$iv$iv) {
            String string;
            it2 = (Userprofile)item$iv$iv;
            object = destination$iv$iv;
            boolean bl5 = false;
            if (it2.getId() != null) {
                Optional up;
                String string2;
                boolean bl6 = false;
                bl = false;
                String upid = string2;
                boolean bl7 = false;
                Optional optional = up = this.getUsersProfileRepository().findById((Object)upid);
                Intrinsics.checkExpressionValueIsNotNull((Object)optional, (String)"up");
                if (!optional.isPresent()) {
                    this.getUsersProfileRepository().save((Object)new Userprofile(upid, null, 2, null));
                }
                string = string2;
            } else {
                string = null;
            }
            collection = string;
            object.add(collection);
        }
        CollectionsKt.toMutableSet((Iterable)((List)destination$iv$iv));
        Shifter result = (Shifter)this.shifterRepository.save((Object)shifter);
        Iterable $this$forEach$iv = shifter.getAdresses();
        boolean $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            it = (Address)element$iv;
            boolean bl8 = false;
            this.getAddressRepository().save((Object)it);
        }
        $this$forEach$iv = shifter.getUsers();
        $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            it = (Userprofile)element$iv;
            boolean bl9 = false;
            it.setShifter(shifter);
            this.getUsersProfileRepository().save((Object)it);
        }
        Shifter shifter2 = result;
        Intrinsics.checkExpressionValueIsNotNull((Object)shifter2, (String)"result");
        return shifter2;
    }

    @Transactional
    @NotNull
    public ShortIdAnswer addService2Shifter(long id, @NotNull Offeredservice offeredservice) {
        Intrinsics.checkParameterIsNotNull((Object)offeredservice, (String)"offeredservice");
        Object t = this.shifterRepository.findById((Object)id).get();
        Intrinsics.checkExpressionValueIsNotNull(t, (String)"shifterRepository.findById(id).get()");
        Shifter shifter = (Shifter)t;
        offeredservice.setShifter(shifter);
        Long l = ((Offeredservice)this.getOfferedserviceRepository().save((Object)offeredservice)).getId();
        if (l == null) {
            Intrinsics.throwNpe();
        }
        return new ShortIdAnswer(l.longValue(), null, 2, null);
    }

    @NotNull
    public AddressRepository getAddressRepository() {
        return this.addressRepository;
    }

    @NotNull
    public UserprofileRepository getUsersProfileRepository() {
        return this.usersProfileRepository;
    }

    @NotNull
    public OfferedserviceRepository getOfferedserviceRepository() {
        return this.offeredserviceRepository;
    }

    public ShifterService(@NotNull ShifterRepository shifterRepository, @NotNull AddressRepository addressRepository, @NotNull UserprofileRepository usersProfileRepository, @NotNull OfferedserviceRepository offeredserviceRepository) {
        Intrinsics.checkParameterIsNotNull((Object)shifterRepository, (String)"shifterRepository");
        Intrinsics.checkParameterIsNotNull((Object)addressRepository, (String)"addressRepository");
        Intrinsics.checkParameterIsNotNull((Object)usersProfileRepository, (String)"usersProfileRepository");
        Intrinsics.checkParameterIsNotNull((Object)offeredserviceRepository, (String)"offeredserviceRepository");
        this.shifterRepository = shifterRepository;
        this.addressRepository = addressRepository;
        this.usersProfileRepository = usersProfileRepository;
        this.offeredserviceRepository = offeredserviceRepository;
        this.log = LoggerFactory.getLogger(this.getClass());
    }
}

