/*
 * Decompiled with CFR 0.152.
 */
package com.shiftphones.shifternetzwerk.web.rest;

import com.shiftphones.shifternetzwerk.service.UserService;
import com.shiftphones.shifternetzwerk.service.dto.UserDTO;
import com.shiftphones.shifternetzwerk.web.rest.AccountResource;
import java.security.Principal;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.security.authentication.AbstractAuthenticationToken;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(value={"/api"})
@Metadata(mv={1, 1, 16}, bv={1, 0, 3}, k=1, d1={"\u0000(\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\b\u0017\u0018\u0000 \r2\u00020\u0001:\u0002\f\rB\r\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004J\u0012\u0010\b\u001a\u00020\t2\b\u0010\n\u001a\u0004\u0018\u00010\u000bH\u0017R\u0016\u0010\u0005\u001a\n \u0007*\u0004\u0018\u00010\u00060\u0006X\u0092\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0002\u001a\u00020\u0003X\u0092\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u000e"}, d2={"Lcom/shiftphones/shifternetzwerk/web/rest/AccountResource;", "", "userService", "Lcom/shiftphones/shifternetzwerk/service/UserService;", "(Lcom/shiftphones/shifternetzwerk/service/UserService;)V", "log", "Lorg/slf4j/Logger;", "kotlin.jvm.PlatformType", "getAccount", "Lcom/shiftphones/shifternetzwerk/service/dto/UserDTO;", "principal", "Ljava/security/Principal;", "AccountResourceException", "Companion", "shifternetzwerk"})
public class AccountResource {
    private final Logger log;
    private final UserService userService;
    private static final long serialVersionUID = 1L;
    public static final Companion Companion = new Companion(null);

    @GetMapping(value={"/account"})
    @NotNull
    public UserDTO getAccount(@Nullable Principal principal) {
        if (!(principal instanceof AbstractAuthenticationToken)) {
            throw (Throwable)new AccountResourceException("User could not be found");
        }
        return this.userService.getUserFromAuthentication((AbstractAuthenticationToken)principal);
    }

    public AccountResource(@NotNull UserService userService) {
        Intrinsics.checkParameterIsNotNull((Object)userService, (String)"userService");
        this.userService = userService;
        this.log = LoggerFactory.getLogger(this.getClass());
    }
}

