/*
 * Decompiled with CFR 0.152.
 */
package com.shiftphones.shifternetzwerk.web.rest;

import com.shiftphones.shifternetzwerk.domain.Address;
import com.shiftphones.shifternetzwerk.domain.Shifter;
import com.shiftphones.shifternetzwerk.domain.ShifterAddressTag;
import com.shiftphones.shifternetzwerk.domain.ShifterAdress;
import com.shiftphones.shifternetzwerk.hateoas.AdressHateOasResource;
import com.shiftphones.shifternetzwerk.repository.AddressRepository;
import com.shiftphones.shifternetzwerk.service.AdressService;
import com.shiftphones.shifternetzwerk.web.rest.ResourceHelperService;
import com.shiftphones.shifternetzwerk.web.rest.errors.BadRequestAlertException;
import io.github.jhipster.web.util.HeaderUtil;
import io.github.jhipster.web.util.ResponseUtil;
import java.net.URI;
import java.util.Optional;
import javax.validation.Valid;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.data.repository.CrudRepository;
import org.springframework.data.repository.CrudRepositoryExtensionsKt;
import org.springframework.http.ResponseEntity;
import org.springframework.transaction.annotation.Transactional;
import org.springframework.web.bind.annotation.DeleteMapping;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.PutMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(value={"/api"})
@Metadata(mv={1, 1, 16}, bv={1, 0, 3}, k=1, d1={"\u0000T\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\t\n\u0002\b\u0004\b\u0017\u0018\u00002\u00020\u0001B\u001d\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u00a2\u0006\u0002\u0010\bJ\u0018\u0010\u000e\u001a\b\u0012\u0004\u0012\u00020\u00100\u000f2\b\b\u0001\u0010\u0011\u001a\u00020\u0012H\u0017J\u0018\u0010\u0013\u001a\b\u0012\u0004\u0012\u00020\u00100\u000f2\b\b\u0001\u0010\u0014\u001a\u00020\u0015H\u0017J\u0018\u0010\u0016\u001a\b\u0012\u0004\u0012\u00020\u00100\u000f2\b\b\u0001\u0010\u0014\u001a\u00020\u0015H\u0017J\u0018\u0010\u0017\u001a\b\u0012\u0004\u0012\u00020\u00180\u000f2\b\b\u0001\u0010\u0019\u001a\u00020\u001aH\u0017J\u0018\u0010\u001b\u001a\b\u0012\u0004\u0012\u00020\u00100\u000f2\b\b\u0001\u0010\u0019\u001a\u00020\u001aH\u0017J\u0018\u0010\u001c\u001a\b\u0012\u0004\u0012\u00020\u00100\u000f2\b\b\u0001\u0010\u0011\u001a\u00020\u0012H\u0017J\u0018\u0010\u001d\u001a\b\u0012\u0004\u0012\u00020\u00100\u000f2\b\b\u0001\u0010\u0014\u001a\u00020\u0015H\u0017R\u000e\u0010\u0002\u001a\u00020\u0003X\u0092\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0004\u001a\u00020\u0005X\u0092\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\t\u001a\u0004\u0018\u00010\n8\u0012@\u0012X\u0093\u000e\u00a2\u0006\u0002\n\u0000R\u0016\u0010\u000b\u001a\n \r*\u0004\u0018\u00010\f0\fX\u0092\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0007X\u0092\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u001e"}, d2={"Lcom/shiftphones/shifternetzwerk/web/rest/AddressResource;", "", "addressRepository", "Lcom/shiftphones/shifternetzwerk/repository/AddressRepository;", "adressService", "Lcom/shiftphones/shifternetzwerk/service/AdressService;", "resourceHelperService", "Lcom/shiftphones/shifternetzwerk/web/rest/ResourceHelperService;", "(Lcom/shiftphones/shifternetzwerk/repository/AddressRepository;Lcom/shiftphones/shifternetzwerk/service/AdressService;Lcom/shiftphones/shifternetzwerk/web/rest/ResourceHelperService;)V", "applicationName", "", "log", "Lorg/slf4j/Logger;", "kotlin.jvm.PlatformType", "addTag2Address", "Lorg/springframework/http/ResponseEntity;", "Lcom/shiftphones/shifternetzwerk/hateoas/AdressHateOasResource;", "tagAssignment", "Lcom/shiftphones/shifternetzwerk/domain/ShifterAddressTag;", "createAddress", "address", "Lcom/shiftphones/shifternetzwerk/domain/ShifterAdress;", "createAddressMigr", "deleteAddress", "Ljava/lang/Void;", "id", "", "getAddress", "removeTag2Address", "updateAddress", "shifternetzwerk"})
public class AddressResource {
    private final Logger log;
    @Value(value="${jhipster.clientApp.name}")
    private String applicationName;
    private final AddressRepository addressRepository;
    private final AdressService adressService;
    private final ResourceHelperService resourceHelperService;

    @PostMapping(value={"/addresses"})
    @Transactional
    @NotNull
    public ResponseEntity<AdressHateOasResource> createAddress(@Valid @RequestBody @NotNull ShifterAdress address) {
        Intrinsics.checkParameterIsNotNull((Object)address, (String)"address");
        this.log.debug("REST request to save Address : {}", (Object)address);
        if (address.getId() != null) {
            throw (Throwable)new BadRequestAlertException("A new address cannot already have an ID", "address", "idexists");
        }
        this.resourceHelperService.isCurrentUserPowerUserOrOneOfTheShifterAndThrowIfNotAllowed(address.getShifterId());
        Address result = this.adressService.stdSave(address);
        ResponseEntity responseEntity = ((ResponseEntity.BodyBuilder)ResponseEntity.created((URI)new URI("/api/addresses/" + result.getId())).headers(HeaderUtil.createEntityCreationAlert((String)this.applicationName, (boolean)true, (String)"address", (String)String.valueOf(result.getId())))).body((Object)new AdressHateOasResource(new ShifterAdress(result)));
        Intrinsics.checkExpressionValueIsNotNull((Object)responseEntity, (String)"ResponseEntity.created(U\u2026e(ShifterAdress(result)))");
        return responseEntity;
    }

    @PostMapping(value={"/addressesMigr"})
    @Transactional
    @NotNull
    public ResponseEntity<AdressHateOasResource> createAddressMigr(@Valid @RequestBody @NotNull ShifterAdress address) {
        Intrinsics.checkParameterIsNotNull((Object)address, (String)"address");
        this.log.error("createAddressMigr : {}", (Object)address);
        if (address.getId() != null) {
            throw (Throwable)new BadRequestAlertException("A new address cannot already have an ID", "address", "idexists");
        }
        Address result = this.adressService.stdSave(address);
        ResponseEntity responseEntity = ((ResponseEntity.BodyBuilder)ResponseEntity.created((URI)new URI("/api/addresses/" + result.getId())).headers(HeaderUtil.createEntityCreationAlert((String)this.applicationName, (boolean)true, (String)"address", (String)String.valueOf(result.getId())))).body((Object)new AdressHateOasResource(new ShifterAdress(result)));
        Intrinsics.checkExpressionValueIsNotNull((Object)responseEntity, (String)"ResponseEntity.created(U\u2026e(ShifterAdress(result)))");
        return responseEntity;
    }

    @PutMapping(value={"/addresses"})
    @Transactional
    @NotNull
    public ResponseEntity<AdressHateOasResource> updateAddress(@Valid @RequestBody @NotNull ShifterAdress address) {
        Intrinsics.checkParameterIsNotNull((Object)address, (String)"address");
        this.log.debug("REST request to update Address : {}", (Object)address);
        if (address.getId() == null) {
            throw (Throwable)new BadRequestAlertException("Invalid id", "address", "idnull");
        }
        this.resourceHelperService.isCurrentUserPowerUserOrOneOfTheShifterAndThrowIfNotAllowed(address.getShifterId());
        Address result = this.adressService.stdSave(address);
        ResponseEntity responseEntity = ((ResponseEntity.BodyBuilder)ResponseEntity.ok().headers(HeaderUtil.createEntityUpdateAlert((String)this.applicationName, (boolean)true, (String)"address", (String)String.valueOf(address.getId())))).body((Object)new AdressHateOasResource(new ShifterAdress(result)));
        Intrinsics.checkExpressionValueIsNotNull((Object)responseEntity, (String)"ResponseEntity.ok()\n    \u2026e(ShifterAdress(result)))");
        return responseEntity;
    }

    @GetMapping(value={"/addresses/{id}"})
    @Transactional(readOnly=true)
    @NotNull
    public ResponseEntity<AdressHateOasResource> getAddress(@PathVariable long id) {
        this.log.debug("REST request to get Address : {}", (Object)id);
        Address address = (Address)CrudRepositoryExtensionsKt.findByIdOrNull((CrudRepository)((CrudRepository)this.addressRepository), (Object)id);
        if (address != null) {
            Address address2 = address;
            boolean bl = false;
            boolean bl2 = false;
            Address it = address2;
            boolean bl3 = false;
            Shifter shifter = it.getShifter();
            if (shifter == null) {
                Intrinsics.throwNpe();
            }
            Long l = shifter.getId();
            if (l == null) {
                Intrinsics.throwNpe();
            }
            this.resourceHelperService.isCurrentUserPowerUserOrOneOfTheShifterAndThrowIfNotAllowed(l.longValue());
            ResponseEntity responseEntity = ResponseEntity.ok((Object)new AdressHateOasResource(new ShifterAdress(it)));
            Intrinsics.checkExpressionValueIsNotNull((Object)responseEntity, (String)"ResponseEntity.ok(Adress\u2026ource(ShifterAdress(it)))");
            return responseEntity;
        }
        ResponseEntity responseEntity = ResponseUtil.wrapOrNotFound(Optional.empty());
        Intrinsics.checkExpressionValueIsNotNull((Object)responseEntity, (String)"ResponseUtil.wrapOrNotFound(Optional.empty())");
        return responseEntity;
    }

    @DeleteMapping(value={"/addresses/{id}"})
    @Transactional
    @NotNull
    public ResponseEntity<Void> deleteAddress(@PathVariable long id) {
        this.log.debug("REST request to delete Address : {}", (Object)id);
        Address address = (Address)CrudRepositoryExtensionsKt.findByIdOrNull((CrudRepository)((CrudRepository)this.addressRepository), (Object)id);
        if (address != null) {
            Address address2 = address;
            boolean bl = false;
            boolean bl2 = false;
            Address it = address2;
            boolean bl3 = false;
            Shifter shifter = it.getShifter();
            if (shifter == null) {
                Intrinsics.throwNpe();
            }
            Long l = shifter.getId();
            if (l == null) {
                Intrinsics.throwNpe();
            }
            this.resourceHelperService.isCurrentUserPowerUserOrOneOfTheShifterAndThrowIfNotAllowed(l.longValue());
        }
        this.addressRepository.deleteById((Object)id);
        ResponseEntity responseEntity = ResponseEntity.noContent().headers(HeaderUtil.createEntityDeletionAlert((String)this.applicationName, (boolean)true, (String)"address", (String)String.valueOf(id))).build();
        Intrinsics.checkExpressionValueIsNotNull((Object)responseEntity, (String)"ResponseEntity.noContent\u2026, id.toString())).build()");
        return responseEntity;
    }

    @PutMapping(value={"/address/tags/add"})
    @Transactional
    @NotNull
    public ResponseEntity<AdressHateOasResource> addTag2Address(@Valid @RequestBody @NotNull ShifterAddressTag tagAssignment) {
        Intrinsics.checkParameterIsNotNull((Object)tagAssignment, (String)"tagAssignment");
        this.log.debug("REST request to save tag 2 Address : {}", (Object)tagAssignment);
        Address address = (Address)CrudRepositoryExtensionsKt.findByIdOrNull((CrudRepository)((CrudRepository)this.addressRepository), (Object)tagAssignment.getAddressId());
        if (address != null) {
            Address address2 = address;
            boolean bl = false;
            boolean bl2 = false;
            Address address3 = address2;
            boolean bl3 = false;
            Address result = this.adressService.addTag2Address(tagAssignment);
            ResponseEntity responseEntity = ResponseEntity.ok().body((Object)new AdressHateOasResource(new ShifterAdress(result)));
            Intrinsics.checkExpressionValueIsNotNull((Object)responseEntity, (String)"ResponseEntity.ok()\n    \u2026e(ShifterAdress(result)))");
            return responseEntity;
        }
        ResponseEntity responseEntity = ResponseEntity.notFound().build();
        Intrinsics.checkExpressionValueIsNotNull((Object)responseEntity, (String)"ResponseEntity.notFound().build()");
        return responseEntity;
    }

    @PutMapping(value={"/address/tags/remove"})
    @Transactional
    @NotNull
    public ResponseEntity<AdressHateOasResource> removeTag2Address(@Valid @RequestBody @NotNull ShifterAddressTag tagAssignment) {
        Intrinsics.checkParameterIsNotNull((Object)tagAssignment, (String)"tagAssignment");
        this.log.debug("REST request to save tag 2 Address : {}", (Object)tagAssignment);
        Address address = (Address)CrudRepositoryExtensionsKt.findByIdOrNull((CrudRepository)((CrudRepository)this.addressRepository), (Object)tagAssignment.getAddressId());
        if (address != null) {
            Address address2 = address;
            boolean bl = false;
            boolean bl2 = false;
            Address address3 = address2;
            boolean bl3 = false;
            Address result = this.adressService.removeTagFromAddress(tagAssignment);
            ResponseEntity responseEntity = ResponseEntity.ok().body((Object)new AdressHateOasResource(new ShifterAdress(result)));
            Intrinsics.checkExpressionValueIsNotNull((Object)responseEntity, (String)"ResponseEntity.ok()\n    \u2026e(ShifterAdress(result)))");
            return responseEntity;
        }
        ResponseEntity responseEntity = ResponseEntity.notFound().build();
        Intrinsics.checkExpressionValueIsNotNull((Object)responseEntity, (String)"ResponseEntity.notFound().build()");
        return responseEntity;
    }

    public AddressResource(@NotNull AddressRepository addressRepository, @NotNull AdressService adressService, @NotNull ResourceHelperService resourceHelperService) {
        Intrinsics.checkParameterIsNotNull((Object)addressRepository, (String)"addressRepository");
        Intrinsics.checkParameterIsNotNull((Object)adressService, (String)"adressService");
        Intrinsics.checkParameterIsNotNull((Object)resourceHelperService, (String)"resourceHelperService");
        this.addressRepository = addressRepository;
        this.adressService = adressService;
        this.resourceHelperService = resourceHelperService;
        this.log = LoggerFactory.getLogger(this.getClass());
    }
}

