/*
 * Decompiled with CFR 0.152.
 */
package com.shiftphones.shifternetzwerk.web.rest;

import com.shiftphones.shifternetzwerk.domain.OfferedserviceCreationRequest;
import com.shiftphones.shifternetzwerk.domain.OfferedserviceRequest;
import com.shiftphones.shifternetzwerk.domain.enumeration.ServiceState;
import com.shiftphones.shifternetzwerk.hateoas.OfferedServiceRequestOasResource;
import com.shiftphones.shifternetzwerk.repository.OfferedserviceRequestRepository;
import com.shiftphones.shifternetzwerk.security.SecurityUtils;
import com.shiftphones.shifternetzwerk.service.KeyCloakService;
import com.shiftphones.shifternetzwerk.service.OfferedServiceService;
import com.shiftphones.shifternetzwerk.web.rest.ResourceHelperService;
import com.shiftphones.shifternetzwerk.web.rest.errors.BadRequestAlertException;
import io.github.jhipster.web.util.HeaderUtil;
import io.github.jhipster.web.util.ResponseUtil;
import java.net.URI;
import java.util.List;
import java.util.Optional;
import javax.validation.Valid;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.http.ResponseEntity;
import org.springframework.security.access.prepost.PreAuthorize;
import org.springframework.transaction.annotation.Transactional;
import org.springframework.web.bind.annotation.DeleteMapping;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.PutMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(value={"/api"})
@Metadata(mv={1, 1, 16}, bv={1, 0, 3}, k=1, d1={"\u0000`\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\t\n\u0000\n\u0002\u0010!\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0010\u000b\n\u0000\b\u0017\u0018\u00002\u00020\u0001B%\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u0012\u0006\u0010\b\u001a\u00020\t\u00a2\u0006\u0002\u0010\nJ\u0018\u0010\u0010\u001a\b\u0012\u0004\u0012\u00020\u00120\u00112\b\b\u0001\u0010\u0013\u001a\u00020\u0014H\u0017J\u0018\u0010\u0015\u001a\b\u0012\u0004\u0012\u00020\u00160\u00112\b\b\u0001\u0010\u0017\u001a\u00020\u0018H\u0017J\u000e\u0010\u0019\u001a\b\u0012\u0004\u0012\u00020\u001b0\u001aH\u0017J\u0018\u0010\u001c\u001a\b\u0012\u0004\u0012\u00020\u00120\u00112\b\b\u0001\u0010\u0017\u001a\u00020\u0018H\u0017J\u0018\u0010\u001d\u001a\b\u0012\u0004\u0012\u00020\u001b0\u00112\b\b\u0001\u0010\u0013\u001a\u00020\u001bH\u0017J\"\u0010\u001e\u001a\b\u0012\u0004\u0012\u00020\f0\u00112\b\b\u0001\u0010\u0017\u001a\u00020\u00182\b\b\u0001\u0010\u001f\u001a\u00020 H\u0017R\u0014\u0010\u000b\u001a\u0004\u0018\u00010\f8\u0012@\u0012X\u0093\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\b\u001a\u00020\tX\u0092\u0004\u00a2\u0006\u0002\n\u0000R\u0016\u0010\r\u001a\n \u000f*\u0004\u0018\u00010\u000e0\u000eX\u0092\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0004\u001a\u00020\u0005X\u0092\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0007X\u0092\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0002\u001a\u00020\u0003X\u0092\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006!"}, d2={"Lcom/shiftphones/shifternetzwerk/web/rest/OfferedserviceRequestResource;", "", "service", "Lcom/shiftphones/shifternetzwerk/service/OfferedServiceService;", "offeredserviceRequestRepository", "Lcom/shiftphones/shifternetzwerk/repository/OfferedserviceRequestRepository;", "resourceHelperService", "Lcom/shiftphones/shifternetzwerk/web/rest/ResourceHelperService;", "keyCloakService", "Lcom/shiftphones/shifternetzwerk/service/KeyCloakService;", "(Lcom/shiftphones/shifternetzwerk/service/OfferedServiceService;Lcom/shiftphones/shifternetzwerk/repository/OfferedserviceRequestRepository;Lcom/shiftphones/shifternetzwerk/web/rest/ResourceHelperService;Lcom/shiftphones/shifternetzwerk/service/KeyCloakService;)V", "applicationName", "", "log", "Lorg/slf4j/Logger;", "kotlin.jvm.PlatformType", "createOfferedserviceRequest", "Lorg/springframework/http/ResponseEntity;", "Lcom/shiftphones/shifternetzwerk/hateoas/OfferedServiceRequestOasResource;", "offeredserviceRequest", "Lcom/shiftphones/shifternetzwerk/domain/OfferedserviceCreationRequest;", "deleteOfferedserviceRequest", "Ljava/lang/Void;", "id", "", "getAllOfferedserviceRequests", "", "Lcom/shiftphones/shifternetzwerk/domain/OfferedserviceRequest;", "getOfferedserviceRequest", "updateOfferedserviceRequest", "updateState", "accept", "", "shifternetzwerk"})
public class OfferedserviceRequestResource {
    private final Logger log;
    @Value(value="${jhipster.clientApp.name}")
    private String applicationName;
    private final OfferedServiceService service;
    private final OfferedserviceRequestRepository offeredserviceRequestRepository;
    private final ResourceHelperService resourceHelperService;
    private final KeyCloakService keyCloakService;

    @PostMapping(value={"/offeredservice-requests"})
    @NotNull
    public ResponseEntity<OfferedServiceRequestOasResource> createOfferedserviceRequest(@Valid @RequestBody @NotNull OfferedserviceCreationRequest offeredserviceRequest) {
        Intrinsics.checkParameterIsNotNull((Object)offeredserviceRequest, (String)"offeredserviceRequest");
        this.log.debug("REST request to save OfferedserviceRequest : {}", (Object)offeredserviceRequest);
        boolean isPoweruser = SecurityUtils.isCurrentUserPowerUser();
        Long shifterId = this.resourceHelperService.getShifterId();
        if (isPoweruser || shifterId != null) {
            OfferedserviceRequest result = this.service.createRequest(offeredserviceRequest, shifterId, isPoweruser);
            ResponseEntity responseEntity = ResponseEntity.created((URI)new URI("/api/offeredservice-requests/" + result.getId())).body((Object)new OfferedServiceRequestOasResource(result));
            Intrinsics.checkExpressionValueIsNotNull((Object)responseEntity, (String)"ResponseEntity.created(U\u2026questOasResource(result))");
            return responseEntity;
        }
        throw (Throwable)new BadRequestAlertException("No shifter assigned ", "offeredserviceRequest", "offeredserviceRequest.noShifterToUserAssigned");
    }

    @PutMapping(value={"/offeredservice-requests/{id}/{accept}"})
    @NotNull
    public ResponseEntity<String> updateState(@PathVariable long id, @PathVariable boolean accept) {
        if (!this.keyCloakService.isPowerUser(this.resourceHelperService.getUserId())) {
            throw (Throwable)new RuntimeException();
        }
        this.log.debug("REST request to updateState OfferedserviceRequest : " + id + ' ' + accept);
        if (accept) {
            this.service.acceptOfferedServiceRequest(id);
        } else {
            this.service.rejectOfferedServiceRequest(id);
        }
        ResponseEntity responseEntity = ResponseEntity.ok((Object)"OK");
        Intrinsics.checkExpressionValueIsNotNull((Object)responseEntity, (String)"ResponseEntity.ok(\"OK\")");
        return responseEntity;
    }

    @PutMapping(value={"/offeredservice-requests"})
    @NotNull
    public ResponseEntity<OfferedserviceRequest> updateOfferedserviceRequest(@Valid @RequestBody @NotNull OfferedserviceRequest offeredserviceRequest) {
        Intrinsics.checkParameterIsNotNull((Object)offeredserviceRequest, (String)"offeredserviceRequest");
        this.log.debug("REST request to update OfferedserviceRequest : {}", (Object)offeredserviceRequest);
        if (offeredserviceRequest.getId() == null) {
            throw (Throwable)new BadRequestAlertException("Invalid id", "offeredserviceRequest", "idnull");
        }
        if (!SecurityUtils.isCurrentUserPowerUser() && offeredserviceRequest.getState() != ServiceState.REQUESTED) {
            throw (Throwable)new BadRequestAlertException("change state not allowed for non poweruser", "offeredserviceRequest", "rightproblem");
        }
        OfferedserviceRequest result = (OfferedserviceRequest)this.offeredserviceRequestRepository.save((Object)offeredserviceRequest);
        ResponseEntity responseEntity = ((ResponseEntity.BodyBuilder)ResponseEntity.ok().headers(HeaderUtil.createEntityUpdateAlert((String)this.applicationName, (boolean)true, (String)"offeredserviceRequest", (String)String.valueOf(offeredserviceRequest.getId())))).body((Object)result);
        Intrinsics.checkExpressionValueIsNotNull((Object)responseEntity, (String)"ResponseEntity.ok()\n    \u2026            .body(result)");
        return responseEntity;
    }

    @GetMapping(value={"/offeredservice-requests"})
    @PreAuthorize(value="hasRole(\"ROLE_POWERUSER\")")
    @NotNull
    public List<OfferedserviceRequest> getAllOfferedserviceRequests() {
        this.log.debug("REST request to get all OfferedserviceRequests");
        List list = this.offeredserviceRequestRepository.findAll();
        Intrinsics.checkExpressionValueIsNotNull((Object)list, (String)"offeredserviceRequestRepository.findAll()");
        return list;
    }

    @GetMapping(value={"/offeredservice-requests/{id}"})
    @Transactional
    @NotNull
    public ResponseEntity<OfferedServiceRequestOasResource> getOfferedserviceRequest(@PathVariable long id) {
        Optional offeredserviceRequest;
        this.log.debug("REST request to get OfferedserviceRequest : {}", (Object)id);
        Optional optional = offeredserviceRequest = this.offeredserviceRequestRepository.findById((Object)id);
        Intrinsics.checkExpressionValueIsNotNull((Object)optional, (String)"offeredserviceRequest");
        if (optional.isPresent()) {
            Object t = offeredserviceRequest.get();
            Intrinsics.checkExpressionValueIsNotNull(t, (String)"offeredserviceRequest.get()");
            ResponseEntity responseEntity = ResponseUtil.wrapOrNotFound(Optional.of(new OfferedServiceRequestOasResource((OfferedserviceRequest)t)));
            Intrinsics.checkExpressionValueIsNotNull((Object)responseEntity, (String)"ResponseUtil.wrapOrNotFo\u2026edserviceRequest.get())))");
            return responseEntity;
        }
        ResponseEntity responseEntity = ResponseUtil.wrapOrNotFound(Optional.empty());
        Intrinsics.checkExpressionValueIsNotNull((Object)responseEntity, (String)"ResponseUtil.wrapOrNotFound(Optional.empty())");
        return responseEntity;
    }

    @DeleteMapping(value={"/offeredservice-requests/{id}"})
    @NotNull
    public ResponseEntity<Void> deleteOfferedserviceRequest(@PathVariable long id) {
        this.log.debug("REST request to delete OfferedserviceRequest : {}", (Object)id);
        this.offeredserviceRequestRepository.deleteById((Object)id);
        ResponseEntity responseEntity = ResponseEntity.noContent().headers(HeaderUtil.createEntityDeletionAlert((String)this.applicationName, (boolean)true, (String)"offeredserviceRequest", (String)String.valueOf(id))).build();
        Intrinsics.checkExpressionValueIsNotNull((Object)responseEntity, (String)"ResponseEntity.noContent\u2026, id.toString())).build()");
        return responseEntity;
    }

    public OfferedserviceRequestResource(@NotNull OfferedServiceService service, @NotNull OfferedserviceRequestRepository offeredserviceRequestRepository, @NotNull ResourceHelperService resourceHelperService, @NotNull KeyCloakService keyCloakService) {
        Intrinsics.checkParameterIsNotNull((Object)service, (String)"service");
        Intrinsics.checkParameterIsNotNull((Object)offeredserviceRequestRepository, (String)"offeredserviceRequestRepository");
        Intrinsics.checkParameterIsNotNull((Object)resourceHelperService, (String)"resourceHelperService");
        Intrinsics.checkParameterIsNotNull((Object)keyCloakService, (String)"keyCloakService");
        this.service = service;
        this.offeredserviceRequestRepository = offeredserviceRequestRepository;
        this.resourceHelperService = resourceHelperService;
        this.keyCloakService = keyCloakService;
        this.log = LoggerFactory.getLogger(this.getClass());
    }
}

