/*
 * Decompiled with CFR 0.152.
 */
package com.shiftphones.shifternetzwerk.web.rest;

import com.shiftphones.shifternetzwerk.domain.Product;
import com.shiftphones.shifternetzwerk.domain.Productinstance;
import com.shiftphones.shifternetzwerk.domain.Serialnumber;
import com.shiftphones.shifternetzwerk.domain.ShortEntityObject;
import com.shiftphones.shifternetzwerk.domain.UserProductInstance;
import com.shiftphones.shifternetzwerk.hateoas.HateOasProductInstance;
import com.shiftphones.shifternetzwerk.hateoas.ProductInstanceHateOasResource;
import com.shiftphones.shifternetzwerk.repository.ProductinstanceRepository;
import com.shiftphones.shifternetzwerk.service.ProductInstanceService;
import com.shiftphones.shifternetzwerk.web.rest.ResourceHelperService;
import com.shiftphones.shifternetzwerk.web.rest.errors.BadRequestAlertException;
import io.github.jhipster.web.util.HeaderUtil;
import io.github.jhipster.web.util.ResponseUtil;
import java.net.URI;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import java.util.Optional;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.data.repository.CrudRepository;
import org.springframework.data.repository.CrudRepositoryExtensionsKt;
import org.springframework.http.ResponseEntity;
import org.springframework.transaction.annotation.Transactional;
import org.springframework.web.bind.annotation.DeleteMapping;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(value={"/api"})
@Metadata(mv={1, 1, 16}, bv={1, 0, 3}, k=1, d1={"\u0000N\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\t\n\u0000\n\u0002\u0018\u0002\n\u0000\b\u0017\u0018\u00002\u00020\u0001B\u001d\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u00a2\u0006\u0002\u0010\bJ\u0018\u0010\u000e\u001a\b\u0012\u0004\u0012\u00020\u00100\u000f2\b\b\u0001\u0010\u0011\u001a\u00020\u0012H\u0017J\u0018\u0010\u0013\u001a\b\u0012\u0004\u0012\u00020\u00140\u000f2\b\b\u0001\u0010\u0015\u001a\u00020\u0016H\u0017J\u0018\u0010\u0017\u001a\b\u0012\u0004\u0012\u00020\u00180\u000f2\b\b\u0001\u0010\u0015\u001a\u00020\u0016H\u0017R\u0014\u0010\t\u001a\u0004\u0018\u00010\n8\u0012@\u0012X\u0093\u000e\u00a2\u0006\u0002\n\u0000R\u0016\u0010\u000b\u001a\n \r*\u0004\u0018\u00010\f0\fX\u0092\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0004\u001a\u00020\u0005X\u0092\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0002\u001a\u00020\u0003X\u0092\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0007X\u0092\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0019"}, d2={"Lcom/shiftphones/shifternetzwerk/web/rest/ProductinstanceResource;", "", "productinstanceRepository", "Lcom/shiftphones/shifternetzwerk/repository/ProductinstanceRepository;", "productInstanceService", "Lcom/shiftphones/shifternetzwerk/service/ProductInstanceService;", "resourceHelperService", "Lcom/shiftphones/shifternetzwerk/web/rest/ResourceHelperService;", "(Lcom/shiftphones/shifternetzwerk/repository/ProductinstanceRepository;Lcom/shiftphones/shifternetzwerk/service/ProductInstanceService;Lcom/shiftphones/shifternetzwerk/web/rest/ResourceHelperService;)V", "applicationName", "", "log", "Lorg/slf4j/Logger;", "kotlin.jvm.PlatformType", "createProductinstance", "Lorg/springframework/http/ResponseEntity;", "Lcom/shiftphones/shifternetzwerk/domain/ShortEntityObject;", "productinstance", "Lcom/shiftphones/shifternetzwerk/domain/UserProductInstance;", "deleteProductinstance", "Ljava/lang/Void;", "id", "", "getProductinstance", "Lcom/shiftphones/shifternetzwerk/hateoas/ProductInstanceHateOasResource;", "shifternetzwerk"})
public class ProductinstanceResource {
    private final Logger log;
    @Value(value="${jhipster.clientApp.name}")
    private String applicationName;
    private final ProductinstanceRepository productinstanceRepository;
    private final ProductInstanceService productInstanceService;
    private final ResourceHelperService resourceHelperService;

    @PostMapping(value={"/productinstances"})
    @Transactional
    @NotNull
    public ResponseEntity<ShortEntityObject> createProductinstance(@RequestBody @NotNull UserProductInstance productinstance) {
        Intrinsics.checkParameterIsNotNull((Object)productinstance, (String)"productinstance");
        this.log.debug("REST request to save Productinstance : {}", (Object)productinstance);
        if (productinstance.getId() != null) {
            throw (Throwable)new BadRequestAlertException("A new productinstance cannot already have an ID", "productinstance", "idexists");
        }
        this.resourceHelperService.isCurrentUserPowerUserOrOneOfTheShifterAndThrowIfNotAllowed(productinstance.getShifterId());
        Productinstance result = this.productInstanceService.create(productinstance);
        ResponseEntity.BodyBuilder bodyBuilder = (ResponseEntity.BodyBuilder)ResponseEntity.created((URI)new URI("/api/productinstances/" + result.getId())).headers(HeaderUtil.createEntityCreationAlert((String)this.applicationName, (boolean)true, (String)"productinstance", (String)String.valueOf(result.getId())));
        Long l = result.getId();
        if (l == null) {
            Intrinsics.throwNpe();
        }
        ResponseEntity responseEntity = bodyBuilder.body((Object)new ShortEntityObject(l.longValue()));
        Intrinsics.checkExpressionValueIsNotNull((Object)responseEntity, (String)"ResponseEntity.created(U\u2026ntityObject(result.id!!))");
        return responseEntity;
    }

    @GetMapping(value={"/productinstances/{id}"})
    @Transactional(readOnly=true)
    @NotNull
    public ResponseEntity<ProductInstanceHateOasResource> getProductinstance(@PathVariable long id) {
        this.log.debug("REST request to get Productinstance : {}", (Object)id);
        Productinstance productinstance = (Productinstance)CrudRepositoryExtensionsKt.findByIdOrNull((CrudRepository)((CrudRepository)this.productinstanceRepository), (Object)id);
        if (productinstance != null) {
            boolean bl;
            Object it$iv$iv;
            Object object;
            boolean bl2;
            boolean bl3;
            boolean bl4;
            Object element$iv$iv;
            Object element$iv$iv$iv;
            Iterable $this$mapNotNullTo$iv$iv;
            Iterable $this$mapNotNull$iv;
            Productinstance productinstance2 = productinstance;
            boolean bl5 = false;
            boolean bl6 = false;
            Productinstance it = productinstance2;
            boolean bl7 = false;
            boolean hasActive = this.productInstanceService.findActiveOwnerShip(id) != null;
            Long l = it.getId();
            if (l == null) {
                Intrinsics.throwNpe();
            }
            Iterable iterable = it.getSerialnumbers();
            long l2 = l;
            boolean $i$f$mapNotNull = false;
            void var17_11 = $this$mapNotNull$iv;
            Collection destination$iv$iv = new ArrayList();
            boolean $i$f$mapNotNullTo = false;
            Iterable $this$forEach$iv$iv$iv = $this$mapNotNullTo$iv$iv;
            boolean $i$f$forEach = false;
            Iterator iterator = $this$forEach$iv$iv$iv.iterator();
            while (iterator.hasNext()) {
                element$iv$iv = element$iv$iv$iv = iterator.next();
                bl4 = false;
                Serialnumber it2 = (Serialnumber)element$iv$iv;
                boolean bl8 = false;
                if (it2.getName() == null) continue;
                bl3 = false;
                bl2 = false;
                it$iv$iv = object;
                bl = false;
                destination$iv$iv.add(it$iv$iv);
            }
            List list = (List)destination$iv$iv;
            List list2 = CollectionsKt.toList((Iterable)list);
            Product product = it.getProduct();
            if (product == null) {
                Intrinsics.throwNpe();
            }
            Long l3 = product.getId();
            if (l3 == null) {
                Intrinsics.throwNpe();
            }
            long l4 = l3;
            List list3 = list2;
            long l5 = l2;
            $this$mapNotNull$iv = it.getSerialnumbers();
            boolean bl9 = hasActive;
            HateOasProductInstance hateOasProductInstance = new HateOasProductInstance(l5, list3, l4);
            $i$f$mapNotNull = false;
            $this$mapNotNullTo$iv$iv = $this$mapNotNull$iv;
            destination$iv$iv = new ArrayList();
            $i$f$mapNotNullTo = false;
            $this$forEach$iv$iv$iv = $this$mapNotNullTo$iv$iv;
            $i$f$forEach = false;
            iterator = $this$forEach$iv$iv$iv.iterator();
            while (iterator.hasNext()) {
                element$iv$iv = element$iv$iv$iv = iterator.next();
                bl4 = false;
                Serialnumber s = (Serialnumber)element$iv$iv;
                boolean bl10 = false;
                if (s.getId() == null) continue;
                bl3 = false;
                bl2 = false;
                it$iv$iv = object;
                bl = false;
                destination$iv$iv.add(it$iv$iv);
            }
            List list4 = (List)destination$iv$iv;
            List list5 = CollectionsKt.toList((Iterable)list4);
            boolean bl11 = bl9;
            HateOasProductInstance hateOasProductInstance2 = hateOasProductInstance;
            ResponseEntity responseEntity = ResponseEntity.ok((Object)new ProductInstanceHateOasResource(hateOasProductInstance2, bl11, list5));
            Intrinsics.checkExpressionValueIsNotNull((Object)responseEntity, (String)"ResponseEntity.ok(Produc\u2026 { s -> s.id }.toList()))");
            return responseEntity;
        }
        ResponseEntity responseEntity = ResponseUtil.wrapOrNotFound(Optional.empty());
        Intrinsics.checkExpressionValueIsNotNull((Object)responseEntity, (String)"ResponseUtil.wrapOrNotFound(Optional.empty())");
        return responseEntity;
    }

    @DeleteMapping(value={"/productinstances/{id}"})
    @Transactional
    @NotNull
    public ResponseEntity<Void> deleteProductinstance(@PathVariable long id) {
        this.log.info("REST request to end ownership Productinstance : {}", (Object)id);
        this.productInstanceService.endOwnership(id);
        ResponseEntity responseEntity = ResponseEntity.noContent().headers(HeaderUtil.createEntityDeletionAlert((String)this.applicationName, (boolean)true, (String)"productinstance", (String)String.valueOf(id))).build();
        Intrinsics.checkExpressionValueIsNotNull((Object)responseEntity, (String)"ResponseEntity.noContent\u2026, id.toString())).build()");
        return responseEntity;
    }

    public ProductinstanceResource(@NotNull ProductinstanceRepository productinstanceRepository, @NotNull ProductInstanceService productInstanceService, @NotNull ResourceHelperService resourceHelperService) {
        Intrinsics.checkParameterIsNotNull((Object)productinstanceRepository, (String)"productinstanceRepository");
        Intrinsics.checkParameterIsNotNull((Object)productInstanceService, (String)"productInstanceService");
        Intrinsics.checkParameterIsNotNull((Object)resourceHelperService, (String)"resourceHelperService");
        this.productinstanceRepository = productinstanceRepository;
        this.productInstanceService = productInstanceService;
        this.resourceHelperService = resourceHelperService;
        this.log = LoggerFactory.getLogger(this.getClass());
    }
}

