/*
 * Decompiled with CFR 0.152.
 */
package com.shiftphones.shifternetzwerk.web.rest;

import com.shiftphones.shifternetzwerk.domain.Offeredservice;
import com.shiftphones.shifternetzwerk.domain.Shifter;
import com.shiftphones.shifternetzwerk.domain.ShortEntityObject;
import com.shiftphones.shifternetzwerk.domain.Userprofile;
import com.shiftphones.shifternetzwerk.hateoas.ShifterHateOasDomainObject;
import com.shiftphones.shifternetzwerk.hateoas.ShifterOverviewHateOasResource;
import com.shiftphones.shifternetzwerk.repository.ServiceProviderRepositoryDbDirectSearch;
import com.shiftphones.shifternetzwerk.repository.ShifterRepository;
import com.shiftphones.shifternetzwerk.service.ShifterService;
import com.shiftphones.shifternetzwerk.service.ShortIdAnswer;
import com.shiftphones.shifternetzwerk.web.rest.ResourceHelperService;
import com.shiftphones.shifternetzwerk.web.rest.errors.BadRequestAlertException;
import io.github.jhipster.web.util.HeaderUtil;
import io.github.jhipster.web.util.ResponseUtil;
import java.net.URI;
import java.util.Optional;
import java.util.Set;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.data.repository.CrudRepository;
import org.springframework.data.repository.CrudRepositoryExtensionsKt;
import org.springframework.http.ResponseEntity;
import org.springframework.transaction.annotation.Transactional;
import org.springframework.web.bind.annotation.DeleteMapping;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.PutMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(value={"/api"})
@Metadata(mv={1, 1, 16}, bv={1, 0, 3}, k=1, d1={"\u0000d\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\t\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u0017\u0018\u00002\u00020\u0001B%\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u0012\u0006\u0010\b\u001a\u00020\t\u00a2\u0006\u0002\u0010\nJ\"\u0010\u0010\u001a\b\u0012\u0004\u0012\u00020\u00120\u00112\b\b\u0001\u0010\u0013\u001a\u00020\u00142\b\b\u0001\u0010\u0015\u001a\u00020\u0016H\u0017J\u0018\u0010\u0017\u001a\b\u0012\u0004\u0012\u00020\u00180\u00112\b\b\u0001\u0010\u0019\u001a\u00020\u001aH\u0017J\u0018\u0010\u001b\u001a\b\u0012\u0004\u0012\u00020\u00180\u00112\b\b\u0001\u0010\u0019\u001a\u00020\u001aH\u0017J\u0018\u0010\u001c\u001a\b\u0012\u0004\u0012\u00020\u001d0\u00112\b\b\u0001\u0010\u0013\u001a\u00020\u0014H\u0017J\u0018\u0010\u001e\u001a\b\u0012\u0004\u0012\u00020\u001f0\u00112\b\b\u0001\u0010\u0013\u001a\u00020\u0014H\u0017J\u0018\u0010 \u001a\b\u0012\u0004\u0012\u00020\f0\u00112\b\b\u0001\u0010\u0019\u001a\u00020\u001aH\u0017R\u0014\u0010\u000b\u001a\u0004\u0018\u00010\f8\u0012@\u0012X\u0093\u000e\u00a2\u0006\u0002\n\u0000R\u0016\u0010\r\u001a\n \u000f*\u0004\u0018\u00010\u000e0\u000eX\u0092\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0007X\u0092\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\b\u001a\u00020\tX\u0092\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0002\u001a\u00020\u0003X\u0092\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0004\u001a\u00020\u0005X\u0092\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006!"}, d2={"Lcom/shiftphones/shifternetzwerk/web/rest/ShifterResource;", "", "shifterRepository", "Lcom/shiftphones/shifternetzwerk/repository/ShifterRepository;", "shifterService", "Lcom/shiftphones/shifternetzwerk/service/ShifterService;", "resourceHelperService", "Lcom/shiftphones/shifternetzwerk/web/rest/ResourceHelperService;", "serviceProviderRepositoryDbDirectSearch", "Lcom/shiftphones/shifternetzwerk/repository/ServiceProviderRepositoryDbDirectSearch;", "(Lcom/shiftphones/shifternetzwerk/repository/ShifterRepository;Lcom/shiftphones/shifternetzwerk/service/ShifterService;Lcom/shiftphones/shifternetzwerk/web/rest/ResourceHelperService;Lcom/shiftphones/shifternetzwerk/repository/ServiceProviderRepositoryDbDirectSearch;)V", "applicationName", "", "log", "Lorg/slf4j/Logger;", "kotlin.jvm.PlatformType", "addService2Shifter", "Lorg/springframework/http/ResponseEntity;", "Lcom/shiftphones/shifternetzwerk/service/ShortIdAnswer;", "id", "", "offeredservice", "Lcom/shiftphones/shifternetzwerk/domain/Offeredservice;", "createShifter", "Lcom/shiftphones/shifternetzwerk/domain/ShortEntityObject;", "shifter", "Lcom/shiftphones/shifternetzwerk/domain/Shifter;", "createShifterMigr", "deleteShifter", "Ljava/lang/Void;", "getShifter", "Lcom/shiftphones/shifternetzwerk/hateoas/ShifterOverviewHateOasResource;", "updateShifter", "shifternetzwerk"})
public class ShifterResource {
    private final Logger log;
    @Value(value="${jhipster.clientApp.name}")
    private String applicationName;
    private final ShifterRepository shifterRepository;
    private final ShifterService shifterService;
    private final ResourceHelperService resourceHelperService;
    private final ServiceProviderRepositoryDbDirectSearch serviceProviderRepositoryDbDirectSearch;

    @PostMapping(value={"/shifters"})
    @NotNull
    public ResponseEntity<ShortEntityObject> createShifter(@RequestBody @NotNull Shifter shifter) {
        Intrinsics.checkParameterIsNotNull((Object)shifter, (String)"shifter");
        this.log.debug("REST request to save Shifter : {}", (Object)shifter);
        if (shifter.getId() != null) {
            throw (Throwable)new BadRequestAlertException("A new shifter cannot already have an ID", "shifter", "idexists");
        }
        String string = ((Userprofile)CollectionsKt.first((Iterable)shifter.getUsers())).getId();
        if (string == null) {
            Intrinsics.throwNpe();
        }
        this.resourceHelperService.isCurrentUserPowerUserOrGivenUserAndThrow(string);
        ShortEntityObject result = this.shifterService.create(shifter);
        ResponseEntity responseEntity = ((ResponseEntity.BodyBuilder)ResponseEntity.created((URI)new URI("/api/shifters/" + result.getId())).headers(HeaderUtil.createEntityCreationAlert((String)this.applicationName, (boolean)true, (String)"shifter", (String)String.valueOf(result.getId())))).body((Object)result);
        Intrinsics.checkExpressionValueIsNotNull((Object)responseEntity, (String)"ResponseEntity.created(U\u2026            .body(result)");
        return responseEntity;
    }

    @PostMapping(value={"/shiftersMigr"})
    @NotNull
    public ResponseEntity<ShortEntityObject> createShifterMigr(@RequestBody @NotNull Shifter shifter) {
        Intrinsics.checkParameterIsNotNull((Object)shifter, (String)"shifter");
        this.log.error("REST request to save createShifterMigr only in dev : {}", (Object)shifter);
        if (shifter.getId() != null) {
            throw (Throwable)new BadRequestAlertException("A new shifter cannot already have an ID", "shifter", "idexists");
        }
        ShortEntityObject result = this.shifterService.create(shifter);
        ResponseEntity responseEntity = ((ResponseEntity.BodyBuilder)ResponseEntity.created((URI)new URI("/api/shifters/" + result.getId())).headers(HeaderUtil.createEntityCreationAlert((String)this.applicationName, (boolean)true, (String)"shifter", (String)String.valueOf(result.getId())))).body((Object)result);
        Intrinsics.checkExpressionValueIsNotNull((Object)responseEntity, (String)"ResponseEntity.created(U\u2026            .body(result)");
        return responseEntity;
    }

    @PutMapping(value={"/shifters"})
    @Transactional
    @NotNull
    public ResponseEntity<String> updateShifter(@RequestBody @NotNull Shifter shifter) {
        Intrinsics.checkParameterIsNotNull((Object)shifter, (String)"shifter");
        this.log.debug("REST request to update Shifter : {}", (Object)shifter);
        if (shifter.getId() == null) {
            throw (Throwable)new BadRequestAlertException("Invalid id", "shifter", "idnull");
        }
        Long l = shifter.getId();
        if (l == null) {
            Intrinsics.throwNpe();
        }
        this.resourceHelperService.isCurrentUserPowerUserOrOneOfTheShifterAndThrowIfNotAllowed(l.longValue());
        this.shifterService.update(shifter);
        ResponseEntity responseEntity = ((ResponseEntity.BodyBuilder)ResponseEntity.ok().headers(HeaderUtil.createEntityUpdateAlert((String)this.applicationName, (boolean)true, (String)"shifter", (String)String.valueOf(shifter.getId())))).body((Object)"OK");
        Intrinsics.checkExpressionValueIsNotNull((Object)responseEntity, (String)"ResponseEntity.ok()\n    \u2026)\n            .body(\"OK\")");
        return responseEntity;
    }

    @PutMapping(value={"/shifters/{id}/addService"})
    @NotNull
    public ResponseEntity<ShortIdAnswer> addService2Shifter(@PathVariable long id, @RequestBody @NotNull Offeredservice offeredservice) {
        Intrinsics.checkParameterIsNotNull((Object)offeredservice, (String)"offeredservice");
        this.resourceHelperService.isCurrentUserPowerUserOrOneOfTheShifterAndThrowIfNotAllowed(id);
        ShortIdAnswer result = this.shifterService.addService2Shifter(id, offeredservice);
        ResponseEntity responseEntity = ((ResponseEntity.BodyBuilder)ResponseEntity.ok().headers(HeaderUtil.createEntityUpdateAlert((String)this.applicationName, (boolean)true, (String)"shifter", (String)String.valueOf(id)))).body((Object)result);
        Intrinsics.checkExpressionValueIsNotNull((Object)responseEntity, (String)"ResponseEntity.ok()\n    \u2026            .body(result)");
        return responseEntity;
    }

    @GetMapping(value={"/shifters/{id}"})
    @Transactional(readOnly=true)
    @NotNull
    public ResponseEntity<ShifterOverviewHateOasResource> getShifter(@PathVariable long id) {
        this.log.debug("REST request to get Shifter : {}", (Object)id);
        this.resourceHelperService.isCurrentUserPowerUserOrOneOfTheShifterAndThrowIfNotAllowed(id);
        Shifter shifter = (Shifter)CrudRepositoryExtensionsKt.findByIdOrNull((CrudRepository)((CrudRepository)this.shifterRepository), (Object)id);
        if (shifter != null) {
            Shifter shifter2 = shifter;
            boolean bl = false;
            boolean bl2 = false;
            Shifter it = shifter2;
            boolean bl3 = false;
            Long l = it.getId();
            if (l == null) {
                Intrinsics.throwNpe();
            }
            Pair res = this.serviceProviderRepositoryDbDirectSearch.findServiceIdSummaryByShifter(l.longValue());
            Set offeredServices = (Set)res.getSecond();
            Set offeredServiceRequests = (Set)res.getFirst();
            ResponseEntity responseEntity = ResponseEntity.ok((Object)new ShifterOverviewHateOasResource(new ShifterHateOasDomainObject(it, offeredServiceRequests, offeredServices)));
            Intrinsics.checkExpressionValueIsNotNull((Object)responseEntity, (String)"ResponseEntity.ok(Shifte\u2026uests, offeredServices)))");
            return responseEntity;
        }
        ResponseEntity responseEntity = ResponseUtil.wrapOrNotFound(Optional.empty());
        Intrinsics.checkExpressionValueIsNotNull((Object)responseEntity, (String)"ResponseUtil.wrapOrNotFound(Optional.empty())");
        return responseEntity;
    }

    @DeleteMapping(value={"/shifters/{id}"})
    @NotNull
    public ResponseEntity<Void> deleteShifter(@PathVariable long id) {
        this.log.debug("REST request to delete Shifter : {}", (Object)id);
        this.resourceHelperService.isCurrentUserPowerUserOrOneOfTheShifterAndThrowIfNotAllowed(id);
        this.shifterRepository.deleteById((Object)id);
        ResponseEntity responseEntity = ResponseEntity.noContent().headers(HeaderUtil.createEntityDeletionAlert((String)this.applicationName, (boolean)true, (String)"shifter", (String)String.valueOf(id))).build();
        Intrinsics.checkExpressionValueIsNotNull((Object)responseEntity, (String)"ResponseEntity.noContent\u2026, id.toString())).build()");
        return responseEntity;
    }

    public ShifterResource(@NotNull ShifterRepository shifterRepository, @NotNull ShifterService shifterService, @NotNull ResourceHelperService resourceHelperService, @NotNull ServiceProviderRepositoryDbDirectSearch serviceProviderRepositoryDbDirectSearch) {
        Intrinsics.checkParameterIsNotNull((Object)shifterRepository, (String)"shifterRepository");
        Intrinsics.checkParameterIsNotNull((Object)shifterService, (String)"shifterService");
        Intrinsics.checkParameterIsNotNull((Object)resourceHelperService, (String)"resourceHelperService");
        Intrinsics.checkParameterIsNotNull((Object)serviceProviderRepositoryDbDirectSearch, (String)"serviceProviderRepositoryDbDirectSearch");
        this.shifterRepository = shifterRepository;
        this.shifterService = shifterService;
        this.resourceHelperService = resourceHelperService;
        this.serviceProviderRepositoryDbDirectSearch = serviceProviderRepositoryDbDirectSearch;
        this.log = LoggerFactory.getLogger(this.getClass());
    }
}

